/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.preference;

import org.eclipse.jface.preference.IPreferenceStore;

import jp.valtech.bts.ui.BtsPlugin;

/**
 * パースペクティブの設定を取得するためのクラスです。
 * {@link IPreferenceStore}を使いやすくラップしたクラスです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class BtsPreference {

	/** 唯一のインスタンスです。 */
	private static BtsPreference instance;
	
	/** IPreferenceStoreを保持します。 */
	private IPreferenceStore preference = BtsPlugin.getInstance().getPreferenceStore();

	/**
	 * 唯一のインスタンスを取得します。
	 * 
	 * @return		唯一のインスタンス
	 */
	public static synchronized BtsPreference getInstance() {
		if(instance == null) {
			instance = new BtsPreference();
		}
		return instance;
	}
	
	/**
	 * 外部からは呼ばれません。
	 */
	private BtsPreference() {
		;
	}
	/**
	 * <DL>
	 * <DT><B>マルチキャストポート番号 を戻します。</B></B>
	 * <DD>マルチキャストポート番号をIntegerのプリミティブ型intで取得します。</DD>
	 * </DL>
	 * 
	 * @return マルチキャストポート番号
	 */
	public int getMulticastPort() {
		String port = preference.getString(NetworkPreferencePage.MULTIPORT);
		if(port == null || port.trim().equals("")) {
			return NetworkPreferencePage.DEFAULT_MULTIPORT;
		}
		return Integer.parseInt(port);
	}
	
	/**
	 * <DL>
	 * <DT><B>マルチキャストアドレス を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * 
	 * @return マルチキャストアドレス
	 */
	public String getMulticastAddress() {
		String address1 = preference.getString(NetworkPreferencePage.ADDRESS1);
		if(address1 == null || address1.trim().equals("")) {
			address1 = String.valueOf(NetworkPreferencePage.DEFAULT_ADDRESS1);
		}

		String address2 = preference.getString(NetworkPreferencePage.ADDRESS2);
		if(address2 == null || address2.trim().equals("")) {
			address2 = String.valueOf(NetworkPreferencePage.DEFAULT_ADDRESS2);
		}

		String address3 = preference.getString(NetworkPreferencePage.ADDRESS3);
		if(address3 == null || address3.trim().equals("")) {
			address3 = String.valueOf(NetworkPreferencePage.DEFAULT_ADDRESS3);
		}

		String address4 = preference.getString(NetworkPreferencePage.ADDRESS4);
		if(address4 == null || address4.trim().equals("")) {
			address4 = String.valueOf(NetworkPreferencePage.DEFAULT_ADDRESS4);
		}

		StringBuffer buf = new StringBuffer();
		buf.append(address1);
		buf.append( "." );
		buf.append(address2);
		buf.append( "." );
		buf.append(address3);
		buf.append( "." );
		buf.append(address4);

		return buf.toString();
	}
	
	/**
	 * <DL>
	 * <DT><B>TCPデータ通信ポート番号 を戻します。</B></B>
	 * <DD>TCPデータ通信ポート番号をIntegerのプリミティブ型intで取得します。</DD>
	 * </DL>
	 * 
	 * @return TCPデータ通信ポート番号
	 */
	public int getTCPPort() {
		String port = preference.getString(NetworkPreferencePage.TCPPORT);
		if(port == null || port.trim().equals("")) {
			return NetworkPreferencePage.DEFAULT_TCPPORT;
		}
		return Integer.parseInt(port);
	}

	/**
	 * 配信処理のタイムアウト（秒）を戻します。
	 * 
	 * @return		配信処理のタイムアウト（秒）
	 */
	public int getSendTimeout() {
		String timeout = preference.getString(NetworkPreferencePage.SEND_TIMEOUT);
		if(timeout == null || timeout.trim().equals("")) {
			return NetworkPreferencePage.DEFAULT_SEND_TIMEOUT * 1000;
		}
	
		int msec = Integer.parseInt(timeout);
		return msec * 1000;
	}
	
	/**
	 * 同期処理のタイムアウト（秒）を戻します。
	 * 
	 * @return		同期処理のタイムアウト（秒）
	 */
	public int getSyncTimeout() {
		String timeout = preference.getString(NetworkPreferencePage.SYNC_TIMEOUT);
		if(timeout == null || timeout.trim().equals("")) {
			return NetworkPreferencePage.DEFAULT_SYNC_TIMEOUT * 1000;
		}
	
		int msec = Integer.parseInt(timeout);
		return msec * 1000;
	}
	
}
