/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <dl><dt><b>ロギングを行うための定義インタフェースです。</b></dt>
 * <dd>ロギングを行いたいクラスでは、このインタフェースを使用してください。<br>
 * このロギングは<code><a href="http://jakarta.apache.org/commons/logging/">Commons Logging</a></code>を使用しています。
 * Commons Loggingを使用するには、ソースのルートディレクトリに、<code>commons-logging.properties</code>が必要です。<br>
 * ロギングに<a href="http://logging.apache.org/log4j/docs/">Apache Log4J</a>を利用する場合は以下のように指定します。
 * <blockquote><pre>
 * org.apache.commons.logging.Log=org.apache.commons.logging.impl.Log4JLogger
 * </pre></blockquote>
 * そのほか
 * <table>
 * 	<tr><td>org.apache.commons.logging.impl.Jdk14Logger</td><td>DK1.4で搭載されたLogを使用する。</td></tr>
 * 	<tr><td>org.apache.commons.logging.impl.Log4JLogger</td><td>Log4Jを使用する。</td></tr>
 * 	<tr><td>org.apache.commons.logging.impl.LogKitLogger</td><td>avalon-LogkitのLogを使用する。</td></tr>
 * 	<tr><td>org.apache.commons.logging.impl.SimpleLog</td><td>common-loggingのデフォルト実装。標準エラー出力に対して出力する。</td></tr>
 * 	<tr><td>org.apache.commons.logging.impl.NoOpLog</td><td>全てのログ出力を抑制する。</td></tr>
 * </table>
 * がありますので目的に応じて利用してください。<br><br>
 * また、<a href="http://logging.apache.org/log4j/docs/">Apache Log4J</a>を使用する場合でその設定ファイルを利用する場合には
 * ソースのルートディレクトリの直下に<code>log4j.xml</code>または<code>log4j.properties</code>という名前でおいてください。
 * </dd>
 * </dl>
 * 
 * @author		<A href="mailto:iinuma@valtech.jp">K.Iinuma</A>
 * @version	Ver.0.8
 */
public interface Logging {

	/** */
	public static final Log logger = LogFactory.getLog( Logging.class );

}
