/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.command.server;

import java.util.List;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.facade.SyncHeaderFacade;
import jp.valtech.bts.facade.SyncServerFacade;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.Response;
import jp.valtech.bts.network.command.TCPServerCommand;

public class SyncIssueServer
extends TCPServerCommand {
    public void execute(Request request, Response response, NetworkConfig myconfig) {
        try {
            SyncHeaderFacade syncHeaderFacade = new SyncHeaderFacade();
            List localIssueHeader = syncHeaderFacade.getIssueHeaderList();
            List localGarbageHeader = syncHeaderFacade.getGarbageHeaderList();
            if (localIssueHeader == null && localGarbageHeader == null) {
                response.setCode("okay");
                response.addParameter("issueList", null);
                response.addParameter("garbageList", null);
                this.reply(response);
                return;
            }
            List receiveIssueHeader = (List)request.getParameterObject("issueHeader");
            List receiveGarbageHeader = (List)request.getParameterObject("garbageHeader");
            if (localIssueHeader != null && receiveIssueHeader != null) {
                localIssueHeader.removeAll(receiveIssueHeader);
            }
            if (localGarbageHeader != null && receiveGarbageHeader != null) {
                localGarbageHeader.removeAll(receiveGarbageHeader);
            }
            SyncServerFacade facade = new SyncServerFacade();
            facade.readSyncIssues(localIssueHeader, localGarbageHeader);
            response.addParameter("syncIssues", facade.getSyncIssues());
            response.addParameter("syncGarbages", facade.getSyncGarbages());
            response.setCode("okay");
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            response.setMessage(e.getMessage());
            response.setCode("error");
        }
        this.reply(response);
    }
}

