/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.dao;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import jp.valtech.bts.connection.DBConnection;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.dao.DataBaseAccessor;
import jp.valtech.bts.data.CommentHistory;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class CommentHistoryDAO
extends DataBaseAccessor {
    private static final String CREATE_TABLE = "CREATE TABLE COMMENTHISTORY ( FINGERPRINT CHAR(40) , TYPE     \t  CHAR(1) , DESCRIPTION LONGVARCHAR , UPDATEUSER  VARCHAR(30) , UPDATEDATE  TIMESTAMP ) ;";
    private static final String DROP_TABLE = "DROP TABLE COMMENTHISTORY CASCADE;";
    private static final String INSERT_SQL = "INSERT INTO COMMENTHISTORY ( FINGERPRINT , TYPE , DESCRIPTION , UPDATEUSER , UPDATEDATE ) VALUES (?, ?, ?, ?, ?)";
    private static final String DELETE_SQL = "DELETE FROM COMMENTHISTORY WHERE FINGERPRINT=? AND TYPE=?";
    private static final String UPDATE_GARBAGE = "UPDATE COMMENTHISTORY SET TYPE='G' WHERE FINGERPRINT=? AND TYPE='R'";
    private static final String SELECT_ALL = "SELECT   FINGERPRINT , TYPE , DESCRIPTION , UPDATEUSER , UPDATEDATE FROM COMMENTHISTORY";
    private static final String SELECT_BY_FINGERPRINT = "SELECT   FINGERPRINT , TYPE , DESCRIPTION , UPDATEUSER , UPDATEDATE FROM COMMENTHISTORY WHERE FINGERPRINT=? AND TYPE=? ORDER BY UPDATEDATE DESC";
    static /* synthetic */ Class class$0;

    public CommentHistoryDAO(DBConnection connection) {
        super(connection);
    }

    public void createTable() throws BtsDBException {
        try {
            new QueryRunner().update(this.con, CREATE_TABLE);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void dropTable() throws BtsDBException {
        try {
            new QueryRunner().update(this.con, DROP_TABLE);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void addComment(CommentHistory commentHistory) throws BtsDBException {
        try {
            ArrayList<Object> param = new ArrayList<Object>();
            param.add(commentHistory.getFingerPrint());
            param.add(commentHistory.getType());
            param.add(commentHistory.getDescription());
            param.add(commentHistory.getUpdateUser());
            if (commentHistory.getUpdateDate() != null) {
                param.add(new Timestamp(commentHistory.getUpdateDateTimestamp()));
            } else {
                param.add(null);
            }
            new QueryRunner().update(this.con, INSERT_SQL, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void deleteByFingerPrint(String fingerPrint, String type) throws BtsDBException {
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(fingerPrint);
            param.add(type);
            new QueryRunner().update(this.con, DELETE_SQL, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public CommentHistory[] getByFingerPrint(String fingerPrint, String type) throws BtsDBException {
        CommentHistory[] commentHistories = new CommentHistory[]{};
        ArrayList<String> param = new ArrayList<String>();
        param.add(fingerPrint);
        param.add(type);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.valtech.bts.data.CommentHistory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BeanListHandler rsh = new BeanListHandler((Class)clazz);
            List result = (List)new QueryRunner().query(this.con, SELECT_BY_FINGERPRINT, param.toArray(), (ResultSetHandler)rsh);
            commentHistories = result.toArray(commentHistories);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
        return commentHistories;
    }

    public void changeGarbageVersion(String fingerPrint) throws BtsDBException {
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(fingerPrint);
            new QueryRunner().update(this.con, UPDATE_GARBAGE, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }
}

