/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.dao;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import jp.valtech.bts.connection.DBConnection;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.dao.DataBaseAccessor;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueSyncHeader;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class IssueDAO
extends DataBaseAccessor {
    private static final String CREATE_TABLE = "CREATE TABLE ISSUE ( ISSUEID        INTEGER DEFAULT 0 , FINGERPRINT    CHAR(40) , TYPE           CHAR(1) , CATEGORY       VARCHAR(40) , TITLE          VARCHAR(90) , DESCRIPTION    LONGVARCHAR , PRIORITY       VARCHAR(40) , DEADLINE       TIMESTAMP , STATUS         CHAR(1) DEFAULT '1' , ASSIGNED       VARCHAR(40) , SECRETBUG      BOOLEAN DEFAULT false , SUSPEND        BOOLEAN DEFAULT false , VERSION        INTEGER DEFAULT 0  , CREATEUSER     VARCHAR(40)  , CREATEDATE     TIMESTAMP , UPDATEDATE     TIMESTAMP ) ;CREATE INDEX IDX_ISSUE ON ISSUE(FINGERPRINT) ;";
    private static final String DROP_TABLE = "DROP TABLE ISSUE CASCADE";
    private static final String INSERT_SQL = "INSERT INTO ISSUE ( ISSUEID , FINGERPRINT , TYPE , CATEGORY , TITLE , DESCRIPTION , PRIORITY , DEADLINE , STATUS , ASSIGNED , SECRETBUG , SUSPEND , VERSION , CREATEUSER , CREATEDATE , UPDATEDATE )  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_TABLE = "UPDATE ISSUE    SET ISSUEID=?     , TYPE=?     , CATEGORY=?     , TITLE=?     , DESCRIPTION=?     , PRIORITY=?     , DEADLINE=?     , STATUS=?     , ASSIGNED=?     , SECRETBUG=?     , SUSPEND=?     , VERSION=?     , CREATEUSER=?     , CREATEDATE=?     , UPDATEDATE=? WHERE FINGERPRINT=? AND TYPE=?";
    private static final String UPDATTE_RELEASE = "UPDATE ISSUE SET TYPE='R' WHERE FINGERPRINT=? AND TYPE='D'";
    private static final String UPDATE_GARBAGE = "UPDATE ISSUE SET TYPE='G' WHERE FINGERPRINT=? AND TYPE='R'";
    private static final String SELECT_ALL = "SELECT    nvl(ISSUEID, 0) ISSUEID  , FINGERPRINT  , TYPE  , CATEGORY  , TITLE  , DESCRIPTION  , PRIORITY  , DEADLINE  , nvl(STATUS, '1') STATUS  , ASSIGNED  , nvl(SECRETBUG, false) SECRETBUG  , nvl(SUSPEND, false) SUSPEND  , VERSION  , CREATEUSER  , CREATEDATE  , UPDATEDATE   FROM ISSUE";
    private static final String SELECT_ALL_ORDER = "SELECT    nvl(ISSUEID, 0) ISSUEID  , FINGERPRINT  , TYPE  , CATEGORY  , TITLE  , DESCRIPTION  , PRIORITY  , DEADLINE  , nvl(STATUS, '1') STATUS  , ASSIGNED  , nvl(SECRETBUG, false) SECRETBUG  , nvl(SUSPEND, false) SUSPEND  , VERSION  , CREATEUSER  , CREATEDATE  , UPDATEDATE   FROM ISSUE ORDER BY ISSUEID DESC";
    private static final String SELECT_BY_FINGERPRINT = "SELECT    nvl(ISSUEID, 0) ISSUEID  , FINGERPRINT  , TYPE  , CATEGORY  , TITLE  , DESCRIPTION  , PRIORITY  , DEADLINE  , nvl(STATUS, '1') STATUS  , ASSIGNED  , nvl(SECRETBUG, false) SECRETBUG  , nvl(SUSPEND, false) SUSPEND  , VERSION  , CREATEUSER  , CREATEDATE  , UPDATEDATE   FROM ISSUE WHERE FINGERPRINT=? AND TYPE=?";
    private static final String GET_MAX_ISSUEID = "SELECT MAX(ISSUEID) FROM ISSUE ";
    private static final String DELETE_BY_FINGERPRINT = "DELETE FROM ISSUE WHERE FINGERPRINT=? AND TYPE=?";
    private static final String SELECT_BY_TYPE = "SELECT    nvl(ISSUEID, 0) ISSUEID  , FINGERPRINT  , TYPE  , CATEGORY  , TITLE  , DESCRIPTION  , PRIORITY  , DEADLINE  , nvl(STATUS, '1') STATUS  , ASSIGNED  , nvl(SECRETBUG, false) SECRETBUG  , nvl(SUSPEND, false) SUSPEND  , VERSION  , CREATEUSER  , CREATEDATE  , UPDATEDATE   FROM ISSUE WHERE TYPE=?";
    private static final String SELECT_BY_TYPE_R = "SELECT    nvl(ISSUEID, 0) ISSUEID  , FINGERPRINT  , TYPE  , CATEGORY  , TITLE  , DESCRIPTION  , PRIORITY  , DEADLINE  , nvl(STATUS, '1') STATUS  , ASSIGNED  , nvl(SECRETBUG, false) SECRETBUG  , nvl(SUSPEND, false) SUSPEND  , VERSION  , CREATEUSER  , CREATEDATE  , UPDATEDATE   FROM ISSUE WHERE TYPE='R'";
    private static final String GET_SYNC_HEADER = "SELECT   FINGERPRINT , VERSION , UPDATEDATE  FROM ISSUE WHERE TYPE=?";
    private static final String GET_ASSIGNED = "SELECT DISTINCT ASSIGNED FROM ISSUE";
    private static final String GET_ASSIGNED_BY_TYPE_R = "SELECT DISTINCT ASSIGNED FROM (SELECT    nvl(ISSUEID, 0) ISSUEID  , FINGERPRINT  , TYPE  , CATEGORY  , TITLE  , DESCRIPTION  , PRIORITY  , DEADLINE  , nvl(STATUS, '1') STATUS  , ASSIGNED  , nvl(SECRETBUG, false) SECRETBUG  , nvl(SUSPEND, false) SUSPEND  , VERSION  , CREATEUSER  , CREATEDATE  , UPDATEDATE   FROM ISSUE WHERE TYPE='R')";
    private static final String GET_CATEGORY_BY_TYPE_R = "SELECT DISTINCT CATEGORY FROM (SELECT    nvl(ISSUEID, 0) ISSUEID  , FINGERPRINT  , TYPE  , CATEGORY  , TITLE  , DESCRIPTION  , PRIORITY  , DEADLINE  , nvl(STATUS, '1') STATUS  , ASSIGNED  , nvl(SECRETBUG, false) SECRETBUG  , nvl(SUSPEND, false) SUSPEND  , VERSION  , CREATEUSER  , CREATEDATE  , UPDATEDATE   FROM ISSUE WHERE TYPE='R')";
    private static final String GET_PRIORITY = "SELECT DISTINCT PRIORITY FROM ISSUE";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IssueDAO(DBConnection connection) {
        super(connection);
    }

    public void createTable() throws BtsDBException {
        try {
            new QueryRunner().update(this.con, CREATE_TABLE);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void dropTable() throws BtsDBException {
        try {
            new QueryRunner().update(this.con, DROP_TABLE);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void addIssue(Issue issue) throws BtsDBException {
        try {
            ArrayList<Object> param = new ArrayList<Object>();
            param.add(new Integer(issue.getIssueID()));
            param.add(issue.getFingerPrint());
            param.add(issue.getType());
            param.add(issue.getCategory());
            param.add(issue.getTitle());
            param.add(issue.getDescription());
            param.add(issue.getPriority());
            if (issue.getDeadline() != null) {
                param.add(new Timestamp(issue.getDeadline().getTime()));
            } else {
                param.add(null);
            }
            param.add(issue.getStatus());
            param.add(issue.getAssigned());
            param.add(issue.isSecretBug());
            param.add(issue.isSuspend());
            param.add(issue.getVersion());
            param.add(issue.getCreateUser());
            if (issue.getCreateDate() != null) {
                param.add(new Timestamp(issue.getCreateDate().getTime()));
            } else {
                param.add(null);
            }
            if (issue.getUpdateDate() != null) {
                param.add(new Timestamp(issue.getUpdateDate().getTime()));
            } else {
                param.add(null);
            }
            new QueryRunner().update(this.con, INSERT_SQL, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public int modifyIssue(Issue issue, String type) throws BtsDBException {
        try {
            ArrayList<Object> param = new ArrayList<Object>();
            param.add(new Integer(issue.getIssueID()));
            param.add(issue.getType());
            param.add(issue.getCategory());
            param.add(issue.getTitle());
            param.add(issue.getDescription());
            param.add(issue.getPriority());
            if (issue.getDeadline() != null) {
                param.add(new Timestamp(issue.getDeadline().getTime()));
            } else {
                param.add(null);
            }
            param.add(issue.getStatus());
            param.add(issue.getAssigned());
            param.add(issue.isSecretBug());
            param.add(issue.isSuspend());
            param.add(issue.getVersion());
            param.add(issue.getCreateUser());
            if (issue.getCreateDate() != null) {
                param.add(new Timestamp(issue.getCreateDate().getTime()));
            } else {
                param.add(null);
            }
            if (issue.getUpdateDate() != null) {
                param.add(new Timestamp(issue.getUpdateDate().getTime()));
            } else {
                param.add(null);
            }
            param.add(issue.getFingerPrint());
            param.add(type);
            return new QueryRunner().update(this.con, UPDATE_TABLE, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void changeReleaseVersion(String fingerPrint) throws BtsDBException {
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(fingerPrint);
            new QueryRunner().update(this.con, UPDATTE_RELEASE, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public Issue[] getAll() throws BtsDBException {
        List result = this.getIssueList();
        return result.toArray(new Issue[0]);
    }

    public List getIssueList() throws BtsDBException {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.valtech.bts.data.Issue");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BeanListHandler rsh = new BeanListHandler((Class)clazz);
            List issueList = (List)new QueryRunner().query(this.con, SELECT_ALL_ORDER, (ResultSetHandler)rsh);
            return issueList;
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public Issue getByFingerPrint(String fingerprint, String type) throws BtsDBException {
        Issue issue = null;
        ArrayList<String> param = new ArrayList<String>();
        param.add(fingerprint);
        param.add(type);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.valtech.bts.data.Issue");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BeanHandler rsh = new BeanHandler((Class)clazz);
            issue = (Issue)new QueryRunner().query(this.con, SELECT_BY_FINGERPRINT, param.toArray(), (ResultSetHandler)rsh);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
        return issue;
    }

    public int deleteByFingerPrint(String fingerprint, String type) throws BtsDBException {
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(fingerprint);
            param.add(type);
            return new QueryRunner().update(this.con, DELETE_BY_FINGERPRINT, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public int getUsefulIssueCnt() throws BtsDBException {
        Object result;
        block3: {
            try {
                ScalarHandler rsh = new ScalarHandler(1);
                result = new QueryRunner().query(this.con, GET_MAX_ISSUEID, (ResultSetHandler)rsh);
                if (result != null) break block3;
                return 0;
            }
            catch (Exception e) {
                throw new BtsDBException(e);
            }
        }
        return Integer.parseInt(result.toString());
    }

    public List getByType(String type) throws BtsDBException {
        ArrayList<String> param = new ArrayList<String>();
        param.add(type);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.valtech.bts.data.Issue");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BeanListHandler rsh = new BeanListHandler((Class)clazz);
            List issueList = (List)new QueryRunner().query(this.con, SELECT_BY_TYPE, param.toArray(), (ResultSetHandler)rsh);
            return issueList;
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public List getGarbageList() throws BtsDBException {
        ArrayList<String> param = new ArrayList<String>();
        param.add("G");
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.valtech.bts.data.Issue");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BeanListHandler rsh = new BeanListHandler((Class)clazz);
            List issueList = (List)new QueryRunner().query(this.con, SELECT_BY_TYPE, param.toArray(), (ResultSetHandler)rsh);
            return issueList;
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public String[] getAssigned() throws BtsDBException {
        try {
            ArrayListHandler rsh = new ArrayListHandler();
            List list = (List)new QueryRunner().query(this.con, GET_ASSIGNED, (ResultSetHandler)rsh);
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < list.size()) {
                if (((Object[])list.get(i))[0] != null && !"".equals(((Object[])list.get(i))[0])) {
                    result.add(((Object[])list.get(i))[0]);
                }
                ++i;
            }
            return result.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public String[] getAssignedTypeR() throws BtsDBException {
        try {
            ArrayListHandler rsh = new ArrayListHandler();
            List list = (List)new QueryRunner().query(this.con, GET_ASSIGNED_BY_TYPE_R, (ResultSetHandler)rsh);
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < list.size()) {
                if (((Object[])list.get(i))[0] != null && !"".equals(((Object[])list.get(i))[0])) {
                    result.add(((Object[])list.get(i))[0]);
                }
                ++i;
            }
            return result.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public String[] getCategoryTypeR() throws BtsDBException {
        try {
            ArrayListHandler rsh = new ArrayListHandler();
            List list = (List)new QueryRunner().query(this.con, GET_CATEGORY_BY_TYPE_R, (ResultSetHandler)rsh);
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < list.size()) {
                if (((Object[])list.get(i))[0] != null && !"".equals(((Object[])list.get(i))[0])) {
                    result.add(((Object[])list.get(i))[0]);
                }
                ++i;
            }
            return result.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public String[] getPriority() throws BtsDBException {
        try {
            ArrayListHandler rsh = new ArrayListHandler();
            List list = (List)new QueryRunner().query(this.con, GET_PRIORITY, (ResultSetHandler)rsh);
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < list.size()) {
                if (((Object[])list.get(i))[0] != null && !"".equals(((Object[])list.get(i))[0])) {
                    result.add(((Object[])list.get(i))[0]);
                }
                ++i;
            }
            return result.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void changeGarbageVersion(String fingerPrint) throws BtsDBException {
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(fingerPrint);
            new QueryRunner().update(this.con, UPDATE_GARBAGE, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public List getIssueSyncHeaders(String type) throws BtsDBException {
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("jp.valtech.bts.data.IssueSyncHeader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BeanListHandler rsh = new BeanListHandler((Class)clazz);
            return (List)new QueryRunner().query(this.con, GET_SYNC_HEADER, (Object)type, (ResultSetHandler)rsh);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public List getGarbageSyncList() throws BtsDBException {
        List list;
        block8: {
            BeanListHandler rsh;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("jp.valtech.bts.data.IssueSyncHeader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((list = (List)new QueryRunner().query(this.con, GET_SYNC_HEADER, (Object)"G", (ResultSetHandler)(rsh = new BeanListHandler((Class)clazz)))) != null && !list.isEmpty()) break block8;
            return null;
        }
        try {
            ArrayList<String> result = new ArrayList<String>();
            int i = 0;
            while (i < list.size()) {
                result.add(((IssueSyncHeader)list.get(i)).getFingerPrint());
                ++i;
            }
            return result;
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }
}

