/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.data;

import jp.valtech.bts.data.Messages;

public final class MessageType {
    private String description;
    private String value;
    public static final String USER_VALUE = "U";
    public static final String ISSUE_VALUE = "I";
    public static final String CONFLICT_VALUE = "C";
    public static final String SYNC_VALUE = "S";
    public static final MessageType USER = new MessageType("U", Messages.getString("MessageType.0"));
    public static final MessageType ISSUE = new MessageType("I", Messages.getString("MessageType.1"));
    public static final MessageType CONFLICT = new MessageType("C", Messages.getString("MessageType.2"));
    public static final MessageType SYNC = new MessageType("S", Messages.getString("MessageType.3"));

    private MessageType(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static MessageType[] getEnums() {
        return new MessageType[]{USER, ISSUE, CONFLICT, SYNC};
    }

    public static MessageType getEnumByValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Invalid MessageType-value : null");
        }
        MessageType[] msgType = MessageType.getEnums();
        int idx = 0;
        while (idx < msgType.length) {
            if (value.equals(msgType[idx].getValue())) {
                return msgType[idx];
            }
            ++idx;
        }
        throw new IllegalArgumentException("Invalid MessageType-value : " + value);
    }

    public static MessageType getEnumByDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("Invalid MessageType-value : null");
        }
        MessageType[] issueType = MessageType.getEnums();
        int idx = 0;
        while (idx < issueType.length) {
            if (description.equals(issueType[idx].getDescription())) {
                return issueType[idx];
            }
            ++idx;
        }
        throw new IllegalArgumentException("Invalid MessageType-value : " + description);
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }
}

