/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.facade;

import java.util.Date;
import java.util.List;
import jp.valtech.bts.connection.IssueDBConnection;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.dao.CommentHistoryDAO;
import jp.valtech.bts.dao.IssueDAO;
import jp.valtech.bts.dao.IssueHistoryDAO;
import jp.valtech.bts.data.Attachment;
import jp.valtech.bts.data.CommentHistory;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueHistory;
import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.facade.AttachmentFacade;
import jp.valtech.bts.facade.MessagePacketFacade;
import jp.valtech.bts.facade.Messages;
import jp.valtech.bts.ui.BtsException;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.Logging;

public class ReceiveReleaseIssueFacade
implements Logging {
    private static final int RECEIVE_NEW_ISSUE = 0;
    private static final int RECEIVE_UPDATE_ISSUE = 1;
    private static final int RECEIVE_CONFLICT_ISSUE = 2;
    private int receiveMode = 0;
    private Issue receiveIssue;
    private Integer localVersion;

    /*
     * Exception decompiling
     */
    public void saveReceivedIssue(Issue receiveIssue) throws BtsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 298->302)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteConflictIssue(Issue receiveIssue, IssueDBConnection dbcon) throws Exception {
        IssueDAO issueDAO = new IssueDAO(dbcon);
        String fingerPrint = receiveIssue.getFingerPrint();
        Issue conflictIssue = issueDAO.getByFingerPrint(fingerPrint, "C");
        if (conflictIssue == null) {
            return;
        }
        issueDAO.deleteByFingerPrint(fingerPrint, "C");
        AttachmentFacade.deleteAll(fingerPrint, "C", dbcon);
        IssueHistoryDAO historyDAO = new IssueHistoryDAO(dbcon);
        historyDAO.deleteByFingerPrint(fingerPrint, "C");
        CommentHistoryDAO commentHistoryDAO = new CommentHistoryDAO(dbcon);
        commentHistoryDAO.deleteByFingerPrint(fingerPrint, "C");
        List listeners = BtsPlugin.getInstance().getListeners();
        int idx = 0;
        while (idx < listeners.size()) {
            IBtsListener listnener = (IBtsListener)listeners.get(idx);
            listnener.deleteIssue(conflictIssue);
            ++idx;
        }
    }

    private void addConflictIssue(Issue receiveIssue, IssueDBConnection dbcon) throws BtsDBException {
        IssueDAO dao = new IssueDAO(dbcon);
        dao.addIssue(receiveIssue);
        List listeners = BtsPlugin.getInstance().getListeners();
        int idx = 0;
        while (idx < listeners.size()) {
            IBtsListener listnener = (IBtsListener)listeners.get(idx);
            listnener.addIssue(receiveIssue);
            ++idx;
        }
    }

    private void setConflict(Issue receiveIssue, IssueHistory[] histories, CommentHistory[] comment) {
        int i;
        receiveIssue.setType("C");
        Attachment[] attachments = receiveIssue.getAttachments();
        if (attachments != null) {
            i = 0;
            while (i < attachments.length) {
                attachments[i].setType("C");
                ++i;
            }
        }
        i = 0;
        while (i < histories.length) {
            histories[i].setType("C");
            ++i;
        }
        if (comment != null) {
            i = 0;
            while (i < comment.length) {
                comment[i].setType("C");
                ++i;
            }
        }
    }

    private void addIssue(Issue receiveIssue, IssueDBConnection dbcon) throws BtsDBException {
        IssueDAO dao = new IssueDAO(dbcon);
        dao.addIssue(receiveIssue);
        List listeners = BtsPlugin.getInstance().getListeners();
        int idx = 0;
        while (idx < listeners.size()) {
            IBtsListener listnener = (IBtsListener)listeners.get(idx);
            listnener.addIssue(receiveIssue);
            ++idx;
        }
    }

    private void addCommentHistory(CommentHistory[] comment, IssueDBConnection dbcon) throws BtsDBException {
        if (comment == null || comment.length == 0) {
            return;
        }
        CommentHistoryDAO dao = new CommentHistoryDAO(dbcon);
        int i = 0;
        while (i < comment.length) {
            dao.addComment(comment[i]);
            ++i;
        }
    }

    private void deleteCommentHistory(CommentHistory[] comment, IssueDBConnection dbcon) throws BtsDBException {
        if (comment == null || comment.length == 0) {
            return;
        }
        CommentHistoryDAO dao = new CommentHistoryDAO(dbcon);
        dao.deleteByFingerPrint(comment[0].getFingerPrint(), "R");
    }

    private void addIssueHistory(IssueHistory[] histories, IssueDBConnection dbcon) throws BtsDBException {
        IssueHistoryDAO dao = new IssueHistoryDAO(dbcon);
        int i = 0;
        while (i < histories.length) {
            dao.addHistory(histories[i]);
            ++i;
        }
    }

    private void deleteIssueHistory(String fingerprint, IssueDBConnection dbcon) throws BtsDBException {
        IssueHistoryDAO dao = new IssueHistoryDAO(dbcon);
        dao.deleteByFingerPrint(fingerprint, "R");
    }

    private void addConflictIssueHistory(IssueHistory[] histories, IssueDBConnection dbcon) throws BtsDBException {
        IssueHistoryDAO dao = new IssueHistoryDAO(dbcon);
        dao.deleteByFingerPrint(histories[0].getFingerPrint(), "C");
        int i = 0;
        while (i < histories.length) {
            dao.addHistory(histories[i]);
            ++i;
        }
    }

    private int updateIssue(Issue localIssue, Issue receiveIssue, IssueDBConnection dbcon) throws BtsDBException {
        IssueDAO dao = new IssueDAO(dbcon);
        int updateCount = dao.modifyIssue(receiveIssue, "R");
        List listeners = BtsPlugin.getInstance().getListeners();
        int idx = 0;
        while (idx < listeners.size()) {
            IBtsListener listnener = (IBtsListener)listeners.get(idx);
            listnener.updateIssue(localIssue, receiveIssue);
            ++idx;
        }
        return updateCount;
    }

    public void saveReceiveMessage(String fromUser, String fromAddr) {
        MessagePacket message = new MessagePacket();
        message.setFromUser(fromUser);
        message.setSent(System.currentTimeMillis());
        message.setFingerPrint(this.receiveIssue.getFingerPrint());
        if (this.receiveMode == 2) {
            message.setMessageType("C");
            message.setMessage(this.createConflictMessage(fromUser, fromAddr));
            message.setIssueType("C");
        } else {
            message.setMessageType("I");
            message.setMessage(this.createReceiveMessage(fromUser, fromAddr));
            message.setIssueType("R");
        }
        MessagePacketFacade facade = new MessagePacketFacade();
        facade.addMessage(message);
    }

    private String createReceiveMessage(String fromUser, String fromAddr) {
        StringBuffer msg = new StringBuffer();
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.1")).append(this.receiveIssue.getDisplayIssueID()).append("]");
        msg.append(this.receiveIssue.getTitle());
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.2"));
        msg.append("\n  (").append(fromAddr).append(")    ").append(fromUser);
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.3"));
        msg.append(BTSUtility.formatDate(new Date()));
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.4"));
        msg.append("\n  Ver.").append(this.receiveIssue.getVersion());
        return msg.toString();
    }

    private String createConflictMessage(String fromUser, String fromAddr) {
        StringBuffer msg = new StringBuffer();
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.5")).append(this.receiveIssue.getDisplayIssueID()).append("]");
        msg.append(this.receiveIssue.getTitle());
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.6"));
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.7"));
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.8"));
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.9"));
        msg.append("\n  (").append(fromAddr).append(")    ").append(fromUser);
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.10"));
        msg.append(BTSUtility.formatDate(new Date()));
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.11"));
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.12")).append(this.receiveIssue.getVersion());
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.13")).append(this.localVersion);
        return msg.toString();
    }

    /*
     * Exception decompiling
     */
    public void importReleaseIssue(Issue importIssue) throws BtsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 272->276)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void saveImportMessage() {
        MessagePacket message = new MessagePacket();
        IssueHistory[] histories = this.receiveIssue.getIssueHistories();
        String userName = histories[0].getUpdateUser();
        message.setFromUser(userName);
        message.setSent(System.currentTimeMillis());
        message.setFingerPrint(this.receiveIssue.getFingerPrint());
        message.setMessageType("I");
        StringBuffer msg = new StringBuffer();
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.15")).append(this.receiveIssue.getDisplayIssueID()).append("]");
        msg.append(this.receiveIssue.getTitle());
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.2"));
        msg.append("\n  ").append(userName);
        msg.append(Messages.getString("ReceiveReleaseIssueFacade.14"));
        message.setMessage(msg.toString());
        message.setIssueType("R");
        MessagePacketFacade facade = new MessagePacketFacade();
        facade.addMessage(message);
    }
}

