/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.network.command;

import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.Response;
import jp.valtech.bts.util.Logging;

public abstract class TCPServerCommand
implements Runnable,
Logging {
    private NetworkConfig myconfig = null;
    private Request request = null;
    private Socket socket = null;

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void setConfig(NetworkConfig myconfig) {
        this.myconfig = myconfig;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    protected void reply(Response response) {
        try {
            ObjectOutputStream os = new ObjectOutputStream(this.socket.getOutputStream());
            os.writeObject(response);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected InetAddress getRequestClient() {
        return this.socket.getInetAddress();
    }

    public void run() {
        Response response = new Response();
        this.execute(this.request, response, this.myconfig);
    }

    public abstract void execute(Request var1, Response var2, NetworkConfig var3);
}

