/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jp.valtech.bts.command.client.Leave;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.ui.IBtsListener;
import jp.valtech.bts.ui.Messages;
import jp.valtech.bts.ui.editor.IssueMultiPageEditor;
import jp.valtech.bts.ui.editor.IssueMultiPageEditorInput;
import jp.valtech.bts.ui.issuelist.IssueListView;
import jp.valtech.bts.ui.msglist.MessageListView;
import jp.valtech.bts.ui.navigator.IProjectDialogSettings;
import jp.valtech.bts.ui.navigator.NavigatorView;
import jp.valtech.bts.ui.navigator.ProjectDialogSettings;
import jp.valtech.bts.util.Logging;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BtsPlugin
extends AbstractUIPlugin
implements Logging {
    private static BtsPlugin plugin;
    public static final String ID_LISTENER = "jp.valtech.bts.listeners";
    public static final String ID_VIEW_ISSUELIST = "jp.valtech.bts.ui.issuelist.issueListView";
    public static final String ID_VIEW_MESSAGELIST = "jp.valtech.bts.ui.msglist.messageListView";
    public static final String ID_VIEW_NAVIGATOR = "jp.valtech.bts.ui.navigator.navigatorView";
    public static final String ID_EDITOR_ISSUE = "jp.valtech.bts.ui.editor.issueMultiPageEditor";
    private List listeners = new ArrayList();
    private ProjectDialogSettings projectDialogSettings = null;
    private static final String FN_DIALOG_SETTINGS = "project_settings.xml";

    public BtsPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        try {
            super.start(context);
            this.computeListeners();
        }
        catch (Exception e) {
            String msg = Messages.getString("BtsPlugin.0");
            logger.fatal((Object)msg, (Throwable)e);
            this.error(msg, e);
        }
    }

    public URL getURL(String filePath) {
        try {
            Bundle bundle = Platform.getBundle((String)this.getBundle().getSymbolicName());
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(filePath), null);
            if (url == null) {
                url = new URL(filePath);
            }
            return url;
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copy(String inputPath, String outputPath) {
        block21: {
            block19: {
                block17: {
                    block18: {
                        in = null;
                        out = null;
                        try {
                            try {
                                url = this.getURL(inputPath);
                                if (url == null) {
                                    var7_7 = null;
                                    if (in == null) break block17;
                                    break block18;
                                }
                                in = new BufferedInputStream(url.openStream());
                                out = new FileOutputStream(outputPath);
                                while ((c = in.read()) != -1) {
                                    out.write(c);
                                }
                                break block19;
                            }
                            catch (Exception e) {
                                this.error(e);
                                break block19;
                            }
                        }
                        catch (Throwable var8_14) {
                            var7_8 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    this.error(e);
                                }
                            }
                            if (out == null) throw var8_14;
                            try {
                                out.close();
                                throw var8_14;
                            }
                            catch (IOException e) {
                                this.error(e);
                            }
                            throw var8_14;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [5 : 93->100)] { 
lbl39:
                    // 1 sources

                    in.close();
                    break block17;
lbl41:
                    // 1 sources

                    catch (IOException e) {
                        this.error(e);
                    }
                }
                if (out == null) return;
                ** try [egrp 3[TRYBLOCK] [6 : 113->121)] { 
lbl46:
                // 1 sources

                out.close();
                return;
lbl48:
                // 1 sources

                catch (IOException e) {
                    this.error(e);
                }
                return;
            }
            var7_9 = null;
            if (in != null) {
                ** try [egrp 2[TRYBLOCK] [5 : 93->100)] { 
lbl55:
                // 1 sources

                in.close();
                break block21;
lbl57:
                // 1 sources

                catch (IOException e) {
                    this.error(e);
                }
            }
        }
        if (out == null) return;
        try {}
        catch (IOException e) {
            this.error(e);
            return;
        }
        out.close();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.saveProjectDialogSettings();
        CurrentProject current = CurrentProject.getInsance();
        if (current.isOpen()) {
            Leave leave = new Leave(new NetworkConfig());
            leave.execute();
        }
        plugin = null;
    }

    public static BtsPlugin getInstance() {
        return plugin;
    }

    public IWorkbenchPage getPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getActivePage();
    }

    private void computeListeners() throws CoreException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(ID_LISTENER);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                Object listener = elements[j].createExecutableExtension("class");
                if (listener instanceof IBtsListener) {
                    this.listeners.add(listener);
                }
                ++j;
            }
            ++i;
        }
    }

    public void addListener(IBtsListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IBtsListener listener) {
        this.listeners.remove(listener);
    }

    public List getListeners() {
        return this.listeners;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        path = "icons/" + path;
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)path);
        return image;
    }

    public Image getImage(String path) {
        return this.getImageDescriptor(path).createImage();
    }

    public Shell getShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getShell();
    }

    public IssueMultiPageEditor getActiveEditor() {
        IEditorPart editor = this.getPage().getActiveEditor();
        if (editor != null && editor instanceof IssueMultiPageEditor) {
            return (IssueMultiPageEditor)editor;
        }
        return null;
    }

    public void openEditor(IssueMultiPageEditorInput input, boolean activate) throws PartInitException {
        IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)input, (String)ID_EDITOR_ISSUE, (boolean)activate);
    }

    public boolean closeEditor(IEditorPart editor, boolean save) {
        return this.getPage().closeEditor(editor, save);
    }

    public void closeIssueEditor(String fingerprint, String type) {
        IssueMultiPageEditor[] editor = this.getIssueEditors();
        if (editor == null) {
            return;
        }
        int i = 0;
        while (i < editor.length) {
            IssueMultiPageEditorInput editorInput = (IssueMultiPageEditorInput)editor[i].getEditorInput();
            if (fingerprint.equals(editorInput.getIssue().getFingerPrint()) && type.equals(editorInput.getIssue().getType())) {
                this.closeEditor((IEditorPart)editor[i], false);
            }
            ++i;
        }
    }

    public void closeAllIssueEditors() {
        IssueMultiPageEditor[] editor = this.getIssueEditors();
        if (editor == null) {
            return;
        }
        int i = 0;
        while (i < editor.length) {
            this.closeEditor((IEditorPart)editor[i], false);
            ++i;
        }
    }

    public IssueMultiPageEditor[] getIssueEditors() {
        ArrayList<IEditorPart> list = new ArrayList<IEditorPart>();
        IEditorReference[] editorRef = this.getPage().getEditorReferences();
        int i = 0;
        while (i < editorRef.length) {
            try {
                IEditorPart editorPart = editorRef[i].getEditor(false);
                if (editorPart instanceof IssueMultiPageEditor) {
                    list.add(editorPart);
                }
            }
            catch (Exception e) {
                this.errorlog(e);
            }
            ++i;
        }
        return list.toArray(new IssueMultiPageEditor[0]);
    }

    public IssueMultiPageEditor getIssueEditor(String fingerPrint, String type) {
        IssueMultiPageEditor[] editors = this.getIssueEditors();
        if (editors == null) {
            return null;
        }
        int i = 0;
        while (i < editors.length) {
            IssueMultiPageEditorInput editorInput = (IssueMultiPageEditorInput)editors[i].getEditorInput();
            if (fingerPrint.equals(editorInput.getIssue().getFingerPrint()) && type.equals(editorInput.getIssue().getType())) {
                return editors[i];
            }
            ++i;
        }
        return null;
    }

    public NavigatorView getNavigatorView() {
        return (NavigatorView)this.getPage().findView(ID_VIEW_NAVIGATOR);
    }

    public IssueListView getIssueView() {
        return (IssueListView)this.getPage().findView(ID_VIEW_ISSUELIST);
    }

    public MessageListView getMessageView() {
        return (MessageListView)this.getPage().findView(ID_VIEW_MESSAGELIST);
    }

    public void error(Throwable ex) {
        this.error(ex.getMessage(), ex);
    }

    public void error(String msg, Throwable ex) {
        Status status = new Status(4, this.getBundle().getSymbolicName(), 0, msg, ex);
        this.getLog().log((IStatus)status);
        ErrorDialog.openError((Shell)this.getShell(), (String)"ERROR!", (String)Messages.getString("BtsPlugin.1"), (IStatus)status);
        ex.printStackTrace();
    }

    public void errorlog(Throwable ex) {
        this.errorlog(ex.getMessage(), ex);
    }

    public void errorlog(String msg, Throwable ex) {
        Status status = new Status(4, this.getBundle().getSymbolicName(), 0, msg, ex);
        this.getLog().log((IStatus)status);
        ex.printStackTrace();
    }

    public IProjectDialogSettings getProjectDialogSettings() {
        if (this.projectDialogSettings == null) {
            this.loadProjectDialogSettings();
        }
        return this.projectDialogSettings;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadProjectDialogSettings() {
        this.projectDialogSettings = new ProjectDialogSettings("Workbench");
        String readWritePath = this.getStateLocation().append(FN_DIALOG_SETTINGS).toOSString();
        File settingsFile = new File(readWritePath);
        if (settingsFile.exists()) {
            try {
                this.projectDialogSettings.load(readWritePath);
                return;
            }
            catch (IOException iOException) {
                this.projectDialogSettings = new ProjectDialogSettings("Workbench");
                return;
            }
        }
        Bundle bundle = Platform.getBundle((String)this.getBundle().getSymbolicName());
        URL dsURL = FileLocator.find((Bundle)bundle, (IPath)new Path(FN_DIALOG_SETTINGS), null);
        if (dsURL == null) {
            return;
        }
        InputStream is = null;
        try {
            try {
                is = dsURL.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                this.projectDialogSettings.load(reader);
            }
            catch (IOException iOException) {
                this.projectDialogSettings = new ProjectDialogSettings("Workbench");
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (is == null) return;
        is.close();
    }

    public void saveProjectDialogSettings() {
        if (this.projectDialogSettings == null) {
            return;
        }
        try {
            String readWritePath = this.getStateLocation().append(FN_DIALOG_SETTINGS).toOSString();
            this.projectDialogSettings.save(readWritePath);
        }
        catch (IOException iOException) {}
    }
}

