/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import java.io.File;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.ui.navigator.ProjectConfigManager;
import jp.valtech.bts.ui.navigator.TreeHelper;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeleteProjectAction
extends Action
implements Logging {
    private String ssid;

    public DeleteProjectAction() {
        this.setText(Messages.getString("DeleteProjectAction.0"));
        this.setToolTipText(Messages.getString("DeleteProjectAction.1"));
        this.setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("delete.gif"));
    }

    public void run() {
        try {
            boolean res = MessageDialog.openQuestion((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("DeleteProjectAction.2"), (String)Messages.getString("DeleteProjectAction.3"));
            if (!res) {
                return;
            }
            ProjectConfigManager.remove(this.ssid);
            String baseDir = BTSUtility.getBaseDir(this.ssid);
            File dir = new File(baseDir);
            if (dir.exists()) {
                File[] files = dir.listFiles();
                int i = 0;
                while (i < files.length) {
                    files[i].delete();
                    ++i;
                }
                dir.delete();
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    TreeHelper.deleteProjectNode(DeleteProjectAction.this.ssid);
                }
            });
        }
        catch (Exception e) {
            String msg = Messages.getString("DeleteProjectAction.4");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    public void setSSID(String ssid) {
        this.ssid = ssid;
    }
}

