/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.facade.ReceiveGarbageIssueFacade;
import jp.valtech.bts.facade.ReceiveReleaseIssueFacade;
import jp.valtech.bts.facade.VoteDAOFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.part.ViewPart;

public class ImportIssueAction
extends Action
implements Logging {
    private ViewPart view;

    public ImportIssueAction(ViewPart view) {
        this.view = view;
        this.setText(Messages.getString("ImportIssueAction.0"));
        this.setToolTipText(Messages.getString("ImportIssueAction.1"));
        this.setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("import.gif"));
    }

    public void run() {
        try {
            Logging facade;
            FileDialog fileDialog = new FileDialog(this.view.getSite().getShell(), 4096);
            fileDialog.setFilterExtensions(new String[]{"*.bts"});
            String fileName = fileDialog.open();
            if (fileName == null || fileName.equals("")) {
                return;
            }
            File file = new File(fileName);
            if (!file.exists()) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(fileName);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Issue importIssue = (Issue)objectInputStream.readObject();
            if ("R".equals(importIssue.getType())) {
                facade = new ReceiveReleaseIssueFacade();
                ((ReceiveReleaseIssueFacade)facade).importReleaseIssue(importIssue);
                ((ReceiveReleaseIssueFacade)facade).saveImportMessage();
            } else if ("G".equals(importIssue.getType())) {
                facade = new ReceiveGarbageIssueFacade();
                ((ReceiveGarbageIssueFacade)facade).changeGarbageIssue(importIssue);
                ((ReceiveGarbageIssueFacade)facade).saveReceiveMessage();
            }
            VoteDAOFacade voteDAOFacade = new VoteDAOFacade();
            voteDAOFacade.cleanInsert(importIssue.getVotes());
        }
        catch (Exception e) {
            String msg = Messages.getString("ImportIssueAction.2");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }
}

