/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import java.util.Calendar;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.util.BTSUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OpenCalendarDlgAction
extends Action {
    private Text text;
    private Calendar today;
    private int currentYear;
    private int currentMonth;
    private int MSEC_ONEDAY = 86400000;

    public OpenCalendarDlgAction(Text text) {
        this.text = text;
        this.moveToday();
    }

    public void run() {
        CalendarDlg calendarDlg = new CalendarDlg(this.text.getShell());
        calendarDlg.open();
    }

    private void moveToday() {
        this.today = Calendar.getInstance();
        this.currentYear = this.today.get(1);
        this.currentMonth = this.today.get(2) + 1;
    }

    static /* synthetic */ void access$3(OpenCalendarDlgAction openCalendarDlgAction) {
        openCalendarDlgAction.moveToday();
    }

    public class CalendarDlg
    extends Dialog {
        private Composite composite;
        private Composite parentComposite;
        private Font font = new Font((Device)Display.getCurrent(), new FontData("", 10, 0));
        private Color tempBackColor;
        private Color tempForeColor;

        protected CalendarDlg(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            this.parentComposite = parent;
            this.getShell().setText(Messages.getString("OpenCalendarDlgAction.0"));
            this.getShell().setMinimumSize(175, 270);
            this.composite = (Composite)super.createDialogArea(this.parentComposite);
            this.composite.setBackground(Display.getCurrent().getSystemColor(1));
            GridLayout layout = new GridLayout(7, true);
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            this.composite.setLayout((Layout)layout);
            this.createCurrentMonth();
            this.createMoveMonth();
            this.createWeek();
            this.createDay();
            this.closeCalendar();
            return this.composite;
        }

        protected Control createContents(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            CalendarDlg.applyDialogFont((Control)composite);
            this.initializeDialogUnits((Control)composite);
            this.dialogArea = this.createDialogArea(composite);
            return composite;
        }

        private void createCurrentMonth() {
            CLabel monthLabel = new CLabel(this.composite, 0x1000000);
            monthLabel.setFont(new Font((Device)Display.getCurrent(), new FontData("", 10, 1)));
            monthLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(140, 140, 255)));
            monthLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(255, 255, 255)));
            monthLabel.setText(String.valueOf(OpenCalendarDlgAction.this.currentYear) + Messages.getString("OpenCalendarDlgAction.1") + OpenCalendarDlgAction.this.currentMonth + Messages.getString("OpenCalendarDlgAction.2"));
            GridData data = new GridData(272);
            data.horizontalSpan = 7;
            monthLabel.setLayoutData((Object)data);
        }

        private void createMoveMonth() {
            CLabel lastMonthLabel = new CLabel(this.composite, 0x1000800);
            lastMonthLabel.setFont(this.font);
            lastMonthLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(245, 245, 255)));
            lastMonthLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(0, 0, 255)));
            lastMonthLabel.setText(Messages.getString("OpenCalendarDlgAction.3"));
            GridData lastMonthData = new GridData(272);
            lastMonthData.horizontalSpan = 2;
            lastMonthLabel.setLayoutData((Object)lastMonthData);
            lastMonthLabel.addMouseTrackListener((MouseTrackListener)new LabelMouseTrackAdapter(lastMonthLabel));
            lastMonthLabel.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ CalendarDlg this$1;
                {
                    this.this$1 = calendarDlg;
                }

                public void mouseDown(MouseEvent e) {
                    CalendarDlg.access$2(this.this$1, -1);
                }
            });
            CLabel nowMonthLabel = new CLabel(this.composite, 0x1000800);
            nowMonthLabel.setFont(this.font);
            nowMonthLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(245, 245, 255)));
            nowMonthLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(0, 0, 255)));
            nowMonthLabel.setText(Messages.getString("OpenCalendarDlgAction.4"));
            GridData nowMonthData = new GridData(272);
            nowMonthData.horizontalSpan = 3;
            nowMonthLabel.setLayoutData((Object)nowMonthData);
            nowMonthLabel.addMouseTrackListener((MouseTrackListener)new LabelMouseTrackAdapter(nowMonthLabel));
            nowMonthLabel.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ CalendarDlg this$1;
                {
                    this.this$1 = calendarDlg;
                }

                public void mouseDown(MouseEvent e) {
                    OpenCalendarDlgAction.access$3(CalendarDlg.access$3(this.this$1));
                    CalendarDlg.access$2(this.this$1, 0);
                }
            });
            CLabel nextMonthLabel = new CLabel(this.composite, 0x1000800);
            nextMonthLabel.setFont(this.font);
            nextMonthLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(245, 245, 255)));
            nextMonthLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(0, 0, 255)));
            nextMonthLabel.setText(Messages.getString("OpenCalendarDlgAction.5"));
            nextMonthLabel.setLayoutData((Object)lastMonthData);
            nextMonthLabel.addMouseTrackListener((MouseTrackListener)new LabelMouseTrackAdapter(nextMonthLabel));
            nextMonthLabel.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ CalendarDlg this$1;
                {
                    this.this$1 = calendarDlg;
                }

                public void mouseDown(MouseEvent e) {
                    CalendarDlg.access$2(this.this$1, 1);
                }
            });
        }

        private void createWeek() {
            CLabel sundayLabel = new CLabel(this.composite, 0x1000800);
            sundayLabel.setFont(this.font);
            sundayLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(225, 225, 225)));
            sundayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(255, 0, 0)));
            sundayLabel.setText(Messages.getString("OpenCalendarDlgAction.6"));
            sundayLabel.setLayoutData((Object)new GridData(272));
            CLabel mondayLabel = new CLabel(this.composite, 0x1000800);
            mondayLabel.setFont(this.font);
            mondayLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(225, 225, 225)));
            mondayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(0, 0, 0)));
            mondayLabel.setText(Messages.getString("OpenCalendarDlgAction.7"));
            mondayLabel.setLayoutData((Object)new GridData(272));
            CLabel tuesdayLabel = new CLabel(this.composite, 0x1000800);
            tuesdayLabel.setFont(this.font);
            tuesdayLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(225, 225, 225)));
            tuesdayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(0, 0, 0)));
            tuesdayLabel.setText(Messages.getString("OpenCalendarDlgAction.8"));
            tuesdayLabel.setLayoutData((Object)new GridData(272));
            CLabel wednesdayLabel = new CLabel(this.composite, 0x1000800);
            wednesdayLabel.setFont(this.font);
            wednesdayLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(225, 225, 225)));
            wednesdayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(0, 0, 0)));
            wednesdayLabel.setText(Messages.getString("OpenCalendarDlgAction.9"));
            wednesdayLabel.setLayoutData((Object)new GridData(272));
            CLabel thursdayLabel = new CLabel(this.composite, 0x1000800);
            thursdayLabel.setFont(this.font);
            thursdayLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(225, 225, 225)));
            thursdayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(0, 0, 0)));
            thursdayLabel.setText(Messages.getString("OpenCalendarDlgAction.10"));
            thursdayLabel.setLayoutData((Object)new GridData(272));
            CLabel fridayLabel = new CLabel(this.composite, 0x1000800);
            fridayLabel.setFont(this.font);
            fridayLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(225, 225, 225)));
            fridayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(0, 0, 0)));
            fridayLabel.setText(Messages.getString("OpenCalendarDlgAction.11"));
            fridayLabel.setLayoutData((Object)new GridData(272));
            CLabel saturdayLabel = new CLabel(this.composite, 0x1000800);
            saturdayLabel.setFont(this.font);
            saturdayLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(225, 225, 225)));
            saturdayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(0, 0, 255)));
            saturdayLabel.setText(Messages.getString("OpenCalendarDlgAction.12"));
            saturdayLabel.setLayoutData((Object)new GridData(272));
        }

        private void createDay() {
            Calendar startDate = Calendar.getInstance();
            startDate.set(OpenCalendarDlgAction.this.currentYear, OpenCalendarDlgAction.this.currentMonth - 1, 1);
            startDate.setTimeInMillis(startDate.getTimeInMillis() - (long)(startDate.get(7) * OpenCalendarDlgAction.this.MSEC_ONEDAY) + (long)OpenCalendarDlgAction.this.MSEC_ONEDAY);
            Calendar endDate = Calendar.getInstance();
            endDate.set(OpenCalendarDlgAction.this.currentYear, OpenCalendarDlgAction.this.currentMonth, 1);
            endDate.setTimeInMillis(endDate.getTimeInMillis() - (long)OpenCalendarDlgAction.this.MSEC_ONEDAY);
            endDate.setTimeInMillis(endDate.getTimeInMillis() + (long)((6 - endDate.get(7)) * OpenCalendarDlgAction.this.MSEC_ONEDAY) + (long)OpenCalendarDlgAction.this.MSEC_ONEDAY);
            while (startDate.getTimeInMillis() <= endDate.getTimeInMillis()) {
                CLabel dayLabel = new CLabel(this.composite, 0x1000800);
                dayLabel.setFont(this.font);
                dayLabel.setText(" " + Integer.toString(startDate.get(5)) + " ");
                GridData data = new GridData(272);
                data.heightHint = 25;
                dayLabel.setLayoutData((Object)data);
                dayLabel.addMouseListener((MouseListener)new DayMouseAdapter(startDate.getTimeInMillis()));
                if (Calendar.getInstance().get(1) == startDate.get(1) && Calendar.getInstance().get(2) == startDate.get(2) && Calendar.getInstance().get(5) == startDate.get(5)) {
                    dayLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(255, 255, 221)));
                    dayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(179, 165, 90)));
                    dayLabel.addMouseTrackListener((MouseTrackListener)new LabelMouseTrackAdapter(dayLabel));
                } else if (startDate.get(7) == 1) {
                    dayLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(255, 235, 235)));
                    if (OpenCalendarDlgAction.this.currentMonth == startDate.get(2) + 1) {
                        dayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(255, 0, 0)));
                    } else {
                        dayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(255, 180, 180)));
                    }
                    dayLabel.addMouseTrackListener((MouseTrackListener)new LabelMouseTrackAdapter(dayLabel));
                } else if (startDate.get(7) == 7) {
                    dayLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(235, 235, 255)));
                    if (OpenCalendarDlgAction.this.currentMonth == startDate.get(2) + 1) {
                        dayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(0, 0, 255)));
                    } else {
                        dayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(180, 180, 255)));
                    }
                    dayLabel.addMouseTrackListener((MouseTrackListener)new LabelMouseTrackAdapter(dayLabel));
                } else {
                    dayLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(255, 255, 255)));
                    if (OpenCalendarDlgAction.this.currentMonth == startDate.get(2) + 1) {
                        dayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(0, 0, 0)));
                    } else {
                        dayLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(180, 180, 180)));
                    }
                    dayLabel.addMouseTrackListener((MouseTrackListener)new LabelMouseTrackAdapter(dayLabel));
                }
                startDate.setTimeInMillis(startDate.getTimeInMillis() + (long)OpenCalendarDlgAction.this.MSEC_ONEDAY);
            }
        }

        private void changeGround(CLabel label) {
            this.tempBackColor = label.getBackground();
            this.tempForeColor = label.getForeground();
            label.setBackground(new Color((Device)Display.getCurrent(), new RGB(235, 255, 235)));
            label.setForeground(new Color((Device)Display.getCurrent(), new RGB(0, 255, 0)));
        }

        private void returnGround(CLabel label) {
            label.setBackground(this.tempBackColor);
            label.setForeground(this.tempForeColor);
        }

        private void closeCalendar() {
            CLabel closeLabel = new CLabel(this.composite, 0x1000800);
            closeLabel.setFont(this.font);
            closeLabel.setBackground(new Color((Device)Display.getCurrent(), new RGB(245, 245, 255)));
            closeLabel.setForeground(new Color((Device)Display.getCurrent(), new RGB(0, 0, 255)));
            closeLabel.setText(Messages.getString("OpenCalendarDlgAction.13"));
            GridData data = new GridData(272);
            data.horizontalSpan = 7;
            closeLabel.setLayoutData((Object)data);
            closeLabel.addMouseTrackListener((MouseTrackListener)new LabelMouseTrackAdapter(closeLabel));
            closeLabel.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ CalendarDlg this$1;
                {
                    this.this$1 = calendarDlg;
                }

                public void mouseDown(MouseEvent e) {
                    this.this$1.close();
                }
            });
        }

        private void moveMonth(int adjust) {
            OpenCalendarDlgAction openCalendarDlgAction = OpenCalendarDlgAction.this;
            openCalendarDlgAction.currentMonth = openCalendarDlgAction.currentMonth + adjust;
            if (OpenCalendarDlgAction.this.currentMonth > 12) {
                OpenCalendarDlgAction openCalendarDlgAction2 = OpenCalendarDlgAction.this;
                openCalendarDlgAction2.currentYear = openCalendarDlgAction2.currentYear + 1;
                OpenCalendarDlgAction.this.currentMonth = 1;
            } else if (OpenCalendarDlgAction.this.currentMonth < 1) {
                OpenCalendarDlgAction openCalendarDlgAction3 = OpenCalendarDlgAction.this;
                openCalendarDlgAction3.currentYear = openCalendarDlgAction3.currentYear - 1;
                OpenCalendarDlgAction.this.currentMonth = 12;
            }
            Control[] children = this.parentComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                children[i] = null;
                ++i;
            }
            this.createDialogArea(this.parentComposite);
            this.reflow();
        }

        private void reflow() {
            Composite c = this.parentComposite;
            while (c != null) {
                c.setRedraw(false);
                c = c.getParent();
            }
            c = this.parentComposite;
            while (c != null) {
                c.layout(true);
                c = c.getParent();
            }
            c = this.parentComposite;
            while (c != null) {
                c.setRedraw(true);
                c = c.getParent();
            }
        }

        static /* synthetic */ void access$2(CalendarDlg calendarDlg, int n) {
            calendarDlg.moveMonth(n);
        }

        private class LabelMouseTrackAdapter
        extends MouseTrackAdapter {
            private CLabel label;

            private LabelMouseTrackAdapter(CLabel label) {
                this.label = label;
            }

            public void mouseEnter(MouseEvent e) {
                CalendarDlg.this.changeGround(this.label);
            }

            public void mouseExit(MouseEvent e) {
                CalendarDlg.this.returnGround(this.label);
            }
        }

        private class DayMouseAdapter
        extends MouseAdapter {
            private String selectDate;

            public DayMouseAdapter(long date) {
                this.selectDate = BTSUtility.formatDate(date, "yyyy/MM/dd");
            }

            public void mouseDown(MouseEvent e) {
                OpenCalendarDlgAction.this.text.setText(this.selectDate);
                CalendarDlg.this.close();
            }
        }
    }
}

