/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.network.ClientList;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.ui.msglist.MessageSenderDialog;
import jp.valtech.bts.util.BTSUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.part.ViewPart;

public class OpenMessageDlgAction
extends Action {
    private static final ImageDescriptor THIS_IMAGE = BtsPlugin.getInstance().getImageDescriptor("mail.gif");
    private static final ImageDescriptor THIS_IMAGE_DISABLE = BtsPlugin.getInstance().getImageDescriptor("mail_disable.gif");
    private ViewPart view;
    private String message = null;
    private ClientInfo clientInfo;
    private boolean sendAll = false;

    public OpenMessageDlgAction(ViewPart view) {
        this.view = view;
        this.setText(Messages.getString("OpenMessageDlgAction.0"));
        this.setImageDescriptor(THIS_IMAGE);
        this.setDisabledImageDescriptor(THIS_IMAGE_DISABLE);
    }

    public void run() {
        MessageSenderDialog dialog = new MessageSenderDialog(this.view.getSite().getShell());
        if (this.message != null && !this.message.equals("")) {
            this.message = this.message.replaceAll("^", ">");
            this.message = this.message.replaceAll("\n", "\n>");
            this.message = "\n" + this.message;
            dialog.setReplyMessage(this.message);
        }
        dialog.setClientInfo(this.clientInfo);
        dialog.setSendAll(this.sendAll);
        dialog.open();
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = BTSUtility.isLocalHost(clientInfo) ? null : clientInfo;
    }

    public void setFromUser(String fromUser) {
        ClientInfo info = ClientList.getClientInfoByClientName(fromUser);
        this.clientInfo = info == null ? null : (BTSUtility.isLocalHost(info) ? null : info);
    }

    public void setSendAll(boolean sendAll) {
        this.sendAll = sendAll;
    }

    public void setReplyMessage(String message) {
        this.message = message;
    }
}

