/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import jp.valtech.bts.command.client.VoteAdd;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.data.Vote;
import jp.valtech.bts.facade.VoteDAOFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.part.WorkbenchPart;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.HorizontalAlignment;

public class OpenVoteDlgAction
extends Action
implements Logging {
    private WorkbenchPart parent;
    private Issue issue;
    private String currentDir = BtsPlugin.getInstance().getStateLocation() + "/";
    private int voteCnt;
    private ImageHyperlink voteLink;

    public OpenVoteDlgAction(WorkbenchPart parent, ImageHyperlink voteLink) {
        this.parent = parent;
        this.voteLink = voteLink;
        this.setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("vote.gif"));
        this.setText(Messages.getString("OpenVoteDlgAction.0"));
        this.setToolTipText(Messages.getString("OpenVoteDlgAction.1"));
    }

    public void run() {
        try {
            VoteDAOFacade voteDAOFacade = new VoteDAOFacade();
            Vote[] votes = voteDAOFacade.get(this.issue.getFingerPrint());
            this.createChart(votes);
            VoteDlg myDialog = new VoteDlg(this.parent.getSite().getShell());
            myDialog.open();
        }
        catch (Exception e) {
            String msg = Messages.getString("OpenVoteDlgAction.11");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    private void createChart(Vote[] votes) throws Exception {
        this.voteCnt = 0;
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int i = 0;
        while (i < votes.length) {
            dataset.addValue((double)votes[i].getVoteCnt(), (Comparable)((Object)""), (Comparable)((Object)votes[i].getVoteUser()));
            this.voteCnt += votes[i].getVoteCnt();
            ++i;
        }
        JFreeChart chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)true);
        TextTitle textTitle = new TextTitle(Messages.getString("OpenVoteDlgAction.2"));
        textTitle.setFont(new java.awt.Font("SansSerif", 0, 16));
        textTitle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        chart.addSubtitle((Title)textTitle);
        TextTitle voteCntTitle = new TextTitle(String.valueOf(Messages.getString("OpenVoteDlgAction.3")) + this.voteCnt + Messages.getString("OpenVoteDlgAction.4"));
        voteCntTitle.setFont(new java.awt.Font("SansSerif", 2, 11));
        voteCntTitle.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        chart.addSubtitle((Title)voteCntTitle);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRangeGridlinesVisible(false);
        plot.getRenderer().setPaint((Paint)new Color(195, 195, 255));
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setVisible(false);
        CategoryItemRenderer categoryitemrenderer = plot.getRenderer();
        categoryitemrenderer.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        categoryitemrenderer.setSeriesItemLabelsVisible(0, Boolean.TRUE);
        File outputFile = new File(String.valueOf(this.currentDir) + "vote.png");
        ChartUtilities.saveChartAsPNG((File)outputFile, (JFreeChart)chart, (int)400, (int)(votes.length * 25 + 45));
    }

    public void setIssue(Issue issue) {
        this.issue = issue;
    }

    public class VoteDlg
    extends Dialog {
        private ScrolledComposite scrolledComposite;
        private Composite composite;
        private Label chartLabel;

        protected VoteDlg(Shell parent) {
            super(parent);
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(BtsPlugin.getInstance().getActiveEditor().getModifiedIssue().getTitle());
            super.configureShell(newShell);
        }

        protected Control createDialogArea(Composite parent) {
            this.scrolledComposite = new ScrolledComposite(parent, 512);
            this.composite = (Composite)super.createDialogArea((Composite)this.scrolledComposite);
            this.scrolledComposite.setBackground(Display.getCurrent().getSystemColor(1));
            this.composite.setBackground(Display.getCurrent().getSystemColor(1));
            this.createBtnArea(this.composite);
            this.createChartArea(this.composite);
            this.scrolledComposite.setContent((Control)this.composite);
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        protected Control createContents(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            VoteDlg.applyDialogFont((Control)composite);
            this.initializeDialogUnits((Control)composite);
            this.dialogArea = this.createDialogArea(composite);
            return composite;
        }

        private void createChartArea(Composite parent) {
            Composite buttonArea = new Composite(parent, 0);
            buttonArea.setBackground(Display.getCurrent().getSystemColor(1));
            this.chartLabel = new Label(buttonArea, 0);
            this.chartLabel.setBackground(Display.getCurrent().getSystemColor(1));
            Image image = new Image((Device)Display.getCurrent(), String.valueOf(OpenVoteDlgAction.this.currentDir) + "vote.png");
            this.chartLabel.setImage(image);
            Rectangle rectangle = image.getBounds();
            this.chartLabel.setBounds(10, 10, rectangle.width, rectangle.height + 50);
        }

        private void createBtnArea(Composite parent) {
            Composite buttonArea = new Composite(parent, 0);
            buttonArea.setBackground(Display.getCurrent().getSystemColor(1));
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            buttonArea.setLayout((Layout)gridLayout);
            Button voteBtn = new Button(buttonArea, 0x800008);
            voteBtn.setText(Messages.getString("OpenVoteDlgAction.5"));
            GridData voteGrid = new GridData();
            voteGrid.horizontalIndent = 260;
            voteGrid.widthHint = 60;
            voteGrid.heightHint = 30;
            voteBtn.setLayoutData((Object)voteGrid);
            voteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ VoteDlg this$1;
                {
                    this.this$1 = voteDlg;
                }

                public void widgetSelected(SelectionEvent e) {
                    VoteDlg.access$0(this.this$1);
                }
            });
            Button closeBtn = new Button(buttonArea, 0x800008);
            closeBtn.setText(Messages.getString("OpenVoteDlgAction.6"));
            GridData closeGrid = new GridData();
            closeGrid.widthHint = 60;
            closeGrid.heightHint = 30;
            closeBtn.setLayoutData((Object)closeGrid);
            closeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ VoteDlg this$1;
                {
                    this.this$1 = voteDlg;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.close();
                }
            });
        }

        private void votePressed() {
            try {
                Vote vote = new Vote();
                vote.setFingerPrint(OpenVoteDlgAction.this.issue.getFingerPrint());
                vote.setVoteUser(CurrentProject.getInsance().getProjectConfig().getUserName());
                vote.setVoteCnt(1);
                VoteDAOFacade voteDAOFacade = new VoteDAOFacade();
                Vote[] votes = voteDAOFacade.cntPlus(vote);
                OpenVoteDlgAction.this.createChart(votes);
                Image image = new Image((Device)Display.getCurrent(), String.valueOf(OpenVoteDlgAction.this.currentDir) + "vote.png");
                this.chartLabel.setImage(image);
                Rectangle rectangle = image.getBounds();
                this.chartLabel.setBounds(10, 10, rectangle.width, rectangle.height);
                this.scrolledComposite.setContent((Control)this.composite);
                this.composite.setSize(this.composite.computeSize(-1, -1));
                VoteAdd voteAdd = new VoteAdd(new NetworkConfig());
                voteAdd.setVote(vote);
                voteAdd.execute();
            }
            catch (Exception e) {
                BtsPlugin.getInstance().errorlog(e);
            }
        }

        public boolean close() {
            String voteStr = String.valueOf(Messages.getString("OpenVoteDlgAction.7")) + OpenVoteDlgAction.this.voteCnt + Messages.getString("OpenVoteDlgAction.8");
            OpenVoteDlgAction.this.voteLink.setForeground(null);
            OpenVoteDlgAction.this.voteLink.setFont(null);
            ProjectConfig config = CurrentProject.getInsance().getProjectConfig();
            if (config.isVoteCheck()) {
                int warningCnt = Integer.parseInt(config.getVote());
                if (OpenVoteDlgAction.this.voteCnt > warningCnt) {
                    voteStr = String.valueOf(Messages.getString("OpenVoteDlgAction.9")) + OpenVoteDlgAction.this.voteCnt + Messages.getString("OpenVoteDlgAction.10");
                    OpenVoteDlgAction.this.voteLink.setForeground(new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), 255, 0, 0));
                    OpenVoteDlgAction.this.voteLink.setFont(new Font((Device)Display.getCurrent(), "", 10, 1));
                }
            }
            OpenVoteDlgAction.this.voteLink.setText(voteStr);
            return super.close();
        }

        static /* synthetic */ void access$0(VoteDlg voteDlg) {
            voteDlg.votePressed();
        }
    }
}

