/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import java.util.ArrayList;
import java.util.List;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueHistory;
import jp.valtech.bts.facade.SendIssueFacade;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.ui.action.SendIssueAction;
import jp.valtech.bts.ui.editor.IssueMultiPageEditor;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.IssueUtility;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SendGarbageIssueAction
extends SendIssueAction
implements Logging {
    private Issue garbageIssue;

    public SendGarbageIssueAction() {
        this.setText(Messages.getString("SendGarbageIssueAction.0"));
        this.setToolTipText(Messages.getString("SendGarbageIssueAction.1"));
        this.setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("garbage.gif"));
    }

    public void run() {
        super.run();
        MessageDialog dialog = new MessageDialog(BtsPlugin.getInstance().getShell(), Messages.getString("SendGarbageIssueAction.2"), null, String.valueOf(Messages.getString("SendGarbageIssueAction.3")) + this.garbageIssue.getTitle() + Messages.getString("SendGarbageIssueAction.4"), 3, new String[]{Messages.getString("SendGarbageIssueAction.5"), Messages.getString("SendGarbageIssueAction.6")}, 1);
        int res = dialog.open();
        if (res != 0) {
            return;
        }
        List listeners = BtsPlugin.getInstance().getListeners();
        int idx = 0;
        while (idx < listeners.size()) {
            IBtsListener listnener = (IBtsListener)listeners.get(idx);
            listnener.deleteIssue(this.garbageIssue);
            ++idx;
        }
        this.garbageIssue.setType("G");
        this.garbageIssue.setUpdateDate(System.currentTimeMillis());
        String name = CurrentProject.getInsance().getProjectConfig().getUserName();
        IssueHistory history = IssueUtility.createGarbageHistory(this.garbageIssue, name);
        SendIssueFacade facade = new SendIssueFacade();
        facade.garbageByFingerPrint(this.garbageIssue.getFingerPrint(), history);
        int idx2 = 0;
        while (idx2 < listeners.size()) {
            IBtsListener listnener = (IBtsListener)listeners.get(idx2);
            listnener.addIssue(this.garbageIssue);
            ++idx2;
        }
        IssueHistory[] sendHistory = facade.getAllHistory();
        IssueMultiPageEditor editorPart = BtsPlugin.getInstance().getIssueEditor(this.garbageIssue.getFingerPrint(), "G");
        if (editorPart == null) {
            editorPart = BtsPlugin.getInstance().getIssueEditor(this.garbageIssue.getFingerPrint(), "R");
        }
        if (editorPart != null) {
            editorPart.postIssueSave(this.garbageIssue);
            editorPart.postIssueHistorySave(sendHistory);
        }
        this.garbageIssue.setIssueHistories(new IssueHistory[]{history});
        this.sendIssue(this.garbageIssue);
        this.saveMessage(this.garbageIssue, "G");
    }

    protected void sendIssue(Issue issue) {
        this.sendMail(issue);
        super.sendIssue(issue);
        ReceiveUserDialog userDialog = new ReceiveUserDialog(issue.getTitle());
        userDialog.setClientInfo(this.sendUserList);
        userDialog.open();
    }

    public void setIssue(Issue issue) {
        this.garbageIssue = issue;
    }

    protected class ReceiveUserDialog
    extends MessageDialog {
        private ArrayList clientList;

        public ReceiveUserDialog(String issueTitle) {
            super(BtsPlugin.getInstance().getShell(), Messages.getString("SendGarbageIssueAction.7"), null, String.valueOf(Messages.getString("SendGarbageIssueAction.8")) + issueTitle + Messages.getString("SendGarbageIssueAction.9"), 2, new String[]{"OK"}, 0);
        }

        public void setClientInfo(ArrayList clientList) {
            this.clientList = clientList;
        }

        protected Control createCustomArea(Composite parent) {
            Composite thisArea = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginLeft = 40;
            thisArea.setLayout((Layout)gridLayout);
            org.eclipse.swt.widgets.List memberList = new org.eclipse.swt.widgets.List(thisArea, 2562);
            if (this.clientList == null || this.clientList.size() == 0) {
                memberList.add(Messages.getString("SendGarbageIssueAction.10"));
            } else {
                int i = 0;
                while (i < this.clientList.size()) {
                    ClientInfo clientInfo = (ClientInfo)this.clientList.get(i);
                    String userName = clientInfo.getClientName();
                    String address = BTSUtility.rightPad("(" + clientInfo.getClientAddress() + ")", 19);
                    memberList.add(String.valueOf(address) + userName);
                    ++i;
                }
            }
            GridData gridData = new GridData();
            gridData.heightHint = 60;
            gridData.widthHint = 280;
            memberList.setLayoutData((Object)gridData);
            return thisArea;
        }
    }
}

