/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import jp.valtech.bts.command.client.Join;
import jp.valtech.bts.command.client.SendIssue;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.facade.MessagePacketFacade;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.network.ClientList;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.BtsMailSender;
import jp.valtech.bts.util.Logging;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SendIssueAction
extends Action
implements Logging {
    private static final int OK_PRESS_INTERVAL = 30000;
    private long time1 = System.currentTimeMillis();
    protected ArrayList sendUserList = new ArrayList();

    public void run() {
        ClientList.clear();
        ClientList.addMyInfo();
        Join join = new Join(new NetworkConfig());
        join.execute();
        this.time1 = System.currentTimeMillis();
    }

    protected void sendIssue(final Issue issue) {
        try {
            IRunnableWithProgress progress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SendIssueAction.this.sendUserList.clear();
                    monitor.subTask(Messages.getString("SendIssueAction.0"));
                    long time2 = System.currentTimeMillis();
                    if (time2 - SendIssueAction.this.time1 > 30000L) {
                        Join join = new Join(new NetworkConfig());
                        join.execute();
                        Thread.sleep(5000L);
                    } else {
                        Thread.sleep(2000L);
                    }
                    ClientInfo[] clientInfo = ClientList.getClientInfoList();
                    monitor.beginTask(Messages.getString("SendIssueAction.1"), clientInfo.length);
                    int i = 0;
                    while (i < clientInfo.length) {
                        ClientInfo info = clientInfo[i];
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        if (!BTSUtility.isLocalHost(info)) {
                            SendIssue send = new SendIssue(new NetworkConfig(), info.getClientAddress(), info.getPort());
                            send.setIssue(issue);
                            monitor.subTask(String.valueOf(Messages.getString("SendIssueAction.2")) + info.getClientName() + Messages.getString("SendIssueAction.3"));
                            try {
                                send.execute();
                            }
                            catch (Exception e) {
                                logger.fatal((Object)(String.valueOf(Messages.getString("SendIssueAction.4")) + info), (Throwable)e);
                            }
                            if (send.isSuccessful()) {
                                SendIssueAction.this.sendUserList.add(info);
                            }
                        }
                        monitor.worked(1);
                        ++i;
                    }
                    monitor.done();
                }
            };
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(BtsPlugin.getInstance().getShell());
            dialog.run(true, true, progress);
        }
        catch (InvocationTargetException e) {
            BtsPlugin.getInstance().errorlog(e);
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openInformation((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("SendIssueAction.5"), (String)Messages.getString("SendIssueAction.6"));
        }
    }

    protected void saveMessage(Issue newIssue, String type) {
        MessagePacket message = new MessagePacket();
        ProjectConfig conf = CurrentProject.getInsance().getProjectConfig();
        message.setFromUser(conf.getUserName());
        message.setMessageType("I");
        message.setSent(new Date());
        message.setFingerPrint(newIssue.getFingerPrint());
        message.setIssueType(type);
        StringBuffer msg = new StringBuffer();
        msg.append(Messages.getString("SendIssueAction.7")).append(newIssue.getDisplayIssueID()).append("]");
        msg.append(newIssue.getTitle());
        msg.append(Messages.getString("SendIssueAction.8"));
        if (this.sendUserList == null || this.sendUserList.size() == 0) {
            msg.append(Messages.getString("SendIssueAction.9"));
        } else {
            int i = 0;
            while (i < this.sendUserList.size()) {
                ClientInfo clientInfo = (ClientInfo)this.sendUserList.get(i);
                String userName = clientInfo.getClientName();
                String address = BTSUtility.rightPad("(" + clientInfo.getClientAddress() + ")", 19);
                msg.append("\n  ").append(address).append(userName);
                ++i;
            }
        }
        msg.append(Messages.getString("SendIssueAction.10"));
        msg.append(BTSUtility.formatDate(message.getSent()));
        msg.append(Messages.getString("SendIssueAction.11"));
        if ("R".equals(type)) {
            msg.append("\n  Ver.").append(newIssue.getVersion());
        } else if ("G".equals(type)) {
            msg.append(Messages.getString("SendIssueAction.12"));
        }
        message.setMessage(msg.toString());
        MessagePacketFacade facade = new MessagePacketFacade();
        facade.addMessage(message);
    }

    protected void sendMail(Issue newIssue) {
        ProjectConfig projectConfig = CurrentProject.getInsance().getProjectConfig();
        if (projectConfig.isMailCheck()) {
            BtsMailSender mailSender = new BtsMailSender();
            mailSender.setIssue(newIssue);
            Thread mailThread = new Thread((Runnable)mailSender, "MAIL");
            mailThread.start();
        }
    }
}

