/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.editor;

import jp.valtech.bts.data.IssueHistory;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.editor.AbstractIssueEditorPart;
import jp.valtech.bts.ui.editor.Messages;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.Logging;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class HistoryPart
extends AbstractIssueEditorPart
implements Logging {
    public static final String TAB_TITLE = Messages.getString("HistoryPart.0");
    private static final int COL1_WITH = 100;
    private static final int HEAD_HEIGHT = 18;
    private static final int ROW_HEIGHT = 12;
    private static final int ROW_MARGIN = 4;
    private ScrolledForm form;
    private Composite sectionComposit;
    private IssueHistory[] histories;

    public void createPartControl(Composite parent) {
        try {
            this.histories = this.issueDisplayValue.getIssue().getIssueHistories();
            Composite body = this.createBody(parent, Messages.getString("HistoryPart.1"));
            this.createHistorySection(body);
            this.form.reflow(true);
        }
        catch (Exception e) {
            String msg = Messages.getString("HistoryPart.2");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    private Composite createBody(Composite parent, String title) {
        if (this.toolkit == null) {
            this.getFormToolkit(parent);
        }
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setText(title);
        this.form.getBody().setLayout((Layout)layout);
        this.form.getBody().setLayoutData((Object)new GridData(1808));
        Composite body = this.toolkit.createComposite(this.form.getBody());
        body.setLayout((Layout)layout);
        body.setLayoutData((Object)new GridData(1808));
        return body;
    }

    private void createHistorySection(Composite parent) throws Exception {
        Section section = this.createSection(parent, Messages.getString("HistoryPart.3"));
        section.setDescription(Messages.getString("HistoryPart.4"));
        GridData gridData = new GridData(768);
        section.setLayoutData((Object)gridData);
        this.sectionComposit = this.toolkit.createComposite((Composite)section);
        this.sectionComposit.setLayout((Layout)new GridLayout());
        this.sectionComposit.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)this.sectionComposit);
        this.createHistoryTableArea();
    }

    private void createHistoryTableArea() {
        Composite historyTable = this.toolkit.createComposite(this.sectionComposit);
        this.toolkit.paintBordersFor(historyTable);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        historyTable.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        historyTable.setLayoutData((Object)gridData);
        this.createHistoryHeader(historyTable);
        this.createHistoryData(historyTable);
        CLabel line = new CLabel(historyTable, 256);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 5;
        gd.heightHint = 1;
        line.setLayoutData((Object)gd);
        line.setBackground(new Color((Device)Display.getCurrent(), new RGB(153, 153, 255)));
    }

    public void postSave(IssueHistory[] histories) {
        this.histories = histories;
        Control[] children = this.sectionComposit.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            children[i] = null;
            ++i;
        }
        this.createHistoryTableArea();
        this.reflow();
    }

    private void reflow() {
        Composite c = this.sectionComposit;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
        for (c = this.sectionComposit; c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof ScrolledForm)) continue;
            ((ScrolledForm)c).reflow(true);
            break;
        }
        c = this.sectionComposit;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
    }

    private void createHistoryHeader(Composite historyTable) {
        Color headBackground = new Color((Device)Display.getCurrent(), new RGB(195, 195, 255));
        Color headForeground = new Color((Device)Display.getCurrent(), new RGB(255, 255, 255));
        Font font = new Font((Device)Display.getCurrent(), new FontData("", 10, 1));
        CLabel head1 = new CLabel(historyTable, 0x1000000);
        head1.setText(Messages.getString("HistoryPart.5"));
        head1.setBackground(headBackground);
        head1.setForeground(headForeground);
        head1.setFont(font);
        GridData headGrid = new GridData();
        headGrid.widthHint = 100;
        headGrid.heightHint = 18;
        head1.setLayoutData((Object)headGrid);
        CLabel head2 = new CLabel(historyTable, 0x1000000);
        head2.setText(Messages.getString("HistoryPart.6"));
        head2.setBackground(headBackground);
        head2.setForeground(headForeground);
        head2.setFont(font);
        headGrid = new GridData();
        headGrid.widthHint = 100;
        headGrid.heightHint = 18;
        head2.setLayoutData((Object)headGrid);
        CLabel head3 = new CLabel(historyTable, 0x1000000);
        head3.setText(Messages.getString("HistoryPart.7"));
        head3.setBackground(headBackground);
        head3.setForeground(headForeground);
        head3.setFont(font);
        headGrid = new GridData();
        headGrid.widthHint = 100;
        headGrid.heightHint = 18;
        head3.setLayoutData((Object)headGrid);
        CLabel head4 = new CLabel(historyTable, 0x1000000);
        head4.setText(Messages.getString("HistoryPart.8"));
        head4.setBackground(headBackground);
        head4.setForeground(headForeground);
        head4.setFont(font);
        headGrid = new GridData(768);
        headGrid.heightHint = 18;
        head4.setLayoutData((Object)headGrid);
        CLabel head5 = new CLabel(historyTable, 0x1000000);
        head5.setText(Messages.getString("HistoryPart.9"));
        head5.setBackground(headBackground);
        head5.setForeground(headForeground);
        head5.setFont(font);
        headGrid = new GridData(768);
        headGrid.heightHint = 18;
        head5.setLayoutData((Object)headGrid);
    }

    private void createHistoryData(Composite historyTable) {
        if (this.histories == null || this.histories.length == 0) {
            return;
        }
        Color headBackground1 = new Color((Device)Display.getCurrent(), new RGB(255, 255, 255));
        Color headBackground2 = new Color((Device)Display.getCurrent(), new RGB(240, 242, 255));
        int idx = 0;
        while (idx < this.histories.length) {
            Color headBackground = headBackground2;
            if (idx % 2 == 0) {
                headBackground = headBackground1;
            }
            int height = this.computeHeightHint(this.histories[idx]);
            GridData colM = new GridData();
            colM.widthHint = 100;
            colM.verticalSpan = 0;
            colM.heightHint = height;
            GridData colL = new GridData(768);
            colL.verticalSpan = 0;
            colL.heightHint = height;
            CLabel col1 = new CLabel(historyTable, 16384);
            CLabel col2 = new CLabel(historyTable, 16384);
            CLabel col3 = new CLabel(historyTable, 16384);
            Label col4 = new Label(historyTable, 16384);
            Label col5 = new Label(historyTable, 16384);
            String dateStr = BTSUtility.formatDate(this.histories[idx].getUpdateDate(), "yyyy/MM/dd HH:mm");
            col1.setText(dateStr);
            col1.setBackground(headBackground);
            col1.setLayoutData((Object)colM);
            String userName = this.histories[idx].getUpdateUser();
            col2.setText(userName);
            col2.setBackground(headBackground);
            col2.setLayoutData((Object)colM);
            String updAttribute = this.getUpdateAttribute(this.histories[idx]);
            col3.setText(updAttribute);
            col3.setBackground(headBackground);
            col3.setLayoutData((Object)colM);
            String updBefore = this.getUpdateBefore(this.histories[idx]);
            col4.setText(updBefore);
            col4.setBackground(headBackground);
            col4.setLayoutData((Object)colL);
            String updAfter = this.getUpdateAfter(this.histories[idx]);
            col5.setText(updAfter);
            col5.setBackground(headBackground);
            col5.setLayoutData((Object)colL);
            ++idx;
        }
    }

    private String getUpdateAttribute(IssueHistory issueHistory) {
        String updAttribute = issueHistory.getUpdateAttribute();
        if (updAttribute == null) {
            return "";
        }
        return updAttribute;
    }

    private String getUpdateAfter(IssueHistory issueHistory) {
        String updateAfter = issueHistory.getUpdateAfter();
        if (updateAfter == null) {
            return "";
        }
        return updateAfter;
    }

    private String getUpdateBefore(IssueHistory issueHistory) {
        String updateBefore = issueHistory.getUpdateBefore();
        if (updateBefore == null) {
            return "";
        }
        return updateBefore;
    }

    private int computeHeightHint(IssueHistory issueHistory) {
        int row1Cnt = this.countRow(issueHistory.getUpdateBefore());
        int row2Cnt = this.countRow(issueHistory.getUpdateAfter());
        int ret = row1Cnt;
        if (row1Cnt < row2Cnt) {
            ret = row2Cnt;
        }
        return ret * 12 + 4;
    }

    private int countRow(String str) {
        if (str == null) {
            return 1;
        }
        String[] tmp = str.split("\n");
        return tmp.length;
    }

    public boolean isDirty() {
        return false;
    }

    public void setFocus() {
        this.sectionComposit.setFocus();
    }

    protected void fireIssueChange() {
    }
}

