/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.editor;

import jp.valtech.bts.data.CommentHistory;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueHistory;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.SaveIssueAction;
import jp.valtech.bts.ui.editor.CommentPart;
import jp.valtech.bts.ui.editor.HistoryPart;
import jp.valtech.bts.ui.editor.IssueMultiPageEditorInput;
import jp.valtech.bts.ui.editor.Messages;
import jp.valtech.bts.ui.editor.OverviewPart;
import jp.valtech.bts.util.Logging;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

public class IssueMultiPageEditor
extends MultiPageEditorPart
implements Logging {
    public static final Image IMG_ISSUE = BtsPlugin.getInstance().getImage("issue.gif");
    public static final Image IMG_ISSUE_CONFLICT = BtsPlugin.getInstance().getImage("issue_conflict.gif");
    public static final Image IMG_ISSUE_DRAFT = BtsPlugin.getInstance().getImage("issue_draft.gif");
    public static final Image IMG_ISSUE_GARBAGE = BtsPlugin.getInstance().getImage("issue_garbage.gif");
    private static final int PAGE_INDEX_OVERVIEW = 0;
    private static final int PAGE_INDEX_COMMENT = 1;
    private static final int PAGE_INDEX_HISTORY = 2;
    private OverviewPart overviewPage;
    private CommentPart commentPage;
    private HistoryPart historyPage;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (!(input instanceof IssueMultiPageEditorInput)) {
            throw new PartInitException(Messages.getString("IssueMultiPageEditor.0"));
        }
        IssueMultiPageEditorInput issueEditorInput = (IssueMultiPageEditorInput)input;
        this.setPartName(this.getTitleStr(issueEditorInput.getIssue()));
        this.setTitleImage(this.getImage(issueEditorInput.getIssue()));
    }

    protected void createPages() {
        try {
            this.overviewPage = new OverviewPart(this);
            this.addPage((IEditorPart)this.overviewPage, this.getEditorInput());
            this.setPageText(0, OverviewPart.TAB_TITLE);
            this.commentPage = new CommentPart(this);
            this.addPage((IEditorPart)this.commentPage, this.getEditorInput());
            this.setPageText(1, CommentPart.TAB_TITLE);
            this.historyPage = new HistoryPart();
            this.addPage((IEditorPart)this.historyPage, this.getEditorInput());
            this.setPageText(2, HistoryPart.TAB_TITLE);
        }
        catch (Exception e) {
            String msg = Messages.getString("IssueMultiPageEditor.1");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    public Issue getModifiedIssue() {
        return this.overviewPage.getModifiedIssue();
    }

    public String getNewComment() {
        return this.commentPage.getNewComment();
    }

    public void postIssueSave(Issue issue) {
        this.overviewPage.postSave(issue);
        this.setTitleImage(this.getImage(issue));
        this.setPartName(this.getTitleStr(issue));
    }

    public void postCommentHistorySave(CommentHistory[] commentHistories) {
        this.commentPage.postSave(commentHistories);
    }

    public void postIssueHistorySave(IssueHistory[] issueHistories) {
        this.historyPage.postSave(issueHistories);
    }

    void changeHistoryPage() {
        this.setActivePage(2);
        this.pageChange(2);
    }

    void changeOverviewPage() {
        this.setActivePage(0);
        this.pageChange(0);
    }

    public void dispose() {
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        IssueMultiPageEditorInput editorInput = (IssueMultiPageEditorInput)this.getEditorInput();
        String type = editorInput.getIssue().getType();
        if (type.equals("R")) {
            SaveIssueAction saveIssueAction = new SaveIssueAction();
            saveIssueAction.run();
        } else if (type.equals("D")) {
            SaveIssueAction saveIssueAction = new SaveIssueAction();
            saveIssueAction.run();
        } else if (type.equals("C")) {
            MessageDialog.openInformation((Shell)BtsPlugin.getInstance().getShell(), (String)"Infomation", (String)Messages.getString("IssueMultiPageEditor.2"));
        } else if (type.equals("G")) {
            MessageDialog.openInformation((Shell)BtsPlugin.getInstance().getShell(), (String)"Infomation", (String)Messages.getString("IssueMultiPageEditor.3"));
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private Image getImage(Issue issue) {
        if ("C".equals(issue.getType())) {
            return IMG_ISSUE_CONFLICT;
        }
        if ("D".equals(issue.getType())) {
            return IMG_ISSUE_DRAFT;
        }
        if ("G".equals(issue.getType())) {
            return IMG_ISSUE_GARBAGE;
        }
        return IMG_ISSUE;
    }

    private String getTitleStr(Issue issue) {
        IssueMultiPageEditorInput issueEditorInput = (IssueMultiPageEditorInput)this.getEditorInput();
        if (issueEditorInput.getOpenMode() == 1 && "D".equals(issue.getType())) {
            return String.valueOf(Messages.getString("IssueMultiPageEditor.4")) + issueEditorInput.getName();
        }
        return issueEditorInput.getName();
    }
}

