/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.issuelist;

import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.IssueStatus;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.OpenCalendarDlgAction;
import jp.valtech.bts.ui.issuelist.IssueFilter;
import jp.valtech.bts.ui.issuelist.IssueFilterManager;
import jp.valtech.bts.ui.issuelist.IssueListView;
import jp.valtech.bts.ui.issuelist.IssueListViewFilter;
import jp.valtech.bts.ui.issuelist.Messages;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class IssueFilterDialog
extends Dialog
implements Logging {
    private Text issueIDTxt;
    private Text frmDateTxt;
    private Text toDateTxt;
    private Combo titleCmb;
    private Text titleTxt;
    private Combo descCmb;
    private Text descTxt;
    private CheckboxTableViewer assignedViewer;
    private CheckboxTableViewer priorityViewer;
    private Button stOpenChk;
    private Button stAssignedChk;
    private Button stResolvedChk;
    private Button stVerifiedChk;
    private Button stClosedChk;
    private Button secretChk;
    private Button reserveChk;
    private Button deadLineChk;
    private IssueFilter oldConfig;
    private IssueListView view;
    private String[] assigned;
    private String[] priority;

    public IssueFilterDialog(IssueListView parent) {
        super(parent.getSite().getShell());
        this.view = parent;
        IDialogSettings settings = BtsPlugin.getInstance().getDialogSettings().getSection("IssueFilter");
        if (settings != null) {
            this.oldConfig = IssueFilterManager.getIssueFilter();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("IssueFilterDialog.0"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.createIssueIDArea(composite);
            this.createDateArea(composite);
            this.createContainsArea(composite);
            this.createTablesArea(composite);
            this.createStatusArea(composite);
            this.createSeparatorLine(composite);
            if (this.oldConfig != null) {
                this.loadFilterSettings();
            }
        }
        catch (Exception e) {
            String msg = Messages.getString("IssueFilterDialog.1");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
        return composite;
    }

    private void createIssueIDArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("IssueFilterDialog.2"));
        this.issueIDTxt = new Text(thisArea, 2048);
        GridData gridData = new GridData(4);
        gridData.widthHint = 80;
        this.issueIDTxt.setLayoutData((Object)gridData);
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("IssueFilterDialog.3"));
    }

    private void createDateArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("IssueFilterDialog.4"));
        this.frmDateTxt = new Text(thisArea, 2048);
        GridData gridData = new GridData(4);
        gridData.widthHint = 80;
        this.frmDateTxt.setLayoutData((Object)gridData);
        ImageHyperlink calFrom = new ImageHyperlink(thisArea, 0);
        calFrom.setImage(BtsPlugin.getInstance().getImage("calendar.gif"));
        calFrom.setBackground(Display.getDefault().getSystemColor(22));
        calFrom.setToolTipText(Messages.getString("IssueFilterDialog.5"));
        calFrom.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OpenCalendarDlgAction action = new OpenCalendarDlgAction(IssueFilterDialog.this.frmDateTxt);
                action.run();
            }
        });
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("IssueFilterDialog.6"));
        this.toDateTxt = new Text(thisArea, 2048);
        this.toDateTxt.setLayoutData((Object)gridData);
        ImageHyperlink calTo = new ImageHyperlink(thisArea, 0);
        calTo.setImage(BtsPlugin.getInstance().getImage("calendar.gif"));
        calTo.setBackground(Display.getDefault().getSystemColor(22));
        calTo.setToolTipText(Messages.getString("IssueFilterDialog.7"));
        calTo.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OpenCalendarDlgAction action = new OpenCalendarDlgAction(IssueFilterDialog.this.toDateTxt);
                action.run();
            }
        });
        label = new Label(thisArea, 0);
        label.setText("(YYYY/MM/DD)");
    }

    private void createContainsArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        thisArea.setLayout((Layout)gridLayout);
        thisArea.setLayoutData((Object)new GridData(768));
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("IssueFilterDialog.8"));
        this.titleCmb = new Combo(thisArea, 8);
        this.titleCmb.add(Messages.getString("IssueFilterDialog.9"));
        this.titleCmb.add(Messages.getString("IssueFilterDialog.10"));
        this.titleCmb.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.titleCmb.select(this.titleCmb.indexOf(Messages.getString("IssueFilterDialog.11")));
        this.titleTxt = new Text(thisArea, 2052);
        this.titleTxt.setLayoutData((Object)new GridData(768));
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("IssueFilterDialog.12"));
        this.descCmb = new Combo(thisArea, 8);
        this.descCmb.add(Messages.getString("IssueFilterDialog.13"));
        this.descCmb.add(Messages.getString("IssueFilterDialog.14"));
        this.descCmb.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.descCmb.select(this.descCmb.indexOf(Messages.getString("IssueFilterDialog.15")));
        this.descTxt = new Text(thisArea, 2052);
        this.descTxt.setLayoutData((Object)new GridData(768));
    }

    private void createTablesArea(Composite parent) throws Exception {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.createPriorityArea(composite);
        this.createAssignedArea(composite);
    }

    private void createPriorityArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("IssueFilterDialog.16"));
        Table table = new Table(thisArea, 68386);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(350, true));
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setText(Messages.getString("IssueFilterDialog.17"));
        this.priorityViewer = new CheckboxTableViewer(table);
        GridData gridData = new GridData(768);
        gridData.heightHint = 45;
        gridData.widthHint = 180;
        this.priorityViewer.getControl().setLayoutData((Object)gridData);
        this.priorityViewer.setContentProvider((IContentProvider)this.getPriorityTableContentProvider());
        this.priorityViewer.setLabelProvider((IBaseLabelProvider)this.getPriorityTableLabelProvider());
        CurrentProject project = CurrentProject.getInsance();
        if (project.isOpen()) {
            ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade();
            this.priority = issueModifyFacade.getPriority();
            this.priorityViewer.setInput((Object)this.priority);
        }
        this.priorityViewer.setAllChecked(true);
    }

    private IStructuredContentProvider getPriorityTableContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return IssueFilterDialog.this.priority;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private ILabelProvider getPriorityTableLabelProvider() {
        return new PriorityTableLabelProvider();
    }

    private void createAssignedArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("IssueFilterDialog.18"));
        Table table = new Table(thisArea, 68386);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(350, true));
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setText(Messages.getString("IssueFilterDialog.19"));
        this.assignedViewer = new CheckboxTableViewer(table);
        GridData gridData = new GridData(768);
        gridData.heightHint = 45;
        gridData.widthHint = 180;
        this.assignedViewer.getControl().setLayoutData((Object)gridData);
        this.assignedViewer.setContentProvider((IContentProvider)this.getAssignedTableContentProvider());
        this.assignedViewer.setLabelProvider((IBaseLabelProvider)this.getAssignedTableLabelProvider());
        CurrentProject project = CurrentProject.getInsance();
        if (project.isOpen()) {
            ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade();
            this.assigned = issueModifyFacade.getAssigned();
            this.assignedViewer.setInput((Object)this.assigned);
        }
        this.assignedViewer.setAllChecked(true);
    }

    private IStructuredContentProvider getAssignedTableContentProvider() throws Exception {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return IssueFilterDialog.this.assigned;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private ILabelProvider getAssignedTableLabelProvider() {
        return new AssignedTableLabelProvider();
    }

    private void createStatusArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        thisArea.setLayout((Layout)gridLayout);
        thisArea.setLayoutData((Object)new GridData(768));
        Group statusGroup = new Group(thisArea, 0);
        statusGroup.setText(Messages.getString("IssueFilterDialog.20"));
        statusGroup.setLayoutData((Object)new GridData(768));
        statusGroup.setLayout((Layout)new GridLayout());
        this.stOpenChk = new Button((Composite)statusGroup, 32);
        this.stOpenChk.setText(IssueStatus.OPENED.getDescription());
        this.stOpenChk.setSelection(true);
        this.stAssignedChk = new Button((Composite)statusGroup, 32);
        this.stAssignedChk.setText(IssueStatus.ASSIGNED.getDescription());
        this.stAssignedChk.setSelection(true);
        this.stResolvedChk = new Button((Composite)statusGroup, 32);
        this.stResolvedChk.setText(IssueStatus.RESOLVED.getDescription());
        this.stResolvedChk.setSelection(true);
        this.stVerifiedChk = new Button((Composite)statusGroup, 32);
        this.stVerifiedChk.setText(IssueStatus.VERIFIED.getDescription());
        this.stVerifiedChk.setSelection(true);
        this.stClosedChk = new Button((Composite)statusGroup, 32);
        this.stClosedChk.setText(IssueStatus.CLOSED.getDescription());
        this.stClosedChk.setSelection(true);
        Group hiddenGroup = new Group(thisArea, 0);
        hiddenGroup.setText(Messages.getString("IssueFilterDialog.21"));
        hiddenGroup.setLayoutData((Object)new GridData(1808));
        hiddenGroup.setLayout((Layout)new GridLayout());
        this.secretChk = new Button((Composite)hiddenGroup, 32);
        this.secretChk.setText(Messages.getString("IssueFilterDialog.22"));
        this.secretChk.setSelection(true);
        this.reserveChk = new Button((Composite)hiddenGroup, 32);
        this.reserveChk.setText(Messages.getString("IssueFilterDialog.23"));
        this.reserveChk.setSelection(true);
        this.deadLineChk = new Button((Composite)hiddenGroup, 32);
        this.deadLineChk.setText(Messages.getString("IssueFilterDialog.24"));
        this.deadLineChk.setSelection(true);
    }

    protected void createSeparatorLine(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        separator.setLayoutData((Object)gd);
    }

    protected void okPressed() {
        String frmDateString = this.frmDateTxt.getText().trim();
        String toDateString = this.toDateTxt.getText().trim();
        if (!("".equals(frmDateString) && "".equals(toDateString) || BTSUtility.dateTextError(frmDateString, toDateString))) {
            return;
        }
        this.save();
        super.okPressed();
        IssueListViewFilter filter = new IssueListViewFilter(this.view);
        filter.addIssueFilters();
    }

    private boolean save() {
        IssueFilter newConfig = new IssueFilter();
        newConfig.setIssueID(this.issueIDTxt.getText().trim());
        newConfig.setFrmDate(this.frmDateTxt.getText().trim());
        newConfig.setToDate(this.toDateTxt.getText().trim());
        newConfig.setTitleCmb(this.titleCmb.getText());
        newConfig.setTitle(this.titleTxt.getText().trim());
        newConfig.setDescCmb(this.descCmb.getText());
        newConfig.setDesc(this.descTxt.getText().trim());
        StringBuffer notAssignedChk = new StringBuffer();
        int i = 0;
        while (i < ((String[])this.assignedViewer.getInput()).length) {
            if (!this.assignedViewer.getChecked(this.assignedViewer.getElementAt(i))) {
                notAssignedChk.append(this.assignedViewer.getElementAt(i) + "|");
            }
            ++i;
        }
        if (notAssignedChk.length() != 0) {
            notAssignedChk.deleteCharAt(notAssignedChk.length() - 1);
        }
        newConfig.setAssignedChk(new String(notAssignedChk));
        StringBuffer notPriorityChk = new StringBuffer();
        int i2 = 0;
        while (i2 < ((String[])this.priorityViewer.getInput()).length) {
            if (!this.priorityViewer.getChecked(this.priorityViewer.getElementAt(i2))) {
                notPriorityChk.append(this.priorityViewer.getElementAt(i2) + "|");
            }
            ++i2;
        }
        if (notPriorityChk.length() != 0) {
            notPriorityChk.deleteCharAt(notPriorityChk.length() - 1);
        }
        newConfig.setPriorityChk(new String(notPriorityChk));
        newConfig.setStOpenChk(this.stOpenChk.getSelection());
        newConfig.setStAssignedChk(this.stAssignedChk.getSelection());
        newConfig.setStResolvedChk(this.stResolvedChk.getSelection());
        newConfig.setStVerifiedChk(this.stVerifiedChk.getSelection());
        newConfig.setStClosedChk(this.stClosedChk.getSelection());
        newConfig.setSecretChk(this.secretChk.getSelection());
        newConfig.setReserveChk(this.reserveChk.getSelection());
        newConfig.setDeadLineChk(this.deadLineChk.getSelection());
        if (this.oldConfig == null) {
            IssueFilterManager.save(newConfig);
        } else {
            IssueFilterManager.modify(this.oldConfig, newConfig);
        }
        return true;
    }

    private void loadFilterSettings() {
        this.issueIDTxt.setText(this.oldConfig.getIssueID());
        this.frmDateTxt.setText(this.oldConfig.getFrmDate());
        this.toDateTxt.setText(this.oldConfig.getToDate());
        this.titleCmb.setText(this.oldConfig.getTitleCmb());
        this.titleTxt.setText(this.oldConfig.getTitle());
        this.descCmb.setText(this.oldConfig.getDescCmb());
        this.descTxt.setText(this.oldConfig.getDesc());
        String[] assignedArgs = this.oldConfig.getAssignedChk().split("\\|");
        int i = 0;
        while (i < assignedArgs.length) {
            this.assignedViewer.setChecked((Object)assignedArgs[i], false);
            ++i;
        }
        String[] prioritydArgs = this.oldConfig.getPriorityChk().split("\\|");
        int i2 = 0;
        while (i2 < prioritydArgs.length) {
            this.priorityViewer.setChecked((Object)prioritydArgs[i2], false);
            ++i2;
        }
        this.stOpenChk.setSelection(this.oldConfig.isStOpenChk());
        this.stAssignedChk.setSelection(this.oldConfig.isStAssignedChk());
        this.stResolvedChk.setSelection(this.oldConfig.isStResolvedChk());
        this.stVerifiedChk.setSelection(this.oldConfig.isStVerifiedChk());
        this.stClosedChk.setSelection(this.oldConfig.isStClosedChk());
        this.secretChk.setSelection(this.oldConfig.isSecretChk());
        this.reserveChk.setSelection(this.oldConfig.isReserveChk());
        this.deadLineChk.setSelection(this.oldConfig.isDeadLineChk());
    }

    private class PriorityTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PriorityTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return element.toString();
                }
            }
            return "";
        }
    }

    private class AssignedTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private AssignedTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return element.toString();
                }
            }
            return "";
        }
    }
}

