/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.issuelist;

import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.issuelist.IssueFilter;
import org.eclipse.jface.dialogs.IDialogSettings;

public class IssueFilterManager {
    private static IDialogSettings setting = BtsPlugin.getInstance().getDialogSettings();
    public static final String SECTION_NAME = "IssueFilter";
    public static final String KEY_ISSUEID = "ISSUEID";
    public static final String KEY_FROM = "FROM";
    public static final String KEY_TO = "TO";
    public static final String KEY_TITLECOMBO = "TITLECOMBO";
    public static final String KEY_TITLE = "TITLE";
    public static final String KEY_DESCCOMBO = "DESCCOMBO";
    public static final String KEY_DESC = "DESC";
    public static final String KEY_ASSIGNED = "ASSIGNED";
    public static final String KEY_PRIORITY = "PRIORITY";
    public static final String KEY_STOPEN = "STOPEN";
    public static final String KEY_STASSIGNED = "STASSIGNED";
    public static final String KEY_STRESOLVED = "STRESOLVED";
    public static final String KEY_STVERIFIED = "STVERIFIED";
    public static final String KEY_STCLOSED = "STCLOSED";
    public static final String KEY_SECRET = "SECRET";
    public static final String KEY_RESERVE = "RESERVE";
    public static final String KEY_DEADLINE = "DEADLINE";

    public static void save(IssueFilter config) {
        IDialogSettings section = setting.addNewSection(SECTION_NAME);
        IssueFilterManager.setIssueFilter(section, config);
        setting.addSection(section);
    }

    public static void modify(IssueFilter oldConfig, IssueFilter newConfig) {
        IDialogSettings section = setting.getSection(SECTION_NAME);
        IssueFilterManager.setIssueFilter(section, newConfig);
    }

    public static void setIssueFilter(IDialogSettings section, IssueFilter config) {
        section.put(KEY_ISSUEID, config.getIssueID());
        section.put(KEY_FROM, config.getFrmDate());
        section.put(KEY_TO, config.getToDate());
        section.put(KEY_TITLECOMBO, config.getTitleCmb());
        section.put(KEY_TITLE, config.getTitle());
        section.put(KEY_DESCCOMBO, config.getDescCmb());
        section.put(KEY_DESC, config.getDesc());
        section.put(KEY_ASSIGNED, config.getAssignedChk());
        section.put(KEY_PRIORITY, config.getPriorityChk());
        section.put(KEY_STOPEN, config.isStOpenChk());
        section.put(KEY_STASSIGNED, config.isStAssignedChk());
        section.put(KEY_STRESOLVED, config.isStResolvedChk());
        section.put(KEY_STVERIFIED, config.isStVerifiedChk());
        section.put(KEY_STCLOSED, config.isStClosedChk());
        section.put(KEY_SECRET, config.isSecretChk());
        section.put(KEY_RESERVE, config.isReserveChk());
        section.put(KEY_DEADLINE, config.isDeadLineChk());
    }

    public static IssueFilter getIssueFilter() {
        IDialogSettings section = setting.getSection(SECTION_NAME);
        IssueFilter config = new IssueFilter();
        config.setIssueID(section.get(KEY_ISSUEID));
        config.setFrmDate(section.get(KEY_FROM));
        config.setToDate(section.get(KEY_TO));
        config.setTitleCmb(section.get(KEY_TITLECOMBO));
        config.setTitle(section.get(KEY_TITLE));
        config.setDescCmb(section.get(KEY_DESCCOMBO));
        config.setDesc(section.get(KEY_DESC));
        config.setAssignedChk(section.get(KEY_ASSIGNED));
        config.setPriorityChk(section.get(KEY_PRIORITY));
        config.setStOpenChk(section.getBoolean(KEY_STOPEN));
        config.setStAssignedChk(section.getBoolean(KEY_STASSIGNED));
        config.setStResolvedChk(section.getBoolean(KEY_STRESOLVED));
        config.setStVerifiedChk(section.getBoolean(KEY_STVERIFIED));
        config.setStClosedChk(section.getBoolean(KEY_STCLOSED));
        config.setSecretChk(section.getBoolean(KEY_SECRET));
        config.setReserveChk(section.getBoolean(KEY_RESERVE));
        config.setDeadLineChk(section.getBoolean(KEY_DEADLINE));
        return config;
    }
}

