/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.issuelist;

import java.util.ArrayList;
import java.util.List;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsViewPart;
import jp.valtech.bts.ui.action.DeleteIssueAction;
import jp.valtech.bts.ui.action.OpenIssueAction;
import jp.valtech.bts.ui.action.OpenIssueFilterDlgAction;
import jp.valtech.bts.ui.action.SendGarbageIssueAction;
import jp.valtech.bts.ui.issuelist.IssueListViewContentProvider;
import jp.valtech.bts.ui.issuelist.IssueListViewFilter;
import jp.valtech.bts.ui.issuelist.IssueListViewLabelProvider;
import jp.valtech.bts.ui.issuelist.IssueListViewSorter;
import jp.valtech.bts.ui.issuelist.Messages;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class IssueListView
extends ViewPart
implements IBtsViewPart,
Logging {
    private TableViewer viewer;
    private OpenIssueAction openIssueAction;
    private OpenIssueFilterDlgAction issueFilterAction;
    private SendGarbageIssueAction moveGarbageBoxAction;
    private DeleteIssueAction deleteIssueAction;

    public void createPartControl(Composite parent) {
        try {
            this.createIssueListTable(parent);
            this.makeActions();
            this.hookContextMenu();
            this.hookDoubleClickAction();
            this.fillLocalToolBar();
            IDialogSettings section = BtsPlugin.getInstance().getDialogSettings().getSection("IssueFilter");
            if (section != null) {
                IssueListViewFilter filter = new IssueListViewFilter(this);
                filter.setClearFilter();
                filter.addIssueFilters();
            }
        }
        catch (Exception e) {
            String msg = Messages.getString("IssueListView.0");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    public void updateDescription(int filterListSize) {
        this.setContentDescription(String.valueOf(Messages.getString("IssueListView.1")) + filterListSize + Messages.getString("IssueListView.2"));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IssueListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        Issue issue = this.getSelectionRecord();
        if (issue != null) {
            this.openIssueAction.setIssue(issue);
            manager.add((IAction)this.openIssueAction);
            if (!"G".equals(issue.getType())) {
                if ("D".equals(issue.getType())) {
                    this.deleteIssueAction.setIssue(issue);
                    manager.add((IAction)this.deleteIssueAction);
                } else if ("C".equals(issue.getType())) {
                    this.deleteIssueAction.setIssue(issue);
                    manager.add((IAction)this.deleteIssueAction);
                } else {
                    this.moveGarbageBoxAction.setIssue(issue);
                    manager.add((IAction)this.moveGarbageBoxAction);
                }
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = bars.getToolBarManager();
        toolbar.add((IAction)this.issueFilterAction);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Issue issue = IssueListView.this.getSelectionRecord();
                IssueListView.this.openIssueAction.setIssue(issue);
                IssueListView.this.openIssueAction.run();
            }
        });
    }

    private void makeActions() {
        this.openIssueAction = new OpenIssueAction(1);
        this.issueFilterAction = new OpenIssueFilterDlgAction(this);
        this.moveGarbageBoxAction = new SendGarbageIssueAction();
        this.deleteIssueAction = new DeleteIssueAction();
        CurrentProject project = CurrentProject.getInsance();
        project.addAction(this.issueFilterAction);
        if (project.isOpen()) {
            this.issueFilterAction.setEnabled(true);
        } else {
            this.issueFilterAction.setEnabled(false);
        }
    }

    private Issue getSelectionRecord() {
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof Issue) {
            return (Issue)obj;
        }
        return null;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private void createIssueListTable(Composite parent) throws BtsDBException {
        Table table = new Table(parent, 68356);
        table.setLayoutData((Object)new GridData(1808));
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new TableViewer(table);
        SelectionListener headerListener = this.getColumnListener(this.viewer);
        TableColumn col1 = new TableColumn(table, 0, 0);
        col1.setText("");
        col1.setWidth(20);
        col1.setAlignment(16384);
        col1.addSelectionListener(headerListener);
        TableColumn col2 = new TableColumn(table, 0, 1);
        col2.setText("ID");
        col2.setWidth(100);
        col2.setAlignment(16384);
        col2.addSelectionListener(headerListener);
        TableColumn col3 = new TableColumn(table, 0, 2);
        col3.setText(Messages.getString("IssueListView.3"));
        col3.setWidth(300);
        col3.setAlignment(16384);
        col3.addSelectionListener(headerListener);
        TableColumn col4 = new TableColumn(table, 0, 3);
        col4.setText(Messages.getString("IssueListView.4"));
        col4.setWidth(55);
        col4.setAlignment(16384);
        col4.addSelectionListener(headerListener);
        TableColumn col5 = new TableColumn(table, 0, 4);
        col5.setText(Messages.getString("IssueListView.5"));
        col5.setWidth(55);
        col5.setAlignment(16384);
        col5.addSelectionListener(headerListener);
        TableColumn col6 = new TableColumn(table, 0, 5);
        col6.setText(Messages.getString("IssueListView.6"));
        col6.setWidth(75);
        col6.setAlignment(16384);
        col6.addSelectionListener(headerListener);
        TableColumn col7 = new TableColumn(table, 0, 6);
        col7.setText(Messages.getString("IssueListView.7"));
        col7.setWidth(100);
        col7.setAlignment(16384);
        col7.addSelectionListener(headerListener);
        TableColumn col8 = new TableColumn(table, 0, 7);
        col8.setText(Messages.getString("IssueListView.8"));
        col8.setWidth(105);
        col8.setAlignment(16384);
        col8.addSelectionListener(headerListener);
        IssueListViewContentProvider provider = new IssueListViewContentProvider(this);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new IssueListViewLabelProvider());
        IssueListViewSorter sorter = new IssueListViewSorter(7);
        sorter.setReversed(true);
        this.viewer.setSorter((ViewerSorter)sorter);
        this.viewer.setInput(new ArrayList());
        CurrentProject project = CurrentProject.getInsance();
        if (project.isOpen()) {
            ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade();
            List issueList = issueModifyFacade.getIssueList();
            provider.refresh(issueList);
        }
    }

    private SelectionListener getColumnListener(final TableViewer tableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = tableViewer.getTable().indexOf((TableColumn)e.widget);
                IssueListViewSorter oldSorter = (IssueListViewSorter)tableViewer.getSorter();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    tableViewer.refresh();
                } else {
                    tableViewer.setSorter((ViewerSorter)new IssueListViewSorter(column));
                }
            }
        };
    }

    public void dispose() {
        CurrentProject project = CurrentProject.getInsance();
        project.removeAction(this.issueFilterAction);
        super.dispose();
    }
}

