/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.issuelist;

import java.text.SimpleDateFormat;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueStatus;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.BTSUtility;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class IssueListViewLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private static final Image IMG_ERROR = BtsPlugin.getInstance().getImage("error1.gif");
    private static final Image IMG_WARNING = BtsPlugin.getInstance().getImage("warning1.gif");
    private static final Color COLOR_GRAY = new Color((Device)Display.getCurrent(), 160, 160, 160);

    public String getColumnText(Object obj, int index) {
        Issue issue = (Issue)obj;
        switch (index) {
            case 1: {
                return issue.getDisplayIssueID();
            }
            case 2: {
                return issue.getTitle();
            }
            case 3: {
                return issue.getCategory();
            }
            case 4: {
                return issue.getPriority();
            }
            case 5: {
                IssueStatus issueStatus = IssueStatus.getEnumFromValue(issue.getStatus());
                return issueStatus.getDescription();
            }
            case 6: {
                return issue.getAssigned();
            }
            case 7: {
                if (issue.getCreateDate() == null) {
                    return "";
                }
                return FORMATTER.format(issue.getCreateDate());
            }
        }
        return "";
    }

    public Image getColumnImage(Object obj, int index) {
        Issue issue = (Issue)obj;
        switch (index) {
            case 0: {
                int judge = BTSUtility.judgeLimit(issue);
                if (judge == 2) {
                    return IMG_ERROR;
                }
                if (judge != 1) break;
                return IMG_WARNING;
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        Issue issue = (Issue)element;
        if ("5".equals(issue.getStatus())) {
            return COLOR_GRAY;
        }
        return null;
    }
}

