/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.msglist;

import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.facade.MessagePacketFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.OpenCalendarDlgAction;
import jp.valtech.bts.ui.msglist.MessageFilter;
import jp.valtech.bts.ui.msglist.MessageFilterManager;
import jp.valtech.bts.ui.msglist.MessageListView;
import jp.valtech.bts.ui.msglist.MessageListViewFilter;
import jp.valtech.bts.ui.msglist.Messages;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class MessageFilterDialog
extends Dialog
implements Logging {
    private Text frmDateTxt;
    private Text toDateTxt;
    private Combo messageCmb;
    private Text messageTxt;
    private Button msgSystemChk;
    private Button msgUserChk;
    private CheckboxTableViewer senderViewer;
    private MessageFilter oldConfig;
    private TableViewer viewer;
    private String[] fromUser;

    public MessageFilterDialog(MessageListView parent) {
        super(parent.getSite().getShell());
        this.viewer = parent.getViewer();
        IDialogSettings settings = BtsPlugin.getInstance().getDialogSettings().getSection("MessageFilter");
        if (settings != null) {
            this.oldConfig = MessageFilterManager.getMessageFilter();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("MessageFilterDialog.0"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.createStatusArea(composite);
            this.createContainsArea(composite);
            this.createDateArea(composite);
            this.createAssignedArea(composite);
            this.createSeparatorLine(composite);
            if (this.oldConfig != null) {
                this.loadFilterSettings();
            }
        }
        catch (Exception e) {
            String msg = Messages.getString("MessageFilterDialog.1");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
        return composite;
    }

    private void createDateArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("MessageFilterDialog.2"));
        this.frmDateTxt = new Text(thisArea, 2048);
        GridData gridData = new GridData(4);
        gridData.widthHint = 80;
        this.frmDateTxt.setLayoutData((Object)gridData);
        ImageHyperlink calFrom = new ImageHyperlink(thisArea, 0);
        calFrom.setImage(BtsPlugin.getInstance().getImage("calendar.gif"));
        calFrom.setBackground(Display.getDefault().getSystemColor(22));
        calFrom.setToolTipText(Messages.getString("MessageFilterDialog.3"));
        calFrom.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OpenCalendarDlgAction action = new OpenCalendarDlgAction(MessageFilterDialog.this.frmDateTxt);
                action.run();
            }
        });
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("MessageFilterDialog.4"));
        this.toDateTxt = new Text(thisArea, 2048);
        this.toDateTxt.setLayoutData((Object)gridData);
        ImageHyperlink calTo = new ImageHyperlink(thisArea, 0);
        calTo.setImage(BtsPlugin.getInstance().getImage("calendar.gif"));
        calTo.setBackground(Display.getDefault().getSystemColor(22));
        calTo.setToolTipText(Messages.getString("MessageFilterDialog.5"));
        calTo.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OpenCalendarDlgAction action = new OpenCalendarDlgAction(MessageFilterDialog.this.toDateTxt);
                action.run();
            }
        });
        label = new Label(thisArea, 0);
        label.setText("(YYYY/MM/DD)");
    }

    private void createContainsArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        thisArea.setLayout((Layout)gridLayout);
        thisArea.setLayoutData((Object)new GridData(768));
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("MessageFilterDialog.6"));
        this.messageCmb = new Combo(thisArea, 8);
        this.messageCmb.add(Messages.getString("MessageFilterDialog.7"));
        this.messageCmb.add(Messages.getString("MessageFilterDialog.8"));
        this.messageCmb.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.messageCmb.select(this.messageCmb.indexOf(Messages.getString("MessageFilterDialog.9")));
        this.messageTxt = new Text(thisArea, 2052);
        this.messageTxt.setLayoutData((Object)new GridData(768));
    }

    private void createAssignedArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("MessageFilterDialog.10"));
        Table table = new Table(thisArea, 68386);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(350, true));
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setText(Messages.getString("MessageFilterDialog.11"));
        this.senderViewer = new CheckboxTableViewer(table);
        GridData gridData = new GridData(768);
        gridData.heightHint = 60;
        gridData.widthHint = 350;
        this.senderViewer.getControl().setLayoutData((Object)gridData);
        this.senderViewer.setContentProvider((IContentProvider)this.getAssignedTableContentProvider());
        this.senderViewer.setLabelProvider((IBaseLabelProvider)this.getAssignedTableLabelProvider());
        CurrentProject project = CurrentProject.getInsance();
        if (project.isOpen()) {
            MessagePacketFacade messagePacketFacade = new MessagePacketFacade();
            this.fromUser = messagePacketFacade.getFromUser();
            this.senderViewer.setInput((Object)this.fromUser);
        }
        this.senderViewer.setAllChecked(true);
    }

    private IStructuredContentProvider getAssignedTableContentProvider() throws Exception {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return MessageFilterDialog.this.fromUser;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private ILabelProvider getAssignedTableLabelProvider() {
        return new AssignedTableLabelProvider();
    }

    private void createStatusArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        thisArea.setLayoutData((Object)new GridData(768));
        this.msgSystemChk = new Button(thisArea, 32);
        this.msgSystemChk.setText(Messages.getString("MessageFilterDialog.12"));
        this.msgSystemChk.setSelection(true);
        this.msgUserChk = new Button(thisArea, 32);
        this.msgUserChk.setText(Messages.getString("MessageFilterDialog.13"));
        this.msgUserChk.setSelection(true);
    }

    protected void createSeparatorLine(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        separator.setLayoutData((Object)gd);
    }

    protected void okPressed() {
        String frmDateString = this.frmDateTxt.getText().trim();
        String toDateString = this.toDateTxt.getText().trim();
        if (!("".equals(frmDateString) && "".equals(toDateString) || BTSUtility.dateTextError(frmDateString, toDateString))) {
            return;
        }
        this.save();
        super.okPressed();
        MessageListViewFilter filter = new MessageListViewFilter(this.viewer);
        filter.addMessageFilters();
    }

    private void save() {
        MessageFilter newConfig = new MessageFilter();
        newConfig.setMsgSystemChk(this.msgSystemChk.getSelection());
        newConfig.setMsgUserChk(this.msgUserChk.getSelection());
        newConfig.setMessageCmb(this.messageCmb.getText());
        newConfig.setMessage(this.messageTxt.getText().trim());
        newConfig.setFrmDate(this.frmDateTxt.getText().trim());
        newConfig.setToDate(this.toDateTxt.getText().trim());
        StringBuffer notsenderChk = new StringBuffer();
        int i = 0;
        while (i < ((String[])this.senderViewer.getInput()).length) {
            if (!this.senderViewer.getChecked(this.senderViewer.getElementAt(i))) {
                notsenderChk.append(this.senderViewer.getElementAt(i) + "|");
            }
            ++i;
        }
        if (notsenderChk.length() != 0) {
            notsenderChk.deleteCharAt(notsenderChk.length() - 1);
        }
        newConfig.setSenderChk(new String(notsenderChk));
        if (this.oldConfig == null) {
            MessageFilterManager.save(newConfig);
        } else {
            MessageFilterManager.modify(this.oldConfig, newConfig);
        }
    }

    private void loadFilterSettings() {
        this.msgSystemChk.setSelection(this.oldConfig.isMsgSystemChk());
        this.msgUserChk.setSelection(this.oldConfig.isMsgUserChk());
        this.messageCmb.setText(this.oldConfig.getMessageCmb());
        this.messageTxt.setText(this.oldConfig.getMessage());
        this.frmDateTxt.setText(this.oldConfig.getFrmDate());
        this.toDateTxt.setText(this.oldConfig.getToDate());
        String[] tmp = this.oldConfig.getSenderChk().split("\\|");
        int i = 0;
        while (i < tmp.length) {
            this.senderViewer.setChecked((Object)tmp[i], false);
            ++i;
        }
    }

    private class AssignedTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private AssignedTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return element.toString();
                }
            }
            return "";
        }
    }
}

