/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.msglist;

import java.util.ArrayList;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.facade.MessagePacketFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsViewPart;
import jp.valtech.bts.ui.action.DeleteMessageAction;
import jp.valtech.bts.ui.action.DownloadMessageAttachmentAction;
import jp.valtech.bts.ui.action.OpenIssueAction;
import jp.valtech.bts.ui.action.OpenMessageDlgAction;
import jp.valtech.bts.ui.action.OpenMsgFilterDlgAction;
import jp.valtech.bts.ui.msglist.MessageListViewContentProvider;
import jp.valtech.bts.ui.msglist.MessageListViewFilter;
import jp.valtech.bts.ui.msglist.MessageListViewLabelProvider;
import jp.valtech.bts.ui.msglist.MessageListViewSorter;
import jp.valtech.bts.ui.msglist.Messages;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class MessageListView
extends ViewPart
implements IBtsViewPart,
Logging {
    private OpenMessageDlgAction openMsgDlgAction;
    private OpenMessageDlgAction replyMsgDlgAction;
    private OpenMsgFilterDlgAction openFilterDlgAction;
    private DownloadMessageAttachmentAction saveAttachmentAction;
    private OpenIssueAction openIssueAction;
    private DeleteMessageAction deleteMessageAction;
    private TableViewer viewer;
    private Text msgTxt;

    public void createPartControl(Composite parent) {
        try {
            SashForm sashForm = new SashForm(parent, 256);
            sashForm.setLayoutData((Object)new GridData(1808));
            this.createMessageListTable((Composite)sashForm);
            this.createRightPain((Composite)sashForm);
            sashForm.setWeights(new int[]{62, 38});
            this.makeActions();
            this.hookContextMenu();
            this.hookDoubleClick();
            this.hookSingleClick();
            this.fillLocalToolBar();
            IDialogSettings section = BtsPlugin.getInstance().getDialogSettings().getSection("MessageFilter");
            if (section != null) {
                MessageListViewFilter filter = new MessageListViewFilter(this.viewer);
                filter.addMessageFilters();
            }
        }
        catch (Exception e) {
            String msg = Messages.getString("MessageListView.0");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    private MessagePacket getSelectionRecord() {
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof MessagePacket) {
            return (MessagePacket)obj;
        }
        return null;
    }

    private void hookSingleClick() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Control ctrl = MessageListView.this.viewer.getControl();
                ctrl.getDisplay().syncExec(new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        try {
                            MessagePacket msg = MessageListView.access$1(1.access$0(this.this$1));
                            if (msg == null) {
                                return;
                            }
                            MessageListView.access$2(1.access$0(this.this$1)).setText(msg.getMessage());
                            if (!msg.isOpend().booleanValue()) {
                                MessagePacketFacade facade = new MessagePacketFacade();
                                facade.setOpend(msg.getMessageID());
                                msg.setOpened(true);
                                MessageListView.access$0(1.access$0(this.this$1)).refresh();
                            }
                        }
                        catch (Exception e) {
                            String msg = Messages.getString("MessageListView.1");
                            logger.fatal((Object)msg, (Throwable)e);
                            BtsPlugin.getInstance().error(msg, e);
                        }
                    }
                });
            }

            static /* synthetic */ MessageListView access$0(1 var0) {
                return var0.MessageListView.this;
            }
        });
    }

    private void hookDoubleClick() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MessagePacket msg = MessageListView.this.getSelectionRecord();
                if (msg == null) {
                    return;
                }
                MessageListView.this.replyMsgDlgAction.setFromUser(msg.getFromUser());
                MessageListView.this.replyMsgDlgAction.setReplyMessage(msg.getMessage());
                MessageListView.this.replyMsgDlgAction.run();
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MessageListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        MessagePacket msg = this.getSelectionRecord();
        if (msg == null) {
            manager.add((IContributionItem)new Separator("additions"));
            return;
        }
        String msgType = msg.getMessageType();
        if ("I".equals(msgType)) {
            this.openIssueAction.setIssueKeys(msg.getFingerPrint(), msg.getIssueType());
            manager.add((IAction)this.openIssueAction);
        } else if ("C".equals(msgType)) {
            this.openIssueAction.setIssueKeys(msg.getFingerPrint(), msg.getIssueType());
            manager.add((IAction)this.openIssueAction);
        } else if ("U".equals(msgType) && msg.getAttachFileName() != null && !msg.getAttachFileName().equals("")) {
            this.saveAttachmentAction.setMessagePacket(msg);
            manager.add((IAction)this.saveAttachmentAction);
        }
        this.replyMsgDlgAction.setFromUser(msg.getFromUser());
        this.replyMsgDlgAction.setReplyMessage(msg.getMessage());
        manager.add((IAction)this.replyMsgDlgAction);
        manager.add((IContributionItem)new Separator());
        this.deleteMessageAction.setMessagePacket(msg);
        manager.add((IAction)this.deleteMessageAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = bars.getToolBarManager();
        toolbar.add((IAction)this.openMsgDlgAction);
        toolbar.add((IAction)this.openFilterDlgAction);
    }

    private void makeActions() {
        this.openIssueAction = new OpenIssueAction(1);
        this.openMsgDlgAction = new OpenMessageDlgAction(this);
        this.openMsgDlgAction.setText(Messages.getString("MessageListView.2"));
        this.openMsgDlgAction.setToolTipText(Messages.getString("MessageListView.3"));
        this.replyMsgDlgAction = new OpenMessageDlgAction(this);
        this.replyMsgDlgAction.setText(Messages.getString("MessageListView.4"));
        this.openFilterDlgAction = new OpenMsgFilterDlgAction(this);
        this.deleteMessageAction = new DeleteMessageAction();
        this.saveAttachmentAction = new DownloadMessageAttachmentAction();
        CurrentProject project = CurrentProject.getInsance();
        project.addAction(this.openFilterDlgAction);
        project.addAction(this.openMsgDlgAction);
        if (project.isOpen()) {
            this.openFilterDlgAction.setEnabled(true);
            this.openMsgDlgAction.setEnabled(true);
        } else {
            this.openFilterDlgAction.setEnabled(false);
            this.openMsgDlgAction.setEnabled(false);
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createRightPain(Composite parent) {
        this.msgTxt = new Text(parent, 8389194);
        Display display = parent.getDisplay();
        this.msgTxt.setBackground(display.getSystemColor(1));
    }

    private void createMessageListTable(Composite parent) {
        Table table = new Table(parent, 68356);
        table.setLayoutData((Object)new GridData(1808));
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MessagePacket msg;
                if (e.character == '\u007f' && (msg = MessageListView.this.getSelectionRecord()) != null) {
                    MessageListView.this.deleteMessageAction.setMessagePacket(msg);
                    MessageListView.this.deleteMessageAction.run();
                }
            }
        });
        this.viewer = new TableViewer(table);
        SelectionListener headerListener = this.getColumnListener(this.viewer);
        TableColumn col1 = new TableColumn(table, 0, 0);
        col1.setText("");
        col1.setWidth(20);
        col1.setAlignment(16384);
        col1.addSelectionListener(headerListener);
        TableColumn col2 = new TableColumn(table, 0, 1);
        col2.setText(Messages.getString("MessageListView.5"));
        col2.setWidth(300);
        col2.setAlignment(16384);
        col2.addSelectionListener(headerListener);
        TableColumn col3 = new TableColumn(table, 0, 2);
        col3.setText(Messages.getString("MessageListView.6"));
        col3.setWidth(80);
        col3.setAlignment(16384);
        col3.addSelectionListener(headerListener);
        TableColumn col4 = new TableColumn(table, 0, 3);
        col4.setText(Messages.getString("MessageListView.7"));
        col4.setWidth(105);
        col4.setAlignment(16384);
        col4.addSelectionListener(headerListener);
        MessageListViewContentProvider provider = new MessageListViewContentProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new MessageListViewLabelProvider());
        MessageListViewSorter sorter = new MessageListViewSorter(3);
        sorter.setReversed(true);
        this.viewer.setSorter((ViewerSorter)sorter);
        this.viewer.setInput(new ArrayList());
        CurrentProject project = CurrentProject.getInsance();
        if (project.isOpen()) {
            provider.refresh(null);
        }
    }

    public Text getMsgTxt() {
        return this.msgTxt;
    }

    public void updateDescription(int filterListSize) {
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private SelectionListener getColumnListener(final TableViewer tableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = tableViewer.getTable().indexOf((TableColumn)e.widget);
                MessageListViewSorter oldSorter = (MessageListViewSorter)tableViewer.getSorter();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    tableViewer.refresh();
                } else {
                    tableViewer.setSorter((ViewerSorter)new MessageListViewSorter(column));
                }
            }
        };
    }

    public void dispose() {
        CurrentProject project = CurrentProject.getInsance();
        project.removeAction(this.openFilterDlgAction);
        project.removeAction(this.openMsgDlgAction);
        super.dispose();
    }

    static /* synthetic */ Text access$2(MessageListView messageListView) {
        return messageListView.msgTxt;
    }
}

