/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.msglist;

import java.util.List;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.facade.MessagePacketFacade;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;
import jp.valtech.bts.ui.msglist.Messages;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class MessageListViewContentProvider
implements IStructuredContentProvider,
IBtsListener,
Logging {
    private TableViewer viewer;

    public MessageListViewContentProvider() {
        BtsPlugin.getInstance().addListener(this);
    }

    public void dispose() {
        BtsPlugin.getInstance().removeListener(this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TableViewer)viewer;
    }

    public Object[] getElements(Object inputElement) {
        return ((List)inputElement).toArray();
    }

    public void addIssue(Issue issue) {
    }

    public void updateIssue(Issue oldIssue, Issue newIssue) {
    }

    public void deleteIssue(Issue deleteIssue) {
    }

    public void joinMember(ClientInfo clientInfo) {
    }

    public void leaveMember(ClientInfo clientInfo) {
    }

    public void addMessage(final MessagePacket messagePacket) {
        if (this.viewer == null) {
            return;
        }
        List msgList = (List)this.viewer.getInput();
        msgList.add(messagePacket);
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    MessageListViewContentProvider.this.viewer.insert((Object)messagePacket, 0);
                }
                catch (Exception e) {
                    String msg = Messages.getString("MessageListViewContentProvider.0");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }

    public void deleteMessage(final MessagePacket messagePacket) {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    List messageList = (List)MessageListViewContentProvider.this.viewer.getInput();
                    messageList.remove(messagePacket);
                    MessageListViewContentProvider.this.viewer.remove((Object)messagePacket);
                }
                catch (Exception e) {
                    String msg = Messages.getString("MessageListViewContentProvider.1");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }

    public void refresh(List issueList) {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    List oldMessageList = (List)MessageListViewContentProvider.this.viewer.getInput();
                    if (oldMessageList != null) {
                        oldMessageList.clear();
                    }
                    MessageListViewContentProvider.this.viewer.refresh();
                    MessagePacketFacade messagePacketFacade = new MessagePacketFacade();
                    List newMessageList = messagePacketFacade.getMessageList();
                    MessageListViewContentProvider.this.viewer.setInput((Object)newMessageList);
                }
                catch (Exception e) {
                    String msg = Messages.getString("MessageListViewContentProvider.2");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }

    public void clear() {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    List list = (List)MessageListViewContentProvider.this.viewer.getInput();
                    list.clear();
                    MessageListViewContentProvider.this.viewer.refresh();
                }
                catch (Exception e) {
                    String msg = Messages.getString("MessageListViewContentProvider.3");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }
}

