/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.msglist;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.msglist.Messages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class MessageListViewFilter {
    private TableViewer viewer;
    IDialogSettings section = BtsPlugin.getInstance().getDialogSettings().getSection("MessageFilter");

    public MessageListViewFilter(TableViewer viewer) {
        this.viewer = viewer;
    }

    public void addMessageFilters() {
        this.viewer.resetFilters();
        if (!this.section.getBoolean("SYSTEM")) {
            this.viewer.addFilter((ViewerFilter)new SystemFilter());
        }
        if (!this.section.getBoolean("USER")) {
            this.viewer.addFilter((ViewerFilter)new UserFilter());
        }
        if (!"".equals(this.section.get("MESSAGE"))) {
            this.viewer.addFilter((ViewerFilter)new MessageFilter());
        }
        if (!"".equals(this.section.get("FROM")) && !"".equals(this.section.get("TO"))) {
            this.viewer.addFilter((ViewerFilter)new DateFromFilter());
            this.viewer.addFilter((ViewerFilter)new DateToFilter());
        } else if (!"".equals(this.section.get("FROM")) && "".equals(this.section.get("TO"))) {
            this.viewer.addFilter((ViewerFilter)new DateFromFilter());
        } else if ("".equals(this.section.get("FROM")) && !"".equals(this.section.get("TO"))) {
            this.viewer.addFilter((ViewerFilter)new DateToFilter());
        }
        if (!"".equals(this.section.get("SENDER"))) {
            String[] senderNames = this.section.get("SENDER").split("\\|");
            int i = 0;
            while (i < senderNames.length) {
                this.viewer.addFilter((ViewerFilter)new SenderFilter(senderNames[i]));
                ++i;
            }
        }
    }

    private class SystemFilter
    extends ViewerFilter {
        private SystemFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String messageType = ((MessagePacket)element).getMessageType();
            return "U".equals(messageType);
        }
    }

    private class UserFilter
    extends ViewerFilter {
        private UserFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String messageType = ((MessagePacket)element).getMessageType();
            return !"U".equals(messageType);
        }
    }

    private class MessageFilter
    extends ViewerFilter {
        private MessageFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            int index = ((MessagePacket)element).getMessage().indexOf(MessageListViewFilter.this.section.get("MESSAGE"));
            if (Messages.getString("MessageListViewFilter.0").equals(MessageListViewFilter.this.section.get("MESSAGECOMBO"))) {
                return index != -1;
            }
            return index == -1;
        }
    }

    private class DateFromFilter
    extends ViewerFilter {
        private DateFromFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            Date fromDate = null;
            try {
                fromDate = new Date(dateFormat.parse(MessageListViewFilter.this.section.get("FROM")).getTime());
            }
            catch (ParseException e) {
                BtsPlugin.getInstance().errorlog(e);
            }
            return ((MessagePacket)element).getSent().after(fromDate);
        }
    }

    private class DateToFilter
    extends ViewerFilter {
        private DateToFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            Date toDate = null;
            try {
                toDate = new Date(dateFormat.parse(MessageListViewFilter.this.section.get("TO")).getTime() + 86400000L);
            }
            catch (ParseException e) {
                BtsPlugin.getInstance().errorlog(e);
            }
            return ((MessagePacket)element).getSent().before(toDate);
        }
    }

    private class SenderFilter
    extends ViewerFilter {
        private String senderName;

        private SenderFilter(String senderName) {
            this.senderName = senderName;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !this.senderName.equals(((MessagePacket)element).getFromUser());
        }
    }
}

