/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.msglist;

import jp.valtech.bts.data.MessagePacket;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class MessageListViewSorter
extends ViewerSorter {
    private boolean reversed = false;
    private int columnNumber;

    public MessageListViewSorter(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result = 0;
        result = this.compareColumnValue((MessagePacket)e1, (MessagePacket)e2);
        if (this.reversed) {
            result = -result;
        }
        return result;
    }

    int compareColumnValue(MessagePacket e1, MessagePacket e2) {
        switch (this.columnNumber) {
            case 0: {
                return this.compareTo(e1.getMessageType(), e2.getMessageType());
            }
            case 1: {
                return this.compareTo(e1.getMessage(), e2.getMessage());
            }
            case 2: {
                return this.compareTo(e1.getFromUser(), e2.getFromUser());
            }
            case 3: {
                return this.compareTo(e1.getSent(), e2.getSent());
            }
        }
        return 0;
    }

    private int compareTo(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        if (obj1 != null && obj2 == null) {
            return 1;
        }
        if (obj1 == null && obj2 != null) {
            return -1;
        }
        return ((Comparable)obj1).compareTo((Comparable)obj2);
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }
}

