/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.navigator;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.OpenCalendarDlgAction;
import jp.valtech.bts.ui.navigator.Messages;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.IssueChartRender;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class IssueChartDialog
extends Dialog
implements Logging {
    private List chartIssueList;
    private Label chartLabel;
    private String currentDir = BtsPlugin.getInstance().getStateLocation() + "/";
    private Text frmDateTxt;
    private Text toDateTxt;
    private CheckboxTableViewer categoryViewer;
    private Button secretChk;
    private Button reserveChk;
    private String[] category;
    Color color = new Color((Device)Display.getCurrent(), 255, 255, 255);

    public IssueChartDialog(Shell parent, List chartIssueList) {
        super(parent);
        this.chartIssueList = chartIssueList;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("IssueChartDialog.0"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "jp.valtech.bts.help.chartContext");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            composite.setBackground(this.color);
            this.createChartArea(composite);
            this.createConditionArea(composite);
            this.createNotes(composite);
        }
        catch (Exception e) {
            String msg = Messages.getString("IssueChartDialog.14");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
        return composite;
    }

    private void createChartArea(Composite parent) {
        this.chartLabel = new Label(parent, 0);
        Image image = new Image((Device)Display.getCurrent(), String.valueOf(this.currentDir) + "bug.png");
        this.chartLabel.setImage(image);
    }

    private void createConditionArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setBackground(this.color);
        thisArea.setLayout((Layout)new GridLayout());
        GridData thisAreaGridData = new GridData(64);
        thisAreaGridData.widthHint = 400;
        thisArea.setLayoutData((Object)thisAreaGridData);
        Group group = new Group(thisArea, 0);
        group.setText(Messages.getString("IssueChartDialog.1"));
        group.setFont(new Font((Device)Display.getCurrent(), "", 10, 1));
        group.setBackground(this.color);
        GridLayout layout = new GridLayout();
        layout.numColumns = 8;
        layout.verticalSpacing = 10;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.getString("IssueChartDialog.2"));
        label.setBackground(this.color);
        this.frmDateTxt = new Text((Composite)group, 2048);
        GridData dateGridData = new GridData(768);
        dateGridData.widthHint = 80;
        this.frmDateTxt.setLayoutData((Object)dateGridData);
        ImageHyperlink calFrom = new ImageHyperlink((Composite)group, 0);
        calFrom.setImage(BtsPlugin.getInstance().getImage("calendar.gif"));
        calFrom.setBackground(Display.getDefault().getSystemColor(22));
        calFrom.setToolTipText(Messages.getString("IssueChartDialog.3"));
        calFrom.setBackground(this.color);
        calFrom.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OpenCalendarDlgAction action = new OpenCalendarDlgAction(IssueChartDialog.this.frmDateTxt);
                action.run();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText(Messages.getString("IssueChartDialog.4"));
        label.setBackground(this.color);
        this.toDateTxt = new Text((Composite)group, 2048);
        this.toDateTxt.setLayoutData((Object)dateGridData);
        ImageHyperlink calTo = new ImageHyperlink((Composite)group, 0);
        calTo.setImage(BtsPlugin.getInstance().getImage("calendar.gif"));
        calTo.setBackground(Display.getDefault().getSystemColor(22));
        calTo.setToolTipText(Messages.getString("IssueChartDialog.5"));
        calTo.setBackground(this.color);
        calTo.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OpenCalendarDlgAction action = new OpenCalendarDlgAction(IssueChartDialog.this.toDateTxt);
                action.run();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("(YYYY/MM/DD)");
        label.setBackground(this.color);
        GridData labelGridData = new GridData();
        labelGridData.horizontalSpan = 2;
        label.setLayoutData((Object)labelGridData);
        Table table = new Table((Composite)group, 68386);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(350, true));
        TableColumn tc = new TableColumn(table, 1, 0);
        tc.setText(Messages.getString("IssueChartDialog.6"));
        GridData tableGridData = new GridData();
        tableGridData.heightHint = 45;
        tableGridData.widthHint = 200;
        tableGridData.horizontalSpan = 8;
        this.categoryViewer = new CheckboxTableViewer(table);
        this.categoryViewer.getControl().setLayoutData((Object)tableGridData);
        this.categoryViewer.setContentProvider((IContentProvider)this.getCategoryTableContentProvider());
        this.categoryViewer.setLabelProvider((IBaseLabelProvider)this.getCategoryTableLabelProvider());
        CurrentProject project = CurrentProject.getInsance();
        if (project.isOpen()) {
            ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade();
            this.category = issueModifyFacade.getCategoryTypeR();
            this.categoryViewer.setInput((Object)this.category);
        }
        this.categoryViewer.setAllChecked(true);
        this.secretChk = new Button((Composite)group, 32);
        this.secretChk.setText(Messages.getString("IssueChartDialog.7"));
        this.secretChk.setBackground(this.color);
        this.secretChk.setSelection(false);
        GridData data = new GridData(768);
        data.horizontalSpan = 6;
        this.secretChk.setLayoutData((Object)data);
        this.reserveChk = new Button((Composite)group, 32);
        this.reserveChk.setText(Messages.getString("IssueChartDialog.8"));
        this.reserveChk.setBackground(this.color);
        this.reserveChk.setSelection(false);
        this.reserveChk.setLayoutData((Object)data);
        Button submitBtn = new Button((Composite)group, 0x800008);
        submitBtn.setText(Messages.getString("IssueChartDialog.9"));
        GridData submitGrid = new GridData(128);
        submitGrid.widthHint = 60;
        submitGrid.heightHint = 30;
        submitGrid.verticalSpan = 2;
        submitBtn.setLayoutData((Object)submitGrid);
        submitBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IssueChartDialog.this.submitPressed();
            }
        });
        Button closeBtn = new Button((Composite)group, 0x800008);
        closeBtn.setText(Messages.getString("IssueChartDialog.10"));
        GridData closeGrid = new GridData();
        closeGrid.widthHint = 60;
        closeGrid.heightHint = 30;
        closeGrid.verticalSpan = 2;
        closeBtn.setLayoutData((Object)closeGrid);
        closeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IssueChartDialog.this.close();
            }
        });
    }

    private void createNotes(Composite parent) {
        Label notesLabel = new Label(parent, 0);
        notesLabel.setLayoutData((Object)new GridData(128));
        notesLabel.setText(Messages.getString("IssueChartDialog.11"));
        notesLabel.setBackground(this.color);
        notesLabel.setForeground(new Color((Device)Display.getCurrent(), 49, 106, 197));
    }

    private IStructuredContentProvider getCategoryTableContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return IssueChartDialog.this.category;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private ILabelProvider getCategoryTableLabelProvider() {
        return new CategoryTableLabelProvider();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        IssueChartDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        return composite;
    }

    private void submitPressed() {
        String frmDateString = this.frmDateTxt.getText().trim();
        String toDateString = this.toDateTxt.getText().trim();
        if (!("".equals(frmDateString) && "".equals(toDateString) || BTSUtility.dateTextError(frmDateString, toDateString))) {
            return;
        }
        List renewList = this.renewChartIssueList(new ArrayList(this.chartIssueList));
        if (renewList.size() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("IssueChartDialog.12"), (String)Messages.getString("IssueChartDialog.13"));
            return;
        }
        IssueChartRender render = new IssueChartRender(renewList);
        render.createChart();
        Image image = new Image((Device)Display.getCurrent(), String.valueOf(this.currentDir) + "bug.png");
        this.chartLabel.setImage(image);
    }

    private List renewChartIssueList(List renewList) {
        int i = 0;
        while (i < this.chartIssueList.size()) {
            Issue issue = (Issue)this.chartIssueList.get(i);
            if (!"".equals(this.frmDateTxt.getText().trim()) && !"".equals(this.toDateTxt.getText().trim())) {
                Date frmDate = BTSUtility.createDate(this.frmDateTxt.getText().trim());
                Date toDate = new Date(BTSUtility.createDate(this.toDateTxt.getText().trim()).getTime() + 86400000L);
                if (issue.getCreateDate().before(frmDate) || issue.getCreateDate().after(toDate)) {
                    renewList.remove(issue);
                }
            } else if (!"".equals(this.frmDateTxt.getText().trim()) && "".equals(this.toDateTxt.getText().trim())) {
                Date frmDate = BTSUtility.createDate(this.frmDateTxt.getText().trim());
                if (issue.getCreateDate().before(frmDate)) {
                    renewList.remove(issue);
                }
            } else if ("".equals(this.frmDateTxt.getText().trim()) && !"".equals(this.toDateTxt.getText().trim())) {
                Date toDate = new Date(BTSUtility.createDate(this.toDateTxt.getText().trim()).getTime() + 86400000L);
                if (issue.getCreateDate().after(toDate)) {
                    renewList.remove(issue);
                }
            }
            int j = 0;
            while (j < this.category.length) {
                if (!this.categoryViewer.getChecked((Object)this.category[j]) && this.category[j].equals(issue.getCategory())) {
                    renewList.remove(issue);
                }
                ++j;
            }
            if (this.secretChk.getSelection() && issue.getSecretBug().booleanValue()) {
                renewList.remove(issue);
            }
            if (this.reserveChk.getSelection() && issue.getSuspend().booleanValue()) {
                renewList.remove(issue);
            }
            ++i;
        }
        return renewList;
    }

    private class CategoryTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private CategoryTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return element.toString();
            }
            return "";
        }
    }
}

