/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.navigator;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.OpenCalendarDlgAction;
import jp.valtech.bts.ui.navigator.IssueClassifiedExport;
import jp.valtech.bts.ui.navigator.Messages;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class IssueClassifiedExportDialog
extends Dialog
implements Logging {
    Text headerTxt;
    Text footerTxt;
    Button issueListRdi;
    Button cntAssignedRdi;
    Button cntStatusRdi;
    Button totalBugRdi;
    Button unitDayRdi;
    Button unitWeekRdi;
    Button unitMonthRdi;
    Button fileHTMRdi;
    private Button filePDFRdi;
    Button fileXMLRdi;
    private Button fileCSVRdi;
    private Text frmDateTxt;
    private Text toDateTxt;
    private CheckboxTableViewer categoryViewer;
    private Button secretChk;
    private Button reserveChk;
    private String[] category;

    public IssueClassifiedExportDialog(Shell parentShell) {
        super(parentShell);
    }

    public IssueClassifiedExportDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("IssueClassifiedExportDialog.0"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.createFileFormatArea(composite);
            this.createOutputChooseArea(composite);
            this.createOutputConditionArea(composite);
            this.createHeaderArea(composite);
            this.createSeparatorLine(composite);
        }
        catch (Exception e) {
            String msg = Messages.getString("IssueClassifiedExportDialog.29");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
        return composite;
    }

    private void createFileFormatArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        thisArea.setLayoutData((Object)new GridData(768));
        Group group = new Group(thisArea, 0);
        group.setText(Messages.getString("IssueClassifiedExportDialog.1"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.fileHTMRdi = new Button((Composite)group, 16);
        this.fileHTMRdi.setText("HTML");
        this.fileXMLRdi = new Button((Composite)group, 16);
        this.fileXMLRdi.setText("XML");
        this.filePDFRdi = new Button((Composite)group, 16);
        this.filePDFRdi.setText("PDF");
        this.filePDFRdi.setEnabled(false);
        this.fileCSVRdi = new Button((Composite)group, 16);
        this.fileCSVRdi.setText("CSV");
        this.fileCSVRdi.setEnabled(false);
    }

    private void createOutputChooseArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        thisArea.setLayoutData((Object)new GridData(768));
        Group group = new Group(thisArea, 0);
        group.setText(Messages.getString("IssueClassifiedExportDialog.2"));
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.issueListRdi = new Button((Composite)group, 16);
        this.issueListRdi.setText(Messages.getString("IssueClassifiedExportDialog.3"));
        this.issueListRdi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (IssueClassifiedExportDialog.this.issueListRdi.getSelection() || IssueClassifiedExportDialog.this.cntAssignedRdi.getSelection() || IssueClassifiedExportDialog.this.cntStatusRdi.getSelection() || IssueClassifiedExportDialog.this.totalBugRdi.getSelection()) {
                    IssueClassifiedExportDialog.this.getButton(0).setEnabled(true);
                } else {
                    IssueClassifiedExportDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        this.cntAssignedRdi = new Button((Composite)group, 16);
        this.cntAssignedRdi.setText(Messages.getString("IssueClassifiedExportDialog.4"));
        this.cntAssignedRdi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (IssueClassifiedExportDialog.this.issueListRdi.getSelection() || IssueClassifiedExportDialog.this.cntAssignedRdi.getSelection() || IssueClassifiedExportDialog.this.cntStatusRdi.getSelection() || IssueClassifiedExportDialog.this.totalBugRdi.getSelection()) {
                    IssueClassifiedExportDialog.this.getButton(0).setEnabled(true);
                } else {
                    IssueClassifiedExportDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        this.cntStatusRdi = new Button((Composite)group, 16);
        this.cntStatusRdi.setText(Messages.getString("IssueClassifiedExportDialog.5"));
        this.cntStatusRdi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (IssueClassifiedExportDialog.this.issueListRdi.getSelection() || IssueClassifiedExportDialog.this.cntAssignedRdi.getSelection() || IssueClassifiedExportDialog.this.cntStatusRdi.getSelection() || IssueClassifiedExportDialog.this.totalBugRdi.getSelection()) {
                    IssueClassifiedExportDialog.this.getButton(0).setEnabled(true);
                } else {
                    IssueClassifiedExportDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        this.totalBugRdi = new Button((Composite)group, 16);
        this.totalBugRdi.setText(Messages.getString("IssueClassifiedExportDialog.6"));
        this.totalBugRdi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (IssueClassifiedExportDialog.this.issueListRdi.getSelection() || IssueClassifiedExportDialog.this.cntAssignedRdi.getSelection() || IssueClassifiedExportDialog.this.cntStatusRdi.getSelection() || IssueClassifiedExportDialog.this.totalBugRdi.getSelection()) {
                    IssueClassifiedExportDialog.this.getButton(0).setEnabled(true);
                } else {
                    IssueClassifiedExportDialog.this.getButton(0).setEnabled(false);
                }
                if (IssueClassifiedExportDialog.this.totalBugRdi.getSelection()) {
                    IssueClassifiedExportDialog.this.unitDayRdi.setEnabled(true);
                    IssueClassifiedExportDialog.this.unitWeekRdi.setEnabled(true);
                    IssueClassifiedExportDialog.this.unitMonthRdi.setEnabled(true);
                } else {
                    IssueClassifiedExportDialog.this.unitDayRdi.setEnabled(false);
                    IssueClassifiedExportDialog.this.unitWeekRdi.setEnabled(false);
                    IssueClassifiedExportDialog.this.unitMonthRdi.setEnabled(false);
                }
            }
        });
        Composite unit = new Composite((Composite)group, 0);
        unit.setLayout((Layout)new GridLayout());
        unit.setLayoutData((Object)new GridData(768));
        GridData indent = new GridData(1808);
        indent.horizontalIndent = 15;
        this.unitDayRdi = new Button(unit, 16);
        this.unitDayRdi.setLayoutData((Object)indent);
        this.unitDayRdi.setText(Messages.getString("IssueClassifiedExportDialog.7"));
        this.unitDayRdi.setSelection(true);
        this.unitDayRdi.setEnabled(false);
        this.unitWeekRdi = new Button(unit, 16);
        this.unitWeekRdi.setLayoutData((Object)indent);
        this.unitWeekRdi.setText(Messages.getString("IssueClassifiedExportDialog.8"));
        this.unitWeekRdi.setEnabled(false);
        this.unitMonthRdi = new Button(unit, 16);
        this.unitMonthRdi.setLayoutData((Object)indent);
        this.unitMonthRdi.setText(Messages.getString("IssueClassifiedExportDialog.9"));
        this.unitMonthRdi.setEnabled(false);
    }

    private void createOutputConditionArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        thisArea.setLayoutData((Object)new GridData(768));
        Group group = new Group(thisArea, 0);
        group.setText(Messages.getString("IssueClassifiedExportDialog.10"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 7;
        layout.verticalSpacing = 10;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.getString("IssueClassifiedExportDialog.11"));
        this.frmDateTxt = new Text((Composite)group, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 80;
        this.frmDateTxt.setLayoutData((Object)gridData);
        ImageHyperlink calFrom = new ImageHyperlink((Composite)group, 0);
        calFrom.setImage(BtsPlugin.getInstance().getImage("calendar.gif"));
        calFrom.setBackground(Display.getDefault().getSystemColor(22));
        calFrom.setToolTipText(Messages.getString("IssueClassifiedExportDialog.12"));
        calFrom.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OpenCalendarDlgAction action = new OpenCalendarDlgAction(IssueClassifiedExportDialog.this.frmDateTxt);
                action.run();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText(Messages.getString("IssueClassifiedExportDialog.13"));
        this.toDateTxt = new Text((Composite)group, 2048);
        this.toDateTxt.setLayoutData((Object)gridData);
        ImageHyperlink calTo = new ImageHyperlink((Composite)group, 0);
        calTo.setImage(BtsPlugin.getInstance().getImage("calendar.gif"));
        calTo.setBackground(Display.getDefault().getSystemColor(22));
        calTo.setToolTipText(Messages.getString("IssueClassifiedExportDialog.14"));
        calTo.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OpenCalendarDlgAction action = new OpenCalendarDlgAction(IssueClassifiedExportDialog.this.toDateTxt);
                action.run();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("(YYYY/MM/DD)");
        Table table = new Table((Composite)group, 68386);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(350, true));
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setText(Messages.getString("IssueClassifiedExportDialog.15"));
        GridData tableGridData = new GridData(768);
        tableGridData.heightHint = 45;
        tableGridData.widthHint = 180;
        tableGridData.horizontalSpan = 7;
        this.categoryViewer = new CheckboxTableViewer(table);
        this.categoryViewer.getControl().setLayoutData((Object)tableGridData);
        this.categoryViewer.setContentProvider((IContentProvider)this.getCategoryTableContentProvider());
        this.categoryViewer.setLabelProvider((IBaseLabelProvider)this.getCategoryTableLabelProvider());
        CurrentProject project = CurrentProject.getInsance();
        if (project.isOpen()) {
            ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade();
            this.category = issueModifyFacade.getCategoryTypeR();
            this.categoryViewer.setInput((Object)this.category);
        }
        this.categoryViewer.setAllChecked(true);
        this.secretChk = new Button((Composite)group, 32);
        this.secretChk.setText(Messages.getString("IssueClassifiedExportDialog.16"));
        this.secretChk.setSelection(false);
        GridData data = new GridData(768);
        data.horizontalSpan = 7;
        this.secretChk.setLayoutData((Object)data);
        this.reserveChk = new Button((Composite)group, 32);
        this.reserveChk.setText(Messages.getString("IssueClassifiedExportDialog.17"));
        this.reserveChk.setSelection(false);
        this.reserveChk.setLayoutData((Object)data);
    }

    private IStructuredContentProvider getCategoryTableContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return IssueClassifiedExportDialog.this.category;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private ILabelProvider getCategoryTableLabelProvider() {
        return new CategoryTableLabelProvider();
    }

    private void createHeaderArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        GridData gridData = new GridData(4);
        gridData.widthHint = 220;
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("IssueClassifiedExportDialog.18"));
        this.headerTxt = new Text(thisArea, 2048);
        this.headerTxt.setLayoutData((Object)new GridData(768));
        this.headerTxt.setLayoutData((Object)gridData);
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("IssueClassifiedExportDialog.19"));
        this.footerTxt = new Text(thisArea, 2048);
        this.footerTxt.setLayoutData((Object)new GridData(768));
        this.footerTxt.setLayoutData((Object)gridData);
    }

    private void createSeparatorLine(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        separator.setLayoutData((Object)gd);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.getString("IssueClassifiedExportDialog.20"), true);
        this.getButton(0).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        String[] filterNames;
        String[] extensions;
        String extension;
        List issueList = null;
        String frmDateString = this.frmDateTxt.getText().trim();
        String toDateString = this.toDateTxt.getText().trim();
        if (!("".equals(frmDateString) && "".equals(toDateString) || BTSUtility.dateTextError(frmDateString, toDateString))) {
            return;
        }
        issueList = this.addCondition();
        if (issueList == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("IssueClassifiedExportDialog.21"), (String)Messages.getString("IssueClassifiedExportDialog.22"));
            return;
        }
        if (issueList.size() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("IssueClassifiedExportDialog.23"), (String)Messages.getString("IssueClassifiedExportDialog.24"));
            return;
        }
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        if (this.fileHTMRdi.getSelection()) {
            extension = ".html";
            extensions = new String[]{"*.html", "*.*"};
            fileDialog.setFilterExtensions(extensions);
            filterNames = new String[]{Messages.getString("IssueClassifiedExportDialog.25"), Messages.getString("IssueClassifiedExportDialog.26")};
            fileDialog.setFilterNames(filterNames);
        } else {
            extension = ".xml";
            extensions = new String[]{"*.xml", "*.*"};
            fileDialog.setFilterExtensions(extensions);
            filterNames = new String[]{Messages.getString("IssueClassifiedExportDialog.27"), Messages.getString("IssueClassifiedExportDialog.28")};
            fileDialog.setFilterNames(filterNames);
        }
        if (this.issueListRdi.getSelection()) {
            fileDialog.setFileName("issue" + extension);
        } else if (this.cntAssignedRdi.getSelection()) {
            fileDialog.setFileName("assign" + extension);
        } else if (this.cntStatusRdi.getSelection()) {
            fileDialog.setFileName("status" + extension);
        } else {
            fileDialog.setFileName("bug" + extension);
        }
        String fileName = fileDialog.open();
        String filterPath = fileDialog.getFilterPath();
        if (fileName == null) {
            return;
        }
        IssueClassifiedExport issueExport = new IssueClassifiedExport(this, issueList, fileName, filterPath);
        issueExport.exportRun();
        super.okPressed();
    }

    private List addCondition() {
        List allList = null;
        ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade();
        try {
            allList = issueModifyFacade.getByType("R");
        }
        catch (BtsDBException btsDBException) {
            return null;
        }
        ArrayList newList = new ArrayList(allList);
        int i = 0;
        while (i < allList.size()) {
            Issue issue = (Issue)allList.get(i);
            if (!"".equals(this.frmDateTxt.getText().trim()) && !"".equals(this.toDateTxt.getText().trim())) {
                Date frmDate = BTSUtility.createDate(this.frmDateTxt.getText().trim());
                Date toDate = new Date(BTSUtility.createDate(this.toDateTxt.getText().trim()).getTime() + 86400000L);
                if (issue.getCreateDate().before(frmDate) || issue.getCreateDate().after(toDate)) {
                    newList.remove(issue);
                }
            } else if (!"".equals(this.frmDateTxt.getText().trim()) && "".equals(this.toDateTxt.getText().trim())) {
                Date frmDate = BTSUtility.createDate(this.frmDateTxt.getText().trim());
                if (issue.getCreateDate().before(frmDate)) {
                    newList.remove(issue);
                }
            } else if ("".equals(this.frmDateTxt.getText().trim()) && !"".equals(this.toDateTxt.getText().trim())) {
                Date toDate = new Date(BTSUtility.createDate(this.toDateTxt.getText().trim()).getTime() + 86400000L);
                if (issue.getCreateDate().after(toDate)) {
                    newList.remove(issue);
                }
            }
            int j = 0;
            while (j < this.category.length) {
                if (!this.categoryViewer.getChecked((Object)this.category[j]) && this.category[j].equals(issue.getCategory())) {
                    newList.remove(issue);
                }
                ++j;
            }
            if (this.secretChk.getSelection() && issue.getSecretBug().booleanValue()) {
                newList.remove(issue);
            }
            if (this.reserveChk.getSelection() && issue.getSuspend().booleanValue()) {
                newList.remove(issue);
            }
            ++i;
        }
        return newList;
    }

    private class CategoryTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private CategoryTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return element.toString();
            }
            return "";
        }
    }
}

