/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.navigator;

import java.util.List;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.CloseProjectAction;
import jp.valtech.bts.ui.action.DeleteProjectAction;
import jp.valtech.bts.ui.action.ImportIssueAction;
import jp.valtech.bts.ui.action.OpenChartDlgAction;
import jp.valtech.bts.ui.action.OpenClassifiedExportDlgAction;
import jp.valtech.bts.ui.action.OpenIssueAction;
import jp.valtech.bts.ui.action.OpenMessageDlgAction;
import jp.valtech.bts.ui.action.OpenProjectAction;
import jp.valtech.bts.ui.action.OpenProjectConfigDlgAction;
import jp.valtech.bts.ui.action.RefreshAction;
import jp.valtech.bts.ui.action.SyncRemoteAction;
import jp.valtech.bts.ui.action.SyncSelectionRemoteAction;
import jp.valtech.bts.ui.issuelist.IssueListView;
import jp.valtech.bts.ui.issuelist.IssueListViewFilter;
import jp.valtech.bts.ui.navigator.BtsTreeNode;
import jp.valtech.bts.ui.navigator.CategoryNode;
import jp.valtech.bts.ui.navigator.ConflictNode;
import jp.valtech.bts.ui.navigator.DraftNode;
import jp.valtech.bts.ui.navigator.GarbageBoxNode;
import jp.valtech.bts.ui.navigator.IChildCountNode;
import jp.valtech.bts.ui.navigator.IFolderNode;
import jp.valtech.bts.ui.navigator.MemberListNode;
import jp.valtech.bts.ui.navigator.MemberNode;
import jp.valtech.bts.ui.navigator.Messages;
import jp.valtech.bts.ui.navigator.NavigatorViewContentProvider;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.ui.navigator.ProjectConfigManager;
import jp.valtech.bts.ui.navigator.ProjectNode;
import jp.valtech.bts.ui.navigator.ReleaseNode;
import jp.valtech.bts.ui.navigator.TreeBuilder;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class NavigatorView
extends ViewPart
implements Logging {
    private TreeViewer viewer = null;
    private OpenProjectAction openProjectAction;
    private OpenClassifiedExportDlgAction openClassifiedExportDlgAction;
    private OpenChartDlgAction openChartDialogAction;
    private OpenProjectConfigDlgAction registConfigDlgAction;
    private OpenProjectConfigDlgAction editConfigDlgAction;
    private RefreshAction refreshAction;
    private SyncRemoteAction syncRemoteAction;
    private SyncSelectionRemoteAction syncSelectionHostAction;
    private OpenIssueAction openNewIssueAction;
    private OpenIssueAction openCtgryIssueAction;
    private CloseProjectAction closeProjectAction;
    private DeleteProjectAction deleteProjectAction;
    private ImportIssueAction importIssueAction;
    private OpenMessageDlgAction openMessageDlgAction;

    public void createPartControl(Composite parent) {
        try {
            parent.setLayout((Layout)new FillLayout());
            this.viewer = new TreeViewer(parent, 0);
            NavigatorViewContentProvider provider = new NavigatorViewContentProvider();
            this.viewer.setContentProvider((IContentProvider)provider);
            this.viewer.setLabelProvider((IBaseLabelProvider)new FolderTreeLabelProvider());
            this.viewer.setInput((Object)this.createDefaultTree());
            CurrentProject project = CurrentProject.getInsance();
            if (project.isOpen()) {
                ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade();
                List issueList = issueModifyFacade.getIssueList();
                provider.refresh(issueList);
            }
            this.viewer.setSorter(new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    BtsTreeNode treeNode1 = (BtsTreeNode)e1;
                    BtsTreeNode treeNode2 = (BtsTreeNode)e2;
                    return treeNode1.compareTo(treeNode2);
                }
            });
            this.hookDoubleClick();
            this.hookSingleClick();
            this.makeActions();
            this.hookContextMenu();
            this.fillLocalToolBar();
        }
        catch (Exception e) {
            String msg = Messages.getString("NavigatorView.0");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    private void makeActions() {
        this.openClassifiedExportDlgAction = new OpenClassifiedExportDlgAction(this);
        this.openChartDialogAction = new OpenChartDlgAction(this);
        this.syncRemoteAction = new SyncRemoteAction();
        this.openNewIssueAction = new OpenIssueAction(0);
        this.syncSelectionHostAction = new SyncSelectionRemoteAction();
        this.refreshAction = new RefreshAction();
        this.openCtgryIssueAction = new OpenIssueAction(2);
        this.openProjectAction = new OpenProjectAction();
        this.closeProjectAction = new CloseProjectAction();
        this.deleteProjectAction = new DeleteProjectAction();
        this.registConfigDlgAction = new OpenProjectConfigDlgAction(this, 0);
        this.editConfigDlgAction = new OpenProjectConfigDlgAction(this, 1);
        this.importIssueAction = new ImportIssueAction(this);
        this.openMessageDlgAction = new OpenMessageDlgAction(this);
        CurrentProject project = CurrentProject.getInsance();
        project.addAction(this.openClassifiedExportDlgAction);
        project.addAction(this.openChartDialogAction);
        project.addAction(this.syncSelectionHostAction);
        project.addAction(this.syncRemoteAction);
        project.addAction(this.openNewIssueAction);
        if (project.isOpen()) {
            this.openClassifiedExportDlgAction.setEnabled(true);
            this.openChartDialogAction.setEnabled(true);
            this.syncSelectionHostAction.setEnabled(true);
            this.syncRemoteAction.setEnabled(true);
            this.openNewIssueAction.setEnabled(true);
        } else {
            this.openClassifiedExportDlgAction.setEnabled(false);
            this.openChartDialogAction.setEnabled(false);
            this.syncSelectionHostAction.setEnabled(false);
            this.syncRemoteAction.setEnabled(false);
            this.openNewIssueAction.setEnabled(false);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NavigatorView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDoubleClick() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Viewer view = event.getViewer();
                ISelection selection = event.getSelection();
                if (view instanceof TreeViewer && selection instanceof StructuredSelection) {
                    TreeViewer viewer = (TreeViewer)view;
                    Object element = ((StructuredSelection)selection).getFirstElement();
                    if (element instanceof IFolderNode) {
                        if (!viewer.getExpandedState(element)) {
                            viewer.expandToLevel(element, 1);
                        } else {
                            viewer.collapseToLevel(element, 1);
                        }
                    }
                }
            }
        });
    }

    private void hookSingleClick() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IssueListView view = BtsPlugin.getInstance().getIssueView();
                if (view == null) {
                    return;
                }
                IssueListViewFilter filter = new IssueListViewFilter(view);
                BtsTreeNode selectedNode = NavigatorView.this.getSelectionRecord();
                if (selectedNode != null) {
                    if (selectedNode instanceof CategoryNode) {
                        String categoryName = ((CategoryNode)selectedNode).getTextName();
                        filter.setCategoryFilter(categoryName);
                    } else if (selectedNode instanceof ReleaseNode) {
                        filter.setIssueTypeFilter("R");
                    } else if (selectedNode instanceof DraftNode) {
                        filter.setIssueTypeFilter("D");
                    } else if (selectedNode instanceof ConflictNode) {
                        filter.setIssueTypeFilter("C");
                    } else if (selectedNode instanceof GarbageBoxNode) {
                        filter.setIssueTypeFilter("G");
                    } else {
                        filter.setClearFilter();
                    }
                }
            }
        });
    }

    private BtsTreeNode getSelectionRecord() {
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof BtsTreeNode) {
            return (BtsTreeNode)obj;
        }
        return null;
    }

    private void fillContextMenu(IMenuManager manager) {
        CurrentProject current = CurrentProject.getInsance();
        BtsTreeNode selectedNode = this.getSelectionRecord();
        if (selectedNode == null) {
            manager.add((IAction)this.registConfigDlgAction);
        } else if (selectedNode instanceof ProjectNode) {
            String ssid = ((ProjectNode)selectedNode).getSSID();
            this.closeProjectAction.setSSID(ssid);
            this.deleteProjectAction.setSSID(ssid);
            this.editConfigDlgAction.setSSID(ssid);
            this.openProjectAction.setSSID(ssid);
            if (current.isCurrentProject(ssid)) {
                manager.add((IAction)this.closeProjectAction);
                manager.add((IAction)this.editConfigDlgAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.openNewIssueAction);
                manager.add((IAction)this.importIssueAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.syncRemoteAction);
                manager.add((IAction)this.syncSelectionHostAction);
            } else {
                manager.add((IAction)this.openProjectAction);
                manager.add((IAction)this.editConfigDlgAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.deleteProjectAction);
            }
        } else if (selectedNode instanceof ReleaseNode) {
            manager.add((IAction)this.openNewIssueAction);
        } else if (selectedNode instanceof CategoryNode) {
            String ctgry = ((CategoryNode)selectedNode).getTextName();
            this.openCtgryIssueAction.setCategory(ctgry);
            manager.add((IAction)this.openCtgryIssueAction);
        } else if (selectedNode instanceof MemberListNode) {
            this.openMessageDlgAction.setSendAll(true);
            this.openMessageDlgAction.setClientInfo(null);
            manager.add((IAction)this.openMessageDlgAction);
        } else if (selectedNode instanceof MemberNode) {
            ClientInfo info = ((MemberNode)selectedNode).getClientInfo();
            this.openMessageDlgAction.setSendAll(false);
            this.openMessageDlgAction.setClientInfo(info);
            manager.add((IAction)this.openMessageDlgAction);
        } else if (selectedNode instanceof DraftNode) {
            manager.add((IAction)this.openNewIssueAction);
        } else {
            boolean cfr_ignored_0 = selectedNode instanceof GarbageBoxNode;
        }
        if (!manager.isEmpty()) {
            manager.add((IContributionItem)new Separator());
        }
        if (selectedNode != null) {
            manager.add((IAction)this.refreshAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar() throws Exception {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = bars.getToolBarManager();
        toolbar.add((IAction)this.registConfigDlgAction);
        toolbar.add((IAction)this.openNewIssueAction);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.openClassifiedExportDlgAction);
        toolbar.add((IAction)this.openChartDialogAction);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.syncSelectionHostAction);
        toolbar.add((IAction)this.syncRemoteAction);
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    private BtsTreeNode createDefaultTree() {
        ProjectConfig[] prjct = ProjectConfigManager.getProjectConfigs();
        if (prjct == null) {
            return new BtsTreeNode();
        }
        TreeBuilder treeBuilder = new TreeBuilder();
        int i = 0;
        while (i < prjct.length) {
            treeBuilder.addProjectNode(prjct[i].getProjectName(), prjct[i].getSsid());
            ++i;
        }
        return treeBuilder.getRootNode();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        CurrentProject project = CurrentProject.getInsance();
        project.removeAction(this.openChartDialogAction);
        project.removeAction(this.syncRemoteAction);
        project.removeAction(this.syncSelectionHostAction);
        project.removeAction(this.openClassifiedExportDlgAction);
        project.removeAction(this.openNewIssueAction);
        super.dispose();
    }

    private class FolderTreeLabelProvider
    extends LabelProvider {
        private FolderTreeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IChildCountNode) {
                int cnt = ((IChildCountNode)element).getChildCount();
                return String.valueOf(((BtsTreeNode)element).getTextName()) + " (" + cnt + ")";
            }
            return ((BtsTreeNode)element).getTextName();
        }

        public Image getImage(Object element) {
            return ((BtsTreeNode)element).getImage();
        }
    }
}

