/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.navigator;

import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.navigator.IProjectDialogSettings;
import jp.valtech.bts.ui.navigator.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class ProjectConfigDialogValidate {
    private TitleAreaDialog dialog;

    public ProjectConfigDialogValidate(TitleAreaDialog dialog) {
        this.dialog = dialog;
    }

    public boolean validateProjectName(Text text) {
        if (text.getText().trim().length() == 0) {
            this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.0"));
            return false;
        }
        this.dialog.setErrorMessage(null);
        return true;
    }

    public boolean validateUserName(Text text) {
        if (text.getText().trim().length() == 0) {
            this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.1"));
            return false;
        }
        this.dialog.setErrorMessage(null);
        return true;
    }

    public boolean validateSsid(Text text) {
        IProjectDialogSettings setting = BtsPlugin.getInstance().getProjectDialogSettings();
        if (text.getText().trim().length() == 0) {
            this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.2"));
            return false;
        }
        if (setting != null) {
            IProjectDialogSettings[] sections = setting.getSections();
            int i = 0;
            while (i < sections.length) {
                if (text.getText().trim().equals(sections[i].get("SSID"))) {
                    this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.3"));
                    return false;
                }
                ++i;
            }
        }
        this.dialog.setErrorMessage(null);
        return true;
    }

    public boolean validatePriority(Text text) {
        if (text.getText().trim().length() == 0) {
            this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.4"));
            return false;
        }
        this.dialog.setErrorMessage(null);
        return true;
    }

    public boolean validateVote(Button check, Text text) {
        if (check.getSelection()) {
            if (text.getText().trim().length() == 0) {
                this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.5"));
                return false;
            }
            try {
                if (Integer.parseInt(text.getText().trim()) < 0) {
                    this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.6"));
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.7"));
                return false;
            }
            this.dialog.setErrorMessage(null);
            return true;
        }
        this.dialog.setErrorMessage(null);
        return true;
    }

    public boolean validateUntilDeadLine(Button check, Text text) {
        if (check.getSelection()) {
            if (text.getText().trim().length() == 0) {
                this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.8"));
                return false;
            }
            try {
                if (Integer.parseInt(text.getText().trim()) <= 0) {
                    this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.9"));
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.10"));
                return false;
            }
            this.dialog.setErrorMessage(null);
            return true;
        }
        this.dialog.setErrorMessage(null);
        return true;
    }

    public boolean validateSmtp(Button check, Text text) {
        if (!check.getSelection()) {
            this.dialog.setErrorMessage(null);
            return true;
        }
        if (text.getText().trim().length() == 0) {
            this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.11"));
            return false;
        }
        this.dialog.setErrorMessage(null);
        return true;
    }

    public boolean validateSender(Button check, Text text) {
        if (!check.getSelection()) {
            this.dialog.setErrorMessage(null);
            return true;
        }
        if (text.getText().trim().length() == 0) {
            this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.12"));
            return false;
        }
        this.dialog.setErrorMessage(null);
        return true;
    }

    public boolean validateRecipient(Button check, Text text) {
        if (!check.getSelection()) {
            this.dialog.setErrorMessage(null);
            return true;
        }
        if (text.getText().trim().length() == 0) {
            this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.13"));
            return false;
        }
        this.dialog.setErrorMessage(null);
        return true;
    }

    public boolean validateAddress(Button fixedSyncChk, Text text) {
        block4: {
            if (!fixedSyncChk.getSelection()) {
                this.dialog.setErrorMessage(null);
                return true;
            }
            try {
                if (Integer.parseInt(text.getText()) < 0) break block4;
                this.dialog.setErrorMessage(null);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.15"));
                return false;
            }
        }
        this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.15"));
        return false;
    }

    public boolean validatePort(Button fixedSyncChk, Text text) {
        block4: {
            if (!fixedSyncChk.getSelection()) {
                this.dialog.setErrorMessage(null);
                return true;
            }
            try {
                if (Integer.parseInt(text.getText()) < 0) break block4;
                this.dialog.setErrorMessage(null);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.16"));
                return false;
            }
        }
        this.dialog.setErrorMessage(Messages.getString("ProjectConfigDialogValidate.16"));
        return false;
    }
}

