/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.navigator;

import java.util.ArrayList;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.navigator.IProjectDialogSettings;
import jp.valtech.bts.ui.navigator.ProjectConfig;

public class ProjectConfigManager {
    private static IProjectDialogSettings setting = BtsPlugin.getInstance().getProjectDialogSettings();
    public static final String KEY_PROJECT = "PROJECT";
    public static final String KEY_USER = "USER";
    public static final String KEY_SSID = "SSID";
    public static final String KEY_MAILCHECK = "MAILCHECK";
    public static final String KEY_SMTP = "SMTP";
    public static final String KEY_SENDER = "SENDER";
    public static final String KEY_RECIPIENT = "RECIPIENT";
    public static final String KEY_PREFIX = "PREFIX";
    public static final String KEY_CATEGORY = "CATEGORY";
    public static final String KEY_PRIORITY = "PRIORITY";
    public static final String KEY_ASSIGNED = "ASSIGNED";
    public static final String KEY_VOTECHECK = "VOTECHECK";
    public static final String KEY_VOTE = "VOTE";
    public static final String KEY_UNTILDEADLINECHECK = "UNTILDEADLINECHECK";
    public static final String KEY_UNTILDEADLINE = "UNTILDEADLINE";
    public static final String KEY_FIXEDSYNCCHECK = "FIXEDSYNCCHECK";
    public static final String KEY_ADDRESS1 = "ADDRESS1";
    public static final String KEY_ADDRESS2 = "ADDRESS2";
    public static final String KEY_ADDRESS3 = "ADDRESS3";
    public static final String KEY_ADDRESS4 = "ADDRESS4";
    public static final String KEY_PORT = "PORT";
    public static final String KEY_AUTOSYNCCHECK = "AUTOSYNCCHECK";
    public static final String KEY_NORMALSYNCRADIO = "NORMALSYNCRADIO";
    public static final String KEY_APPOINTSYNCRADIO = "APPOINTSYNCRADIO";

    public static void save(ProjectConfig config) {
        IProjectDialogSettings section = setting.addNewSection(config.getSsid());
        ProjectConfigManager.setProjectConfig(section, config);
        setting.addSection(section);
    }

    public static void modify(ProjectConfig oldConfig, ProjectConfig newConfig) {
        IProjectDialogSettings section = setting.getSection(newConfig.getSsid());
        ProjectConfigManager.setProjectConfig(section, newConfig);
    }

    private static void setProjectConfig(IProjectDialogSettings section, ProjectConfig config) {
        section.put(KEY_PROJECT, config.getProjectName());
        section.put(KEY_USER, config.getUserName());
        section.put(KEY_SSID, config.getSsid());
        section.put(KEY_MAILCHECK, config.isMailCheck());
        section.put(KEY_SMTP, config.getSmtp());
        section.put(KEY_SENDER, config.getSender());
        section.put(KEY_RECIPIENT, config.getRecipient());
        section.put(KEY_PREFIX, config.getPrefix());
        section.put(KEY_CATEGORY, config.getCategory());
        section.put(KEY_PRIORITY, config.getPriority());
        section.put(KEY_ASSIGNED, config.getAssigned());
        section.put(KEY_VOTECHECK, config.isVoteCheck());
        section.put(KEY_VOTE, config.getVote());
        section.put(KEY_UNTILDEADLINECHECK, config.isUntilDeadLineCheck());
        section.put(KEY_UNTILDEADLINE, config.getUntilDeadLine());
        section.put(KEY_FIXEDSYNCCHECK, config.isFixedSyncCheck());
        section.put(KEY_ADDRESS1, config.getAddress1());
        section.put(KEY_ADDRESS2, config.getAddress2());
        section.put(KEY_ADDRESS3, config.getAddress3());
        section.put(KEY_ADDRESS4, config.getAddress4());
        section.put(KEY_PORT, config.getPort());
        section.put(KEY_AUTOSYNCCHECK, config.isAutoSyncCheck());
        section.put(KEY_NORMALSYNCRADIO, config.isNormalSyncRadio());
        section.put(KEY_APPOINTSYNCRADIO, config.isAppointSyncRadio());
    }

    public static ProjectConfig getProjectConfig(String ssid) {
        ProjectConfig[] configs = ProjectConfigManager.getProjectConfigs();
        int i = 0;
        while (i < configs.length) {
            ProjectConfig config = configs[i];
            if (config.getSsid().equals(ssid)) {
                return config;
            }
            ++i;
        }
        return null;
    }

    public static ProjectConfig[] getProjectConfigs() {
        IProjectDialogSettings[] sections = setting.getSections();
        ArrayList<ProjectConfig> list = new ArrayList<ProjectConfig>(sections.length);
        int i = 0;
        while (i < sections.length) {
            IProjectDialogSettings settings = sections[i];
            ProjectConfig config = new ProjectConfig();
            config.setProjectName(settings.get(KEY_PROJECT));
            config.setUserName(settings.get(KEY_USER));
            config.setSsid(settings.get(KEY_SSID));
            config.setMailCheck(settings.getBoolean(KEY_MAILCHECK));
            config.setSmtp(settings.get(KEY_SMTP));
            config.setSender(settings.get(KEY_SENDER));
            config.setRecipient(settings.get(KEY_RECIPIENT));
            config.setPrefix(settings.get(KEY_PREFIX));
            config.setCategory(settings.get(KEY_CATEGORY));
            config.setPriority(settings.get(KEY_PRIORITY));
            config.setAssigned(settings.get(KEY_ASSIGNED));
            config.setVoteCheck(settings.getBoolean(KEY_VOTECHECK));
            config.setVote(settings.get(KEY_VOTE));
            config.setUntilDeadLineCheck(settings.getBoolean(KEY_UNTILDEADLINECHECK));
            config.setUntilDeadLine(settings.get(KEY_UNTILDEADLINE));
            config.setFixedSyncCheck(settings.getBoolean(KEY_FIXEDSYNCCHECK));
            config.setAddress1(settings.get(KEY_ADDRESS1));
            config.setAddress2(settings.get(KEY_ADDRESS2));
            config.setAddress3(settings.get(KEY_ADDRESS3));
            config.setAddress4(settings.get(KEY_ADDRESS4));
            config.setPort(settings.get(KEY_PORT));
            config.setAutoSyncCheck(settings.getBoolean(KEY_AUTOSYNCCHECK));
            config.setNormalSyncRadio(settings.getBoolean(KEY_NORMALSYNCRADIO));
            config.setAppointSyncRadio(settings.getBoolean(KEY_APPOINTSYNCRADIO));
            list.add(config);
            ++i;
        }
        return list.toArray(new ProjectConfig[0]);
    }

    public static void remove(String ssid) {
        setting.removeSection(ssid);
    }
}

