/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.preference;

import jp.valtech.bts.ui.BtsPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class BtsPreference {
    private static BtsPreference instance;
    private IPreferenceStore preference = BtsPlugin.getInstance().getPreferenceStore();

    public static synchronized BtsPreference getInstance() {
        if (instance == null) {
            instance = new BtsPreference();
        }
        return instance;
    }

    private BtsPreference() {
    }

    public int getMulticastPort() {
        String port = this.preference.getString("MultiPort");
        if (port == null || port.trim().equals("")) {
            return 4342;
        }
        return Integer.parseInt(port);
    }

    public String getMulticastAddress() {
        String address4;
        String address3;
        String address2;
        String address1 = this.preference.getString("Address1");
        if (address1 == null || address1.trim().equals("")) {
            address1 = String.valueOf(224);
        }
        if ((address2 = this.preference.getString("Address2")) == null || address2.trim().equals("")) {
            address2 = String.valueOf(0);
        }
        if ((address3 = this.preference.getString("Address3")) == null || address3.trim().equals("")) {
            address3 = String.valueOf(0);
        }
        if ((address4 = this.preference.getString("Address4")) == null || address4.trim().equals("")) {
            address4 = String.valueOf(1);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(address1);
        buf.append(".");
        buf.append(address2);
        buf.append(".");
        buf.append(address3);
        buf.append(".");
        buf.append(address4);
        return buf.toString();
    }

    public int getTCPPort() {
        String port = this.preference.getString("TcpPort");
        if (port == null || port.trim().equals("")) {
            return 4344;
        }
        return Integer.parseInt(port);
    }

    public int getSendTimeout() {
        String timeout = this.preference.getString("Send_Timeout");
        if (timeout == null || timeout.trim().equals("")) {
            return 10000;
        }
        int msec = Integer.parseInt(timeout);
        return msec * 1000;
    }

    public int getSyncTimeout() {
        String timeout = this.preference.getString("Sync_Timeout");
        if (timeout == null || timeout.trim().equals("")) {
            return 25000;
        }
        int msec = Integer.parseInt(timeout);
        return msec * 1000;
    }
}

