/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jp.valtech.bts.data.Attachment;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.util.CipherUtility;
import jp.valtech.bts.util.IOUtility;
import jp.valtech.bts.util.Logging;

public class AttachmentUtility
implements Logging {
    private String registBaseDir = CurrentProject.getInsance().getBaseDir();

    public Attachment[] writeWorkspaceFromLocal(Attachment[] attachments) throws IOException {
        if (attachments == null || attachments.length == 0) {
            return null;
        }
        ArrayList<Attachment> addNewList = new ArrayList<Attachment>();
        int i = 0;
        while (i < attachments.length) {
            Attachment res;
            if (!attachments[i].isRegisted() && (res = this.writeWorkspaceFromLocal(attachments[i])) != null) {
                addNewList.add(res);
            }
            ++i;
        }
        return addNewList.toArray(new Attachment[0]);
    }

    public Attachment writeWorkspaceFromLocal(Attachment attachment) throws IOException {
        if (attachment.isRegisted()) {
            return null;
        }
        byte[] data = IOUtility.read(attachment.getRealPath());
        byte[] compress = IOUtility.compress(data);
        String fileName = CipherUtility.hash(String.valueOf(attachment.getRealPath()) + System.currentTimeMillis());
        File filePath = new File(String.valueOf(this.registBaseDir) + fileName);
        IOUtility.write(filePath, compress);
        attachment.setRealPath(fileName);
        attachment.setRegisted(true);
        return attachment;
    }

    public void writeLocalFromLocal(Attachment attachment, String writePath) throws IOException {
        byte[] data = IOUtility.read(attachment.getRealPath());
        File file = new File(writePath);
        IOUtility.write(file, data);
    }

    public void writeLocalFromWorkspace(Attachment attachment, String writePath) throws IOException {
        byte[] data = IOUtility.read(String.valueOf(this.registBaseDir) + attachment.getRealPath());
        byte[] decompress = IOUtility.decompress(data);
        File file = new File(writePath);
        IOUtility.write(file, decompress);
    }

    public void writeWorkspaceFromEntity(Attachment[] attachments) throws IOException {
        if (attachments == null) {
            return;
        }
        int i = 0;
        while (i < attachments.length) {
            byte[] data = attachments[i].getAttachmentFile();
            File filePath = new File(String.valueOf(this.registBaseDir) + attachments[i].getRealPath());
            IOUtility.write(filePath, data);
            ++i;
        }
    }

    public Attachment[] clone(Attachment[] attachments) throws IOException {
        if (attachments == null || attachments.length == 0) {
            return null;
        }
        ArrayList<Attachment> cloneList = new ArrayList<Attachment>();
        int i = 0;
        while (i < attachments.length) {
            Attachment res;
            if (attachments[i].isRegisted() && (res = this.clone(attachments[i])) != null) {
                cloneList.add(res);
            }
            ++i;
        }
        return cloneList.toArray(new Attachment[0]);
    }

    public Attachment clone(Attachment attachment) throws IOException {
        if (!attachment.isRegisted()) {
            return null;
        }
        byte[] data = IOUtility.read(String.valueOf(this.registBaseDir) + attachment.getRealPath());
        String fileName = CipherUtility.hash(String.valueOf(attachment.getRealPath()) + System.currentTimeMillis());
        File filePath = new File(String.valueOf(this.registBaseDir) + fileName);
        IOUtility.write(filePath, data);
        attachment.setRealPath(fileName);
        return attachment;
    }

    public void delete(Attachment[] attachments) throws IOException {
        if (attachments == null) {
            return;
        }
        int i = 0;
        while (i < attachments.length) {
            File filePath = new File(String.valueOf(this.registBaseDir) + attachments[i].getRealPath());
            filePath.delete();
            ++i;
        }
    }

    public void read(Attachment[] attachments) throws IOException {
        if (attachments == null) {
            return;
        }
        int i = 0;
        while (i < attachments.length) {
            if (attachments[i].isRegisted()) {
                byte[] data = IOUtility.read(String.valueOf(this.registBaseDir) + attachments[i].getRealPath());
                attachments[i].setAttachmentFile(data);
            }
            ++i;
        }
    }

    public void read(ArrayList attachmentList) throws IOException {
        if (attachmentList == null || attachmentList.isEmpty()) {
            return;
        }
        Iterator it = attachmentList.iterator();
        while (it.hasNext()) {
            Attachment attachment = (Attachment)it.next();
            if (!attachment.isRegisted()) continue;
            byte[] data = IOUtility.read(String.valueOf(this.registBaseDir) + attachment.getRealPath());
            attachment.setAttachmentFile(data);
        }
    }

    public void writeWorkspaceFromLocal(MessagePacket message) throws IOException {
        byte[] attach = message.getAttachFile();
        if (attach == null) {
            return;
        }
        byte[] compress = IOUtility.compress(attach);
        message.setAttachFile(compress);
        File filePath = new File(String.valueOf(this.registBaseDir) + message.getRealpath());
        IOUtility.write(filePath, compress);
    }

    public void writeWorkspaceFromEntity(MessagePacket message) throws IOException {
        byte[] data = message.getAttachFile();
        if (data != null) {
            File filePath = new File(String.valueOf(this.registBaseDir) + message.getRealpath());
            IOUtility.write(filePath, data);
        }
    }

    public void writeLocalFromWorkspace(MessagePacket message, String writePath) throws IOException {
        byte[] data = IOUtility.read(String.valueOf(this.registBaseDir) + message.getRealpath());
        byte[] decompress = IOUtility.decompress(data);
        File file = new File(writePath);
        IOUtility.write(file, decompress);
    }

    public void delete(MessagePacket message) throws IOException {
        if (message == null) {
            return;
        }
        File filePath = new File(String.valueOf(this.registBaseDir) + message.getRealpath());
        filePath.delete();
    }
}

