/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueAttribute;
import jp.valtech.bts.data.IssueHistory;
import jp.valtech.bts.data.IssueStatus;
import jp.valtech.bts.facade.IssueHistoryFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.Messages;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public class IssueChartRender {
    private List chartIssueList;
    private Timestamp minTimestamp;
    private Timestamp maxTimestamp;
    private int[] updateOpenTotal;
    private int[] updateCloseTotal;
    static /* synthetic */ Class class$0;

    public IssueChartRender(List chartIssueList) {
        this.chartIssueList = chartIssueList;
    }

    public void createChart() {
        this.countBug();
        this.createImage();
    }

    /*
     * Unable to fully structure code
     */
    private void countBug() {
        this.minTimestamp = new Timestamp(9999999999999L);
        this.maxTimestamp = new Timestamp(0L);
        bugChartList = this.getIssueHistoryForChart();
        calendarMin = Calendar.getInstance();
        calendarMin.setTimeInMillis(this.minTimestamp.getTime());
        calendarMax = Calendar.getInstance();
        calendarMax.setTimeInMillis(this.maxTimestamp.getTime());
        minYear = calendarMin.get(1);
        maxYear = calendarMax.get(1);
        minDay = calendarMin.get(6);
        maxDay = calendarMax.get(6);
        argsNumMax = (maxYear - minYear) * 365 + maxDay - minDay + 1;
        this.updateOpenTotal = new int[argsNumMax];
        this.updateCloseTotal = new int[argsNumMax];
        calendar = Calendar.getInstance();
        if (bugChartList == null || bugChartList.isEmpty()) {
            return;
        }
        bugCharts = bugChartList.toArray(new IssueHistory[0]);
        i = 0;
        while (i < bugCharts.length) {
            block4: {
                updateDateLong = bugCharts[i].getUpdateDateTimestamp();
                calendar.setTimeInMillis(updateDateLong);
                updateYear = calendar.get(1);
                argsNum = (updateYear - minYear) * 365 + calendar.get(6) - minDay;
                if (!IssueHistory.ISSUE_INITIAL_REGIST.equals(bugCharts[i].getUpdateAttribute())) ** GOTO lbl33
                while (argsNum < this.updateOpenTotal.length) {
                    v0 = argsNum++;
                    this.updateOpenTotal[v0] = this.updateOpenTotal[v0] + 1;
                }
                break block4;
lbl-1000:
                // 1 sources

                {
                    v1 = argsNum++;
                    this.updateCloseTotal[v1] = this.updateCloseTotal[v1] + 1;
lbl33:
                    // 2 sources

                    ** while (argsNum < this.updateOpenTotal.length)
                }
            }
            ++i;
        }
    }

    private void createImage() {
        String string = Messages.getString("IssueChartRender.6");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries openTimeSeries = new TimeSeries(string, (Class)clazz);
        String string2 = Messages.getString("IssueChartRender.7");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries closeTimeSeries = new TimeSeries(string2, (Class)clazz2);
        String string3 = Messages.getString("IssueChartRender.8");
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries remainderTimeSeries = new TimeSeries(string3, (Class)clazz3);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.minTimestamp.getTime());
        int i = 0;
        while (i < this.updateOpenTotal.length) {
            Day day = new Day(calendar.get(5), calendar.get(2) + 1, calendar.get(1));
            calendar.add(5, 1);
            openTimeSeries.add((RegularTimePeriod)day, (double)this.updateOpenTotal[i]);
            closeTimeSeries.add((RegularTimePeriod)day, (double)this.updateCloseTotal[i]);
            remainderTimeSeries.add((RegularTimePeriod)day, (double)(this.updateOpenTotal[i] - this.updateCloseTotal[i]));
            ++i;
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(openTimeSeries);
        dataset.addSeries(closeTimeSeries);
        dataset.addSeries(remainderTimeSeries);
        JFreeChart chart = ChartFactory.createTimeSeriesChart(null, null, (String)Messages.getString("IssueChartRender.9"), (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255));
        String projectName = CurrentProject.getInsance().getProjectConfig().getProjectName();
        String nowDate = BTSUtility.formatDate(new Date());
        TextTitle projectNameTitle = new TextTitle(String.valueOf(Messages.getString("IssueChartRender.10")) + projectName);
        projectNameTitle.setFont(new Font("SansSerif", 2, 11));
        projectNameTitle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        chart.setTitle(projectNameTitle);
        TextTitle textTitle = new TextTitle(Messages.getString("IssueChartRender.11"));
        textTitle.setFont(new Font("SansSerif", 1, 16));
        textTitle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        chart.addSubtitle((Title)textTitle);
        TextTitle nowDateTitle = new TextTitle(String.valueOf(Messages.getString("IssueChartRender.12")) + nowDate);
        nowDateTitle.setFont(new Font("SansSerif", 2, 11));
        nowDateTitle.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        chart.addSubtitle((Title)nowDateTitle);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        xyplot.setDomainGridlinesVisible(false);
        DateAxis dateaxis = (DateAxis)xyplot.getDomainAxis();
        TickUnits tickUnits = new TickUnits();
        tickUnits.add((TickUnit)new DateTickUnit(2, 1, (DateFormat)new SimpleDateFormat("M/d")));
        tickUnits.add((TickUnit)new DateTickUnit(2, 7, (DateFormat)new SimpleDateFormat("M/d")));
        tickUnits.add((TickUnit)new DateTickUnit(1, 1, (DateFormat)new SimpleDateFormat("yyyy/M")));
        tickUnits.add((TickUnit)new DateTickUnit(1, 3, (DateFormat)new SimpleDateFormat("yyyy/M")));
        tickUnits.add((TickUnit)new DateTickUnit(1, 6, (DateFormat)new SimpleDateFormat("yyyy/M")));
        dateaxis.setStandardTickUnits((TickUnitSource)tickUnits);
        dateaxis.setAutoTickUnitSelection(true);
        NumberAxis axis = (NumberAxis)xyplot.getRangeAxis();
        axis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LegendTitle legendtitle = (LegendTitle)chart.getSubtitle(0);
        legendtitle.setPosition(RectangleEdge.RIGHT);
        String currentDir = BtsPlugin.getInstance().getStateLocation() + "/";
        File outputFile = new File(String.valueOf(currentDir) + "bug.png");
        try {
            ChartUtilities.saveChartAsPNG((File)outputFile, (JFreeChart)chart, (int)600, (int)300);
        }
        catch (IOException e) {
            BtsPlugin.getInstance().errorlog(e);
        }
    }

    private List getIssueHistoryForChart() {
        IssueHistoryFacade facade = new IssueHistoryFacade();
        ArrayList<IssueHistory> issueHistorys = new ArrayList<IssueHistory>();
        String targetAttribute = IssueAttribute.STATUS.getDescription();
        int i = 0;
        while (i < this.chartIssueList.size()) {
            Issue issue = (Issue)this.chartIssueList.get(i);
            IssueHistory[] filterIssueHistories = facade.getByFingerPrint(issue.getFingerPrint(), issue.getType());
            int j = 0;
            while (j < filterIssueHistories.length) {
                String updateAttribute = filterIssueHistories[j].getUpdateAttribute();
                String updateAfter = filterIssueHistories[j].getUpdateAfter();
                if (IssueHistory.ISSUE_INITIAL_REGIST.equals(updateAttribute) || targetAttribute.equals(updateAttribute) && IssueStatus.CLOSED.getDescription().equals(updateAfter)) {
                    issueHistorys.add(filterIssueHistories[j]);
                    Timestamp updateDateTimestamp = new Timestamp(filterIssueHistories[j].getUpdateDateTimestamp());
                    if (this.minTimestamp.compareTo(updateDateTimestamp) > 0) {
                        this.minTimestamp = updateDateTimestamp;
                    }
                    if (this.maxTimestamp.compareTo(updateDateTimestamp) < 0) {
                        this.maxTimestamp = updateDateTimestamp;
                    }
                }
                ++j;
            }
            ++i;
        }
        facade.close();
        return issueHistorys;
    }
}

