/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.connection;

import java.io.File;

import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.BTSUtility;


/**
 * 同期処理時の課題票取得処理のコネクションクラスです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class IssueSyncDBConnection extends DBConnection {

	/** 処理種別の識別文字列 */
	private static final String PROCESS_TYPE = "_issue_sync";
	
	/**
	 * コネクションを生成します。
	 */
	public IssueSyncDBConnection() {
		super(null, PROCESS_TYPE + System.currentTimeMillis());
	}
	
	
	/*
	 *  (非 Javadoc)
	 * @see jp.valtech.bts.connection.DBConnection#buildConnection(java.lang.String)
	 */
	protected void buildConnection() throws BtsDBException {
		
		try {
			// IssueDBConnectionのDBファイル
			String inFile = CurrentProject.getInsance().getBaseDir() + IssueDBConnection.PROCESS_TYPE;
			
			// 同期処理用にDBファイルを生成する。IssueDBConnectionのDBファイルをコピーする。
			BTSUtility.copy(inFile + DB_FILE_PROPERTIES, dbFilepath + DB_FILE_PROPERTIES);
			BTSUtility.copy(inFile + DB_FILE_SCRIPT, dbFilepath + DB_FILE_SCRIPT);

			super.buildConnection();
		} catch (Exception e) {
			BtsPlugin.getInstance().errorlog(e);
		}
	}


	/*
	 *  (非 Javadoc)
	 * @see jp.valtech.bts.connection.DBConnection#close()
	 */
	public void close(){
		// コネクションをクローズ
		super.close();
		
		// クローズしたらDBファイルを削除する
		File dbfile = new File(dbFilepath + DB_FILE_PROPERTIES);
		dbfile.delete();

		dbfile = new File(dbFilepath + DB_FILE_SCRIPT);
		dbfile.delete();
	}

}
