/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

/**
 * 
 * メッセージ種別を定義したEnumクラスです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public final class MessageType {
	
	/** 説明 */
	private String description;
	/** 値 */
	private String value;
	
	/** メッセージ種別： ユーザ送受信メッセージ*/
	public static final String USER_VALUE 		= "U";
	/** メッセージ種別： 課題票送受信メッセージ*/
	public static final String ISSUE_VALUE		= "I";
	/** メッセージ種別： 競合通知メッセージ*/
	public static final String CONFLICT_VALUE 	= "C"; 
	/** メッセージ種別： 同期結果メッセージ*/
	public static final String SYNC_VALUE 		= "S";

	
	/** メッセージ種別： ユーザ送受信メッセージ*/
	public static final MessageType USER 	= new MessageType(USER_VALUE,	  Messages.getString("MessageType.0")); //$NON-NLS-1$
	/** メッセージ種別： 課題票送受信メッセージ*/
	public static final MessageType ISSUE 	= new MessageType(ISSUE_VALUE,	  Messages.getString("MessageType.1")); //$NON-NLS-1$
	/** メッセージ種別： 競合通知メッセージ*/
	public static final MessageType CONFLICT= new MessageType(CONFLICT_VALUE, Messages.getString("MessageType.2")); //$NON-NLS-1$
	/** メッセージ種別： 同期結果メッセージ*/
	public static final MessageType SYNC 	= new MessageType(SYNC_VALUE,	  Messages.getString("MessageType.3")); //$NON-NLS-1$

	
	/**
	 * 外部からは呼ばれません。
	 * 
	 * @param		value			値
	 * @param		description		説明
	 */
	private MessageType(String value, String description) {
		this.value = value;
		this.description = description;
	}
	
	
	/**
	 * MessageTypeクラスで持つMessageTypeインスタンスの配列を取得します。
	 * 
	 * @return		MessageTypeクラスで持つMessageTypeインスタンスの配列
	 */
	public static MessageType[] getEnums() {
		
		// IssueTypeクラスに持つ定数インスタンスの配列を生成して返す
		return new MessageType[]{ MessageType.USER
							     , MessageType.ISSUE
							     , MessageType.CONFLICT
							     , MessageType.SYNC
							     } ;
	}
	

	/**
	 * 指定された値を持つMessageTypeインスタンスを返します。
	 * 
	 * @param		value			値
	 * @return		MessageTypeインスタンス
	 */
	public static MessageType getEnumByValue(String value) {
		if(value ==null) {
			throw new IllegalArgumentException("Invalid MessageType-value : null");
		}

		// MessageTypeの配列を取得
		MessageType[] msgType = MessageType.getEnums();
		for (int idx = 0; idx < msgType.length; idx++) {
			
			// 引数の値と同一のMessageTypeがある場合はそれを返す
			if( value.equals(msgType[idx].getValue()) ){ 
				return msgType[idx];
			}
		}
		
		// 引数の値と同一のMessageTypeがなかった場合は例外を投げる
		throw new IllegalArgumentException("Invalid MessageType-value : " + value);
	}


	/**
	 * 指定された説明を持つMessageTypeインスタンスを返します。
	 * 
	 * @param		description			説明
	 * @return		MessageTypeインスタンス
	 */
	public static MessageType getEnumByDescription(String description) {
		if(description ==null) {
			throw new IllegalArgumentException("Invalid MessageType-value : null");
		}

		// MessageTypeの配列を取得
		MessageType[] issueType = MessageType.getEnums();
		for (int idx = 0; idx < issueType.length; idx++) {
			
			// 引数の値と同一のMessageTypeがある場合はそれを返す
			if( description.equals(issueType[idx].getDescription()) ){ 
				return issueType[idx];
			}
		}
		
		// 引数の値と同一のMessageTypeがなかった場合は例外を投げる
		throw new IllegalArgumentException("Invalid MessageType-value : " + description);
	}

	/**
	 * 説明を返します。
	 * 
	 * @return		説明
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * 値を返します。
	 * 
	 * @return		値
	 */
	public String getValue() {
		return value;
	}
}
