/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

import java.io.Serializable;


/**
 * <dl><dt><b>投票</b></dt>
 * 	<dd></dd>
 * </dl>
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class Vote implements Serializable {
	
	/** シリアルID  */
	private static final long serialVersionUID = 4979333782255953111L;

	/** 指紋 : 課題票を一意に識別するためのSHA-1フィンガープリント */
	protected String fingerPrint = null;

	/** 投票者 :  */
	protected String voteUser = null;

	/** 投票数 :  */
	protected int voteCnt = 1;


	/**
	 * 何もしない
	 *
	 */
	public Vote() {
		;
	}

	/**
	 * <DL>
	 * <DT><B>指紋を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return 指紋
	 */
	public String getFingerPrint() {
		return this.fingerPrint;
	}

	/**
	 * <DL>
	 * <DT><B>指紋を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param fingerPrint 指紋
	 */
	public void setFingerPrint( String fingerPrint ) {
		this.fingerPrint = fingerPrint;
	}
	/**
	 * <DL>
	 * <DT><B>投票者 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return 投票者 
	 */
	public String getVoteUser() {
		return this.voteUser;
	}

	/**
	 * <DL>
	 * <DT><B>投票者を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param voteUser 投票者
	 */
	public void setVoteUser( String voteUser ) {
		this.voteUser = voteUser;
	}
	/**
	 * <DL>
	 * <DT><B>投票数 を戻します。</B></B>
	 * <DD>投票数をIntegerのプリミティブ型intで取得します。</DD>
	 * </DL>
	 * @return 投票数 
	 */
	public int getVoteCnt() {
		return this.voteCnt;
	}

	/**
	 * <DL>
	 * <DT><B>投票数を設定します。</B></DT>
	 * <DD>投票数をIntegerのプリミティブ型intで設定します。</DD>
	 * </DL>
	 * @param voteCnt 投票数
	 */
	public void setVoteCnt( int voteCnt ) {
		this.voteCnt = voteCnt;
	}


}