/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import java.util.List;

import jp.valtech.bts.data.Issue;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;

/**
 * 課題票を削除するアクションです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class DeleteIssueAction extends Action {

	/** 削除対象の題票 */
	private Issue issue;

	/**
	 * アクションを生成します。
	 */
	public DeleteIssueAction() {
		super();
		setText(Messages.getString("DeleteIssueAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("DeleteIssueAction.1"));  //$NON-NLS-1$
		setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("delete.gif"));
	}
	
	
	/**
	 * 課題票を削除します。
	 */
	public void run() {
		
		// 削除確認のダイアログ
		boolean res = MessageDialog.openQuestion
					( BtsPlugin.getInstance().getShell()
					, Messages.getString("DeleteIssueAction.2") //$NON-NLS-1$
					, Messages.getString("DeleteIssueAction.3")); //$NON-NLS-1$

		// 「いいえ」選択時
		if(!res) {
			return;
		}
		
		// DBから対象の課題票を削除(添付がある場合はファイルシステムからも削除)	
		ModifyIssueFacade facade = new ModifyIssueFacade();
		facade.deleteByFingerPrint(issue.getFingerPrint(), issue.getType());
		
		// 削除対象の課題票のエディタが開いていた場合は閉じます。
		BtsPlugin.getInstance().closeIssueEditor(issue.getFingerPrint(), issue.getType());

		// ビューを更新します。
		List listeners = BtsPlugin.getInstance().getListeners();
		for (int idx = 0; idx < listeners.size(); idx++) {
			IBtsListener listnener = (IBtsListener)listeners.get(idx);
			listnener.deleteIssue(issue);
		}

	}


	/**
	 * 削除対象の課題票を設定します。
	 * 
	 * @param		issue			課題票
	 */
	public void setIssue(Issue issue) {
		this.issue = issue;
	}
}
