/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.msglist;

import jp.valtech.bts.ui.BtsPlugin;

import org.eclipse.jface.dialogs.IDialogSettings;

/**
 * XMLにメッセージフィルタ情報を登録します。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class MessageFilterManager {

	/** ダイアログセッティング生成 */
	private static IDialogSettings setting = BtsPlugin.getInstance().getDialogSettings();
	
	/** メッセージフィルターセクション名 */
	public static final String SECTION_NAME = "MessageFilter";
	
	/** システムメッセージチェック */
	public static final String KEY_SYSTEM = "SYSTEM";
	
	/** ユーザメッセージチェック */
	public static final String KEY_USER = "USER";
	
	/** メッセージコンボ */
	public static final String KEY_MESSAGECOMBO = "MESSAGECOMBO";
	
	/** メッセージ */
	public static final String KEY_MESSAGE = "MESSAGE";
	
	/** From送信日 */
	public static final String KEY_FROM = "FROM";
	
	/** To送信日 */
	public static final String KEY_TO = "TO";
	
	/** チェックが付いていない送信者 */
	public static final String KEY_SENDER = "SENDER";
	
	
	
	/**
	 * メッセージフィルタ情報を保存します。
	 * @param		config		メッセージフィルタ情報
	 */
	public static void save(MessageFilter config){
		// 新しいセクション作成
		IDialogSettings section = setting.addNewSection(SECTION_NAME);
		// セクションにメッセージフィルタ情報をセット
		setMessageFilter(section, config);
		// XMLにセクションを登録
		setting.addSection(section);
	}
	
	/**
	 * メッセージフィルタ情報を更新します。
	 * @param		oldConfig		旧メッセージフィルタ情報
	 * @param		newConfig		新しいメッセージフィルタ情報
	 */
	public static void modify(MessageFilter oldConfig, MessageFilter newConfig) {
		// 更新するメッセージフィルタ情報のセクション取得
		IDialogSettings section = setting.getSection(SECTION_NAME);
		// 新しいメッセージフィルタ情報を上書き更新
		setMessageFilter(section, newConfig);
	}
	
	
	/**
	 * セクションにメッセージフィルタ情報を登録します。
	 */
	public static void setMessageFilter(IDialogSettings section, MessageFilter config) {
		// セクションに登録
		section.put(KEY_SYSTEM, config.isMsgSystemChk());
		section.put(KEY_USER, config.isMsgUserChk());
		section.put(KEY_MESSAGECOMBO, config.getMessageCmb());
		section.put(KEY_MESSAGE, config.getMessage());
		section.put(KEY_FROM, config.getFrmDate());
		section.put(KEY_TO, config.getToDate());
		section.put(KEY_SENDER, config.getSenderChk());
		
	}



	/**
	 * MessageFilterに登録済みフィルタ情報をセットします。
	 * @return
	 */
	public static MessageFilter getMessageFilter() {
		// セクション取得
		IDialogSettings section = setting.getSection(SECTION_NAME);
		
		// XMLのフィルタ情報をMessageFilterに登録
		MessageFilter config = new MessageFilter();
		config.setMsgSystemChk(section.getBoolean(KEY_SYSTEM));
		config.setMsgUserChk(section.getBoolean(KEY_USER));
		config.setMessageCmb(section.get(KEY_MESSAGECOMBO));
		config.setMessage(section.get(KEY_MESSAGE));
		config.setFrmDate(section.get(KEY_FROM));
		config.setToDate(section.get(KEY_TO));
		config.setSenderChk(section.get(KEY_SENDER));
		
		return config;
		
	}
	
	
}
