/*
 * Decompiled with CFR 0.152.
 */
package permutation;

import permutation.Permutation;
import permutation.Q;
import permutation.Table;

public class G {
    public static void main(String[] args) {
        String[] caseSequence = new String[]{"ATAATTTAC", "ACGGCCGGT", "GTAATTTAT"};
        String[] controlSequence = new String[]{"ATAATTTAT", "GTAATTTAC", "ATAATTTAT"};
        int a = caseSequence.length;
        int b = controlSequence.length;
        int n = a + b;
        String[] sequence = new String[n];
        int[] type = new int[n];
        int[] observedOrder = new int[n];
        int h = 0;
        while (h < n) {
            if (h >= 0 && h < a) {
                sequence[h] = caseSequence[h];
                type[h] = 1;
            }
            if (a <= h && h < n) {
                sequence[h] = controlSequence[h - a];
                type[h] = 0;
            }
            observedOrder[h] = h;
            ++h;
        }
        double Qsum = G.sumQ(sequence, type, 3.0);
        double g = G.g(sequence, type, 3.0);
        System.out.println(g);
    }

    public static double g(String[] sequence, int[] di, double Sobs) {
        return (double)Q.Qvalue(sequence, di, Sobs) / G.sumQ(sequence, di, Sobs);
    }

    public static double sumQ(String[] sequence, int[] di, double Sobs) {
        double result = 0.0;
        int sequenceLength = sequence[0].length();
        int n = sequence.length;
        int c1 = 0;
        while (c1 < sequenceLength) {
            char org = sequence[0].charAt(c1);
            int[] genotype = new int[n];
            int i = 0;
            while (i < n) {
                genotype[i] = sequence[i].charAt(c1) == org ? 0 : 1;
                int[][] T = Permutation.T(di, genotype);
                Table table = new Table(T);
                result += G.numberOfDiInHj(table, Sobs);
                ++i;
            }
            ++c1;
        }
        return result;
    }

    public static double numberOfDiInHj(Table table, double Sobs) {
        double result = 0.0;
        int l = table.l();
        int u = table.u();
        int a1 = l;
        while (a1 <= u) {
            int[][] T = table.newTable(a1);
            if (Table.inCj(Sobs, T)) {
                result += table.mu(T);
            }
            ++a1;
        }
        return result;
    }
}

