/*
 * Decompiled with CFR 0.152.
 */
package permutation;

import permutation.Table;

public class MCMC {
    public static void main(String[] args) {
        double gen = 10000.0;
        int a1 = 66;
        int a2 = 50;
        int b1 = 90;
        int b2 = 50;
        Table T = new Table(a1, a2, b1, b2);
        double Score = Table.PearsonScore(T.table());
        T.newTable(75);
        int m = 0;
        while ((double)m < gen) {
            MCMC.markov2(T, Score);
            System.out.print(T.table[0][0]);
            System.out.print("\t");
            System.out.println(Table.PearsonScore(T.table()));
            ++m;
        }
    }

    public static void markov1(Table T, double Score) {
        int[][] X = T.table();
        int u = T.u();
        int l = T.l();
        int a1 = X[0][0];
        int i = MCMC.plusMinusOne();
        if ((a1 += i) < l || a1 > u) {
            return;
        }
        int[][] newX = T.newCandidate(a1);
        int a2 = newX[0][1];
        int b1 = newX[1][0];
        int b2 = newX[1][1];
        if (Table.inCj(Score, newX)) {
            double y = 0.0;
            if (i == 1) {
                y = (double)(b1 * a2) / ((double)(a1 + 1) * (double)(b2 + 1));
            }
            if (i == -1) {
                y = (double)(a1 * b2) / ((double)(b1 + 1) * (double)(a2 + 1));
            }
            if (y >= 1.0) {
                T.newTable(a1);
            } else {
                double y2 = Math.random();
                if (y >= y2) {
                    T.newTable(a1);
                }
            }
        }
    }

    public static void markov2(Table T, double Score) {
        int[][] X = T.table();
        int a1 = X[0][0];
        int i = MCMC.plusMinusOne();
        int[][] newX = T.newCandidate(a1 += i);
        int a2 = newX[0][1];
        int b1 = newX[1][0];
        int b2 = newX[1][1];
        int flag = Table.Cj(Score, newX);
        if (flag == Table.withinRange) {
            double y = 0.0;
            if (i == 1) {
                y = (double)(b1 * a2) / ((double)(a1 + 1) * (double)(b2 + 1));
            }
            if (i == -1) {
                y = (double)(a1 * b2) / ((double)(b1 + 1) * (double)(a2 + 1));
            }
            if (y >= 1.0) {
                T.newTable(a1);
            } else {
                double y2 = Math.random();
                if (y >= y2) {
                    T.newTable(a1);
                }
            }
        }
        if (flag == Table.inBetween) {
            int oldA1;
            int newA1 = oldA1 = T.table[0][0];
            double z = 0.0;
            if (i == 1) {
                newA1 = T.w(Score);
                z = T.r(T.newCandidate(oldA1), T.newCandidate(newA1));
            }
            if (i == -1) {
                newA1 = T.v(Score);
                z = T.r(T.newCandidate(oldA1), T.newCandidate(newA1));
            }
            if (z > 1.0) {
                T.newTable(newA1);
            } else {
                double z2 = Math.random();
                if (z >= z2) {
                    T.newTable(newA1);
                }
            }
        }
    }

    static int plusMinusOne() {
        int result = (int)(Math.random() * 2.0) * 2 - 1;
        return result;
    }
}

