/*
 * Decompiled with CFR 0.152.
 */
package permutation3;

import io.fileload;
import java.io.FileNotFoundException;
import java.io.IOException;
import permutation3.Table;
import primitive.Factorial;
import primitive.SnpData;
import primitive.Snp_DataReader;
import primitive.pearson;
import primitive.primitive;

public class RAT {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        int gen = 1000;
        int burnin = 1000;
        String[] data1 = fileload.loadLine0(args[0]);
        SnpData[] snpData1 = new SnpData[data1.length];
        int j = 0;
        while (j < data1.length) {
            snpData1[j] = Snp_DataReader.DataReaderSetData(data1[j], 2);
            ++j;
        }
        String[] data2 = fileload.loadLine0(args[1]);
        SnpData[] snpData2 = new SnpData[data2.length];
        int j2 = 0;
        while (j2 < data2.length) {
            snpData2[j2] = Snp_DataReader.DataReaderSetData(data2[j2], 2);
            ++j2;
        }
        SnpData[][] data = Snp_DataReader.DataReaderMakeParallelData(snpData1, snpData2);
        int a = data[0][0].SNPdata.length;
        int b = data[1][0].SNPdata.length;
        double Sobs = 0.0;
        int top = 0;
        int n = a + b;
        int m = data[0].length;
        int[][][] Tj = new int[m][][];
        double[] Sj = new double[m];
        int[][] genotype = new int[m][m];
        int j3 = 0;
        while (j3 < m) {
            int[] populationType = Snp_DataReader.populationType(data[0][j3], data[1][j3]);
            Tj[j3] = Snp_DataReader.DataReaderMakeTable(data[0][j3], data[1][j3], populationType);
            Sj[j3] = pearson.S(Tj[j3]);
            genotype[j3] = RAT.genotype(data[0][j3], data[1][j3]);
            if (Sj[j3] != Double.NaN && Sj[j3] > Sobs) {
                Sobs = Sj[j3];
                top = j3;
            }
            ++j3;
        }
        System.out.print("Observed:");
        System.out.print(data[0][top].rsNumber);
        System.out.print("\t");
        System.out.print(Sobs);
        System.out.println();
        if (Sobs < 3.84) {
            System.out.println("P>0.05");
        } else {
            System.out.print(RAT.ratMain(data, Sobs, burnin, gen));
        }
        System.out.println();
    }

    public static int algorithmA(double[] numberOfDiInHj) {
        int m = numberOfDiInHj.length;
        double sumOfNumberOfHj = 0.0;
        int j = 0;
        while (j < m) {
            sumOfNumberOfHj += numberOfDiInHj[j];
            ++j;
        }
        double p = sumOfNumberOfHj * Math.random();
        int j2 = 0;
        while (j2 < m) {
            if (p < numberOfDiInHj[j2]) {
                return j2;
            }
            p -= numberOfDiInHj[j2];
            ++j2;
        }
        return 0;
    }

    public static void algorithmB(Table T, double Score) {
        if (T.twoParts(Score)) {
            Table.markov2(T, Score);
        } else {
            Table.markov1(T, Score);
        }
    }

    public static int[] algorithmC(int[] genotype, Table T) {
        int[] di = RAT.conditionedDi(genotype, T.table());
        return di;
    }

    public static int Qvalue(int[][] genotype, int[] di, double Sobs) {
        int result = 0;
        int m = genotype.length;
        int j = 0;
        while (j < m) {
            int[][] T = RAT.T(di, genotype[j]);
            double S = Table.PearsonScore(T);
            if (S >= Sobs) {
                ++result;
            }
            ++j;
        }
        return result;
    }

    public static double numberOfDiInHj(Table table, double Sobs) {
        double result = 0.0;
        int l = table.l();
        int u = table.u();
        int a1 = l;
        while (a1 <= u) {
            int[][] T = table.newTable(a1);
            if (Table.inCj(Sobs, T)) {
                result += table.mu(T);
            }
            ++a1;
        }
        return result;
    }

    public static int[] conditionedDi(int[] genotype, int[][] T) {
        int a1 = T[0][0];
        int a2 = T[0][1];
        int a = a1 + a2;
        int b1 = T[1][0];
        int b2 = T[1][1];
        int b = b1 + b2;
        int n1 = a1 + b1;
        int n2 = a2 + b2;
        int n = n1 + n2;
        int[][] num = new int[][]{new int[n1], new int[n2]};
        int[] count = new int[2];
        int h = 0;
        while (h < n) {
            int gen = genotype[h];
            num[gen][count[gen]] = h++;
            int n3 = gen;
            count[n3] = count[n3] + 1;
        }
        int[][] shuffle = new int[2][];
        int[] tmp = new int[]{n1, n2};
        int gen = 0;
        while (gen < 2) {
            shuffle[gen] = primitive.omega(tmp[gen]);
            ++gen;
        }
        int[] type = new int[n];
        int gen2 = 0;
        while (gen2 < 2) {
            int h2 = 0;
            while (h2 < tmp[gen2]) {
                int tag = shuffle[gen2][h2];
                type[tag] = h2 < T[0][gen2] ? 0 : 1;
                ++h2;
            }
            ++gen2;
        }
        return type;
    }

    public static int[][] T(int[] d, int[] genotype) {
        int[][] result = new int[2][2];
        int len = d.length;
        int h = 0;
        while (h < len) {
            int[] nArray = result[d[h]];
            int n = genotype[h];
            nArray[n] = nArray[n] + 1;
            ++h;
        }
        return result;
    }

    public static int[] genotype(SnpData snpData1, SnpData snpData2) {
        char reference = Snp_DataReader.maximumNuc(snpData1);
        int[] genotype1 = Snp_DataReader.genotype(snpData1, reference);
        int[] genotype2 = Snp_DataReader.genotype(snpData2, reference);
        int a = genotype1.length;
        int b = genotype2.length;
        int n = a + b;
        int[] result = new int[n];
        int h = 0;
        while (h < a) {
            result[h] = genotype1[h];
            ++h;
        }
        h = 0;
        while (h < b) {
            result[h + a] = genotype2[h];
            ++h;
        }
        return result;
    }

    public static double ratMain(SnpData[][] data, double Sobs, int generation, int burnin) {
        Table T;
        int j;
        int a = data[0][0].SNPdata.length;
        int b = data[1][0].SNPdata.length;
        int top = 0;
        int n = a + b;
        int m = data[0].length;
        int[][][] Tj = new int[m][][];
        double[] Sj = new double[m];
        int[][] genotype = new int[m][m];
        int j2 = 0;
        while (j2 < m) {
            int[] populationType = Snp_DataReader.populationType(data[0][j2], data[1][j2]);
            Tj[j2] = Snp_DataReader.DataReaderMakeTable(data[0][j2], data[1][j2], populationType);
            Sj[j2] = pearson.S(Tj[j2]);
            genotype[j2] = RAT.genotype(data[0][j2], data[1][j2]);
            if (Sj[j2] != Double.NaN && Sj[j2] > Sobs) {
                Sobs = Sj[j2];
                top = j2;
            }
            ++j2;
        }
        int gen2 = 0;
        if (Sobs < 3.84) {
            return Double.NaN;
        }
        double sumOfQj = 0.0;
        double[] numberOfDiInHj = new double[m];
        int j3 = 0;
        while (j3 < m) {
            Table T2 = new Table(Tj[j3]);
            numberOfDiInHj[j3] = RAT.numberOfDiInHj(T2, Sobs);
            sumOfQj += numberOfDiInHj[j3];
            ++j3;
        }
        double sumOfinvQj = 0.0;
        int i = 0;
        while (i < burnin) {
            j = 0;
            while (j < m) {
                T = new Table(Tj[j]);
                RAT.algorithmB(T, Sobs);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < generation) {
            j = RAT.algorithmA(numberOfDiInHj);
            T = new Table(Tj[j]);
            RAT.algorithmB(T, Sobs);
            int[] di = RAT.algorithmC(genotype[j], T);
            double Qvalue = RAT.Qvalue(genotype, di, Sobs);
            if (Qvalue != 0.0) {
                sumOfinvQj += 1.0 / Qvalue;
                ++gen2;
            }
            ++i;
        }
        Factorial f = new Factorial(n);
        double logF = f.logCombination(n, a);
        return Math.exp(Math.log(sumOfQj) + Math.log(sumOfinvQj) - Math.log(gen2) - logF);
    }
}

