/*
 * Decompiled with CFR 0.152.
 */
package probability;

import probability.Bunkai;
import probability.Factorial;

public class CopyOfTest {
    public static double threshold = 6.635;

    public static void main(String[] args) {
        double[] test;
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[3] = 2;
        int[] min = nArray;
        int[] max = new int[]{2, 2, 2, 2};
        System.out.println("Start");
        int limit = 5;
        int L = min.length;
        int samplesize = limit;
        double[] h = test = new double[]{0.3, 0.3, 0.2, 0.2};
        int[][] X = new int[2][L];
        Factorial f = new Factorial(samplesize * 2);
        Bunkai b = new Bunkai(min, max, limit);
        while (!b.done()) {
            int[] result = b.bunkai();
            Bunkai a = new Bunkai(min, max, limit);
            while (!a.done()) {
                int[] result2 = a.bunkai();
                X[0] = result;
                X[1] = result2;
                if (CopyOfTest.significant2(samplesize, X, h) != 1) {
                    CopyOfTest.multinomialP2(limit, X, h, f);
                }
                a.count();
            }
            System.out.println();
            b.count();
        }
    }

    public static double multinomialP2(int size, int[][] X, double[] h, Factorial fact) {
        int n = X[0].length;
        int i = 0;
        while (i < n) {
            System.out.printf(":%d\t", X[0][i]);
            System.out.printf(":%d\t", X[1][i]);
            ++i;
        }
        System.out.println();
        double logCaseP = CopyOfTest.logMultinomialP(size, X[0], h, fact);
        double logControlP = CopyOfTest.logMultinomialP(size, X[1], h, fact);
        return Math.exp(logControlP + logCaseP);
    }

    public static double logMultinomialP(int size, int[] X, double[] h, Factorial fact) {
        int L = X.length;
        double logResult = fact.logFactrial(size);
        int i = 0;
        while (i < L) {
            logResult -= fact.logFactrial(X[i]);
            logResult += Math.log(h[i]) * (double)X[i];
            ++i;
        }
        return logResult;
    }

    public static int significant2(int sampleSize, int[][] data, double[] frequency) {
        if (CopyOfTest.significant(sampleSize, data[0], frequency) == 1) {
            return 1;
        }
        if (CopyOfTest.significant(sampleSize, data[1], frequency) == 1) {
            return 1;
        }
        int result = 0;
        return result;
    }

    public static int significant(int sampleSize, int[] obs, double[] frequency) {
        int result = 0;
        int i = 0;
        while (i < obs.length) {
            if (CopyOfTest.significant(sampleSize, obs[i], frequency[i]) == 1) {
                result = 1;
            }
            ++i;
        }
        return result;
    }

    public static int significant(int sampleSize, int obs, double frequency) {
        double exp = (double)sampleSize * frequency;
        double chi2 = ((double)obs - exp) * ((double)obs - exp) / exp;
        if (chi2 > threshold) {
            return 1;
        }
        return 0;
    }
}

