/*
 * Decompiled with CFR 0.152.
 */
package probability;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class HapMapLoad {
    LineNumberReader infile;
    boolean EOF = false;
    String[] data;
    String[] header;
    int size;

    public HapMapLoad(String filename) throws FileNotFoundException, IOException {
        try {
            this.infile = new LineNumberReader(new FileReader(filename));
            this.header = this.read();
            this.size = this.header.length - 11;
        }
        catch (Exception e) {
            this.EOF = true;
        }
    }

    public String[] read() {
        String str = "";
        try {
            str = this.infile.readLine();
        }
        catch (EOFException e) {
            try {
                this.infile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.EOF = true;
        }
        catch (NullPointerException e) {
            str = "";
        }
        catch (IOException e) {
            str = "";
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer ST = new StringTokenizer(str);
        while (ST.hasMoreTokens()) {
            v.addElement(ST.nextToken());
        }
        int len = v.size();
        this.data = new String[len];
        int i = 0;
        while (i < len) {
            this.data[i] = (String)v.elementAt(i);
            ++i;
        }
        return this.data;
    }

    public boolean eof() {
        return this.EOF;
    }

    public int NF() {
        return this.data.length;
    }

    public String word(int i) {
        return this.doller(i);
    }

    public String doller(int i) {
        return this.data[i];
    }

    public int currentPosition() {
        int result = -1;
        try {
            result = Integer.parseInt(this.data[3]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public int size() {
        return this.size;
    }

    public String currentSNPnubmer() {
        return this.data[0];
    }

    public String currentGenotype(int h) {
        if (h >= 0 && h < this.size) {
            return this.data[h + 11];
        }
        return "";
    }

    public char nuc1() {
        return this.data[1].charAt(0);
    }

    public int[] count() {
        int[] result = new int[5];
        int h = 0;
        while (h < this.size) {
            String tmp = this.currentGenotype(h);
            int h2 = 0;
            while (h2 < tmp.length()) {
                int n = this.nucNumber(tmp.charAt(h2));
                result[n] = result[n] + 1;
                ++h2;
            }
            ++h;
        }
        return result;
    }

    public int nucNumber(char nuc) {
        switch (nuc) {
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                return 0;
            }
            case 'C': 
            case 'c': {
                return 1;
            }
            case 'A': 
            case 'a': {
                return 2;
            }
            case 'G': 
            case 'g': {
                return 3;
            }
        }
        return 4;
    }

    public double frequency() {
        return this.count1() / this.sum();
    }

    public double sum() {
        int[] tmp = this.count();
        return tmp[0] + tmp[1] + tmp[2] + tmp[3];
    }

    public double count1() {
        int org = this.nucNumber(this.nuc1());
        int[] tmp = this.count();
        return tmp[org];
    }

    public double[] counts() {
        double[] result = new double[]{this.count1(), this.sum()};
        return result;
    }
}

