#include <stdio.h>
#include <stdlib.h>

#include "snp_MCMC.h"
#include "snp_Factorial.h"
#include "snp_Config.h"
#include "snp_MemoryControl.h"


void MCMCMain()
{
    int a1 = 66,    /* case */
        a2 = 50;
    int b1 = 90,    /* control */
        b2 = 50;
    int i = 0;
    int m = 0;
    int retval = 0;

    double gen = 1000;
    double Score = 0;
    double S = 0;
    Table T;

    /* loge[u쐬 */
    if (FactorialSetFactorial(a1 + a2 + b1 + b2) != 0){
        goto finalize;
    }
	retval = TableMakeTable4Int(&T, a1, a2, b1, b2);
    Score = TableCalcScore(TableGetTable(T));
    retval = TableNewTable(T, 75, TableGetTable(T));

    for (m = 0; m < gen; m++){
        MCMCMarkov2(T, Score);
        S = TableCalcScore(TableGetTable(T));
        printf("%d\t%.16f\n", T.table[0][0], S);
    }

finalize:;
    /* loge[uNA */
    FactorialDeleteFactorial();
    /* \tablẽJ */
    TableFinalTable(&T);

#ifdef DBG
    //test
    printf("%d\n", getMallocCount());
#endif

    return;
}

/* one region */
void MCMCMarkov1(Table T, double Score)
{
    int a1 = 0,
        a2 = 0;
    int b1 = 0,
        b2 = 0;
    int u = 0;
    int l = 0;
    int i = 0;
    int j = 0;
    int retval = 0;

    double y = 0,
           y2 = 0;

    int **X = NULL;
    int **newX = NULL;

    X = TableGetTable(T);
    a1 = X[0][0];
    
    i = MCMCPlusMinusOne();
    a1 += i;

    u = TableCalcU(T);
    l = TableCalcL(T);

    /* new candidate */
    if ( (a1 < l) || (a1 > u) ){
        return; //unchanged
    }
    /* newX̃m */
    newX = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == newX) { goto finalize; }

    retval = TableNewCandidate(T, a1, newX);
    a2 = newX[0][1];
    b1 = newX[1][0];
    b2 = newX[1][1];

    if (FLAG_TRUE == TableInCj(Score, newX, ROW, COLUMN)){ /* condition 5 */
        if (1 == i){
            y = (b1 * a2) / ( (double) (a1 + 1) * (b2 + 1) );
        }
        if (-1 == i){
            y = (a1 * b2) / ( (double) (b1 + 1) * (a2 + 1) );
        }
        /* mcmc transition */
        if (y >= 1){ /* procedure 6 */
            retval = TableNewTable(T, a1, TableGetTable(T));
        }
        else{
            //y2 = (double)rand() / RAND_MAX;
            y2 = ran2(&idum);
            if (y >= y2){ /* procedere 7 */
                retval = TableNewTable(T, a1, TableGetTable(T));
            }
        }
    }

finalize:;
    /* mۂJ */
    freeInt2Dim(newX, ROW);
}

/* two regions */
void MCMCMarkov2(Table T, double Score)
{
    int a1 = 0,
        a2 = 0;
    int b1 = 0,
        b2 = 0;
    int i = 0;
    int j = 0;
    int flag = 0;
    int oldA1 = 0,
        newA1 = 0;
    int retval = 0;

    double y = 0,
           y2 = 0;
    double z = 0,
           z2 = 0;

    int **X = NULL;
    int **newX = NULL;
    int **oldA1X = NULL;
    int **newA1X = NULL;

    X = TableGetTable(T);
    a1 = X[0][0];
    i = MCMCPlusMinusOne();
    a1 += i;

    /* new candidate */
    /* newX̃m */
    newX = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == newX) { goto finalize; }

    retval = TableNewCandidate(T, a1, newX);
    a2 = newX[0][1];
    b1 = newX[1][0];
    b2 = newX[1][1];
    flag = TableJudgeCj(Score, newX, ROW, COLUMN);

    if (WITH_IN_RANGE == flag){ /* condition 5 */
        if (1 == i){
            y = (b1 * a2) / ( (double) (a1 + 1) * (b2 + 1) );
        }
        if (-1 == i){
            y = (a1 * b2) / ( (double) (b1 + 1) * (a2 + 1) );
        }
        /* mcmc transition */
        if (y >= 1){ /* procedure 6 */
            retval = TableNewTable(T, a1, TableGetTable(T));
        }
        else{
            //y2 = (double)rand() / RAND_MAX;  /* 01̗ */
            y2 = ran2(&idum);
            if (y >= y2){ /* procedere 7 */
                retval = TableNewTable(T, a1, TableGetTable(T));
            }
        }
    }
    if (IN_BETWEEN == flag){ /* leap to the other island */
        oldA1 = T.table[0][0];
        newA1 = oldA1;

        /* oldA1X̃m */
        oldA1X = (int**)mallocInt2Dim(ROW, COLUMN);
        if (NULL == oldA1X) { goto finalize; }
        /* newA1X̃m */
        newA1X = (int**)mallocInt2Dim(ROW, COLUMN);
        if (NULL == newA1X) { goto finalize; }


        if (1 == i){ /* leap from w to v */
            newA1 = TableCalcW(T, Score);
            retval = TableNewCandidate(T, oldA1, oldA1X);
            retval = TableNewCandidate(T, newA1, newA1X);
            z = TableCalcR(oldA1X, ROW, COLUMN, newA1X);
        }
        if (-1 == i){ /* leap from v to w */
            newA1 = TableCalcV(T, Score);
            retval = TableNewCandidate(T, oldA1, oldA1X);
            retval = TableNewCandidate(T, newA1, newA1X);
            z = TableCalcR(oldA1X, ROW, COLUMN, newA1X);
        }
        
        if (z > 1){
            retval = TableNewTable(T, newA1, TableGetTable(T));
        }
        else{
            //z2 = (double)rand() / RAND_MAX;  /* 01̗ */
            z2 = ran2(&idum);
            if (z >= z2){ /* leap */
                retval = TableNewTable(T, newA1, TableGetTable(T));
            }
        }

        /* J */
        //freeInt2Dim(oldA1X, ROW);
        //freeInt2Dim(newA1X, ROW);
    }

finalize:;
    /* mۂJ */
    freeInt2Dim(newX, ROW);
    freeInt2Dim(oldA1X, ROW);
    freeInt2Dim(newA1X, ROW);
}

int MCMCPlusMinusOne()
{
    /* return -1 or 1 with probability 0.5 */
    int result = 0;

    result = (int)(ran2(&idum) * 2) * 2 - 1;

    return result;
}
