#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "snp_Q.h"
#include "snp_Permutation.h"
#include "snp_Table.h"
#include "snp_Config.h"
#include "snp_MemoryControl.h"


void QMain()
{
    char *caseSequence[CASE] = {"ATAATTTAC",
                                "ACGGCCGGT",
                                "GTAATTTAT"};
    char *controlSequence[CONTROL] = {"ATAATTTAT",
                                      "GTAATTTAC",
                                      "ATAATTTAT"};
    int a = CASE;       /* the number of cases */
    int b = CONTROL;    /* the number of controls */
    int n = a + b;      /* sample size */

    char **sequence = NULL;
    int *type = NULL;
    int *observedOrder = NULL;
    int *omega = NULL;
    int *di = NULL;
    int **genotype = NULL;
    int ***Tj = NULL;

    int h = 0;
    int i = 0;
    int j = 0;
    int m = 0;
    int retval = 0;
    int sequenceLength = 0;
    int gen = 100;
    double Smax = 0;

    sequenceLength = strlen(caseSequence[0]);

    /* sequencẽm */
    sequence = (char**)mallocChar2Dim(n, sequenceLength);
    if (NULL == sequence) { goto finalize; }
    /* typẽm */
    type = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == sequence) { goto finalize; }
    /* observedOrder̃m */
    observedOrder = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == observedOrder) { goto finalize; }

    for (h = 0; h < n; h++){
        if ( (0 <= h) && (h < a) ){ /* case */
            strcpy(sequence[h], caseSequence[h]);
            type[h] = 1;
        }
        if ( (a <= h) && (h < n) ){ /* control */
            strcpy(sequence[h], controlSequence[h-a]);
            type[h] = 0;
        }
        observedOrder[h] = h;
    }

    /* genotypẽm */
    genotype = (int**)mallocInt2Dim(sequenceLength, n);
    if (NULL == genotype) { goto finalize; }

    retval = PermutationCalcGenotype(sequence, n, genotype);
    m = sequenceLength;

    /* Tj̃m */
    Tj = (int***)mallocInt3Dim(m, ROW, COLUMN);
    if (NULL == Tj) { goto finalize; }

    for (j = 0; j < m; j++){
        retval = PermutationCalcT(type, genotype[j], Tj[j], n);
    }
    Smax = QCalcSmax(Tj, m);

    /* omegãm */
    omega = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == omega) { goto finalize; }
    /* dĩm */
    di = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == di) { goto finalize; }

    for (i = 0; i < gen; i++){
        retval = PermutationCalcOmega(n, omega);
        retval = PermutationCalcDi(n, a, omega, di);
        printf("%d\n", QCalcQvalue(sequence, di, Smax, n));
    }

finalize:;
    /* mۂJ */
    freeChar2Dim(sequence, n);
    free1Dim(type);
	free1Dim(observedOrder);
	freeInt2Dim(genotype, sequenceLength);
    freeInt3Dim(Tj, m, ROW);
    free1Dim(omega);
    free1Dim(di);

#ifdef DBG
    //test
    printf("%d\n", getMallocCount());
#endif

    return;
}

double QCalcSmax(int ***Tj, int sequenceLength)
{
    int j = 0;
    int retval = 0;
    double Smax = 0;
    double *Sj = NULL;

    /* Sj̃m */
    Sj = (double*)malloc1Dim(sizeof(double), sequenceLength);
    if (NULL == Sj) { goto finalize; }

    retval = QCalcSj(Tj, sequenceLength, Sj);

    for(j = 0; j < sequenceLength; j++){
        if (Sj[j] > Smax){
            Smax = Sj[j];
        }
    }

finalize:;
    /* mۂJ */
    free1Dim(Sj);

    return Smax;
}

int QCalcSj(int ***Tj, int sequenceLength, double *result)
{
    int j = 0;

    for(j = 0; j < sequenceLength; j++){
        result[j] = TableCalcScore(Tj[j]);
    }

    return 0;
}

int QCalcQvalue(char **sequence, int *di, double Sobs, int n)
{
    int i = 0;
    int c1 = 0;
    int retval = 0;
    int result = 0;
    int sequenceLength = 0;
    int *genotype = NULL;
    int **T = NULL;
    double S = 0;

    sequenceLength = strlen(sequence[0]);

    /* genotypẽm */
    genotype = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == genotype) { goto finalize; }
    /* T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T){ goto finalize; }

    for (c1 = 0; c1 < sequenceLength; c1++){
        /* genotype0ŏ */
        for (i = 0; i < n; i++){
            genotype[i] = 0;
        }
        for (i = 0; i < n; i++){
            if (sequence[i][c1] == sequence[0][c1]){
                genotype[i] = 0;
            }
            else{
                genotype[i] = 1;
            }
        }
        retval = PermutationCalcT(di, genotype, T, n);
        S = TableCalcScore(T);
        if (S >= Sobs){
            result++;
        }
    }
finalize:;
    /* mۂJ */
	free1Dim(genotype);
    freeInt2Dim(T, ROW);

    return result;
}
