/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_DATA_READER__
#define __HEADER_FILE_DATA_READER__

#include "snp_Config.h"
#include "snp_Table.h"

/* Hapmapf[^i[p\ */
typedef struct struct_HapmapData { 
	char rsNumber[RS_NUM_LEN];      /* rs# */ 
	char SNPalleles[SNP_COUNT];     /* SNPalleles */
    char chrom[CHROM_LEN];          /* chrom */
    long pos;                       /* pos */
	char SNPdata[SNP_DATA_LEN];     /* SNPf[^i[p */
    int allelesNum;                 /* SNPalleles̃p^[ */
    int dataNum;                    /* Hapmapf[^̐l */
    int SNPallelesCount[SNP_COUNT]; /* SNPallelesƍvf[^ */
    int missingDataCount;           /* MissingData(N)̃f[^ */
} HapmapData;

/* vg^Cv錾 */
/* ̓t@CJ */
int InputFileOpen(FILE **fp, char *file);
/* o̓t@CJ */
int OutputFileOpen(FILE **fp, char *file);
/* t@C */
void FileClose(FILE *fp);
/* t@C̍sJEg */
long DataReaderCountFileLine(FILE *fp);
/* Hapmapf[^\̂Ɏ߂ */
int DataReaderSetAllHapmapData(FILE *fp, HapmapData *hapmap, long line);
/* Hapmapf[^s\̂Ɏ߂ */
int DataReaderSetHapmapData(FILE *fp, HapmapData *hapmap, long line);
/* \̃f[^t@Cɏo͂ */
void DataReaderOutputAllData(FILE *fp, HapmapData *hapmap, long line);
/* \̃f[^t@Cɏo͂ */
void DataReaderOutputData(FILE *fp, HapmapData *hapmap);
/* ̓f[^\̂Ɏ߂ */
int DataReaderSetInputData(char *filename, InputData *inputData);
/* slԂ */
int DataReaderGetValue(FILE *fp, char *key, char *value);
/* QHapmapf[^SNPalleles̏Ԃ`FbNA􌻕\쐬 */
int DataReaderCheckSNPalleles(HapmapData *hapmap1, HapmapData *hapmap2, int **T);
/* ̓t@C̏t@Cɏo͂ */
void DataReaderOutputHeader(FILE *fp, InputData *inputData);
/* 茋ʂt@Cɏo͂ */
void DataReaderOutputResult(int level,
                            FILE *fp,
                            HapmapData *hapmap1,
                            HapmapData *hapmap2,
                            Table *tbl,
                            double Sobs,
                            double Pr,
                            double Hj,
                            double F,
                            double p,
                            int count,
                            long repeat);
/* 茋ʃt@Cóilevel0j */
void DataReaderOutputResultLevel0(FILE *fp,
                                  HapmapData *hapmap1,
                                  HapmapData *hapmap2,
                                  Table *tbl,
                                  double Sobs,
                                  double Pr,
                                  double Hj,
                                  double F,
                                  double p,
                                  int count,
                                  long repeat);
/* 茋ʃt@Cóilevel1j */
void DataReaderOutputResultLevel1(FILE *fp,
                                  HapmapData *hapmap1,
                                  HapmapData *hapmap2,
                                  Table *tbl,
                                  double Sobs,
                                  double p);


#endif /* __HEADER_FILE_DATA_READER__ */
