package sequence;

public class gamrand{ 
    ran1 random1;
    ran1 random2;
    double alpha;
    double e;

	
    public gamrand(double alpha0){ 
        random1 = new ran1();
        random2 = new ran1();
        random1.randomize();
        random2.randomize();
        alpha = alpha0;
        e = Math.E;
    }
 
    double below1( ){ 
        double u1, u2, b, p, x;
        b = ( e + alpha ) / e ;
        for(;;){
            u1 = random1.value();
            p = b * u1;
            if( p <= 1 ){
                x = Math.exp( Math.log(p) / alpha );
                u2 = random2.value();
                if ( u2 <= Math.exp( -1.0*x ) ) return x/alpha;
            }else{
                x = -1.0 * Math.log( (b-p) / alpha );
                u2 = random2.value();
                if ( u2 <= Math.exp( (alpha-1) * Math.log(x) ) ) return x/alpha;
            }
        }
    }
 
    double above1( ){ 
        double x;
        double b = alpha-1;
        double A = alpha+b;
        double s = Math.sqrt(A);
        for(;;){
            double u1 = random1.value();
            double t = s * Math.tan(Math.PI*(u1-0.5));
            x = b+t;
            if( x>=0 ){
                double u2 = random2.value();
                if ( u2 <= Math.exp( b*Math.log(x/b) - t +Math.log(1+t*t/A) ) ) return x/alpha;
            }
        }
    }

 
    public double value( ){ 
        if ( Double.isInfinite(alpha) ) return 1;
        if (alpha<=1) return below1();
        if (alpha>1) return above1();
        return 1;
    }
}
  

