/*
 * Decompiled with CFR 0.152.
 */
package permutation;

import permutation.Factorial;

public class Table {
    int[] horizontalSum;
    int[] verticalSum;
    Factorial fact;
    int[][] table;
    double r;
    static int outOfRange = 1;
    static int inBetween = 2;
    static int withinRange = 0;

    public static void main(String[] args) {
        int a1 = 66;
        int a2 = 34;
        int b1 = 90;
        int b2 = 10;
        Table T = new Table(a1, a2, b1, b2);
        int l = T.l();
        int u = T.u();
        double Sobs = 11.0;
        int v = T.v(Sobs);
        int w = T.w(Sobs);
        try {
            int i = l;
            while (i <= u) {
                int[][] result = T.newTable(i);
                System.out.print(String.valueOf(i) + "\t" + Table.PearsonScore(result));
                if (i < v || i > w) {
                    System.out.print("\t" + T.nu(Sobs, result));
                }
                System.out.println();
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("OutOfBounds");
        }
    }

    public Table(int a1, int a2, int b1, int b2) {
        this.table = new int[2][2];
        this.table[0][0] = a1;
        this.table[0][1] = a2;
        this.table[1][0] = b1;
        this.table[1][1] = b2;
        this.horizontalSum = new int[2];
        this.horizontalSum[0] = a1 + a2;
        this.horizontalSum[1] = b1 + b2;
        this.verticalSum = new int[2];
        this.verticalSum[0] = a1 + b1;
        this.verticalSum[1] = a2 + b2;
        int n = a1 + a2 + b1 + b2;
        this.fact = new Factorial(n);
    }

    public Table(int[][] T) {
        int a1 = T[0][0];
        int a2 = T[0][1];
        int a = a1 + a2;
        int b1 = T[1][0];
        int b2 = T[1][1];
        int b = b1 + b2;
        int n1 = a1 + b1;
        int n2 = a2 + b2;
        int n = n1 + n2;
        this.table = new int[2][2];
        this.table[0][0] = a1;
        this.table[0][1] = a2;
        this.table[1][0] = b1;
        this.table[1][1] = b2;
        this.horizontalSum = new int[2];
        this.horizontalSum[0] = a1 + a2;
        this.horizontalSum[1] = b1 + b2;
        this.verticalSum = new int[2];
        this.verticalSum[0] = a1 + b1;
        this.verticalSum[1] = a2 + b2;
        this.fact = new Factorial(n);
    }

    public int[][] table() {
        return this.table;
    }

    public int[][] newCandidate(int a1) throws ArrayIndexOutOfBoundsException {
        int horizontalSize = this.horizontalSum.length;
        int verticalSise = this.verticalSum.length;
        if (a1 < 0) {
            throw new ArrayIndexOutOfBoundsException("negative value");
        }
        if (a1 > this.horizontalSum[0]) {
            throw new ArrayIndexOutOfBoundsException("too large");
        }
        if (a1 > this.verticalSum[0]) {
            throw new ArrayIndexOutOfBoundsException("too large");
        }
        int[][] result = new int[verticalSise][horizontalSize];
        result[0][0] = a1;
        result[0][1] = this.horizontalSum[0] - a1;
        result[1][0] = this.verticalSum[0] - a1;
        result[1][1] = this.horizontalSum[1] - result[1][0];
        return result;
    }

    public int[][] newTable(int a1) throws ArrayIndexOutOfBoundsException {
        this.table = this.newCandidate(a1);
        return this.table;
    }

    public int l() {
        int result = this.horizontalSum[0] - this.verticalSum[1];
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public int u() {
        int result = this.horizontalSum[0];
        if (result > this.verticalSum[0]) {
            result = this.verticalSum[0];
        }
        return result;
    }

    public static double PearsonScore(int[][] T) {
        int a1 = T[0][0];
        int a2 = T[0][1];
        int a = a1 + a2;
        int b1 = T[1][0];
        int b2 = T[1][1];
        int b = b1 + b2;
        int n1 = a1 + b1;
        int n2 = a2 + b2;
        int n = n1 + n2;
        return (double)n * (double)(a1 * b2 - a2 * b1) * (double)(a1 * b2 - a2 * b1) / (double)(a * b * n1 * n2);
    }

    public int v(double Sobs) {
        int n1 = this.verticalSum[0];
        int a = this.horizontalSum[0];
        int b = this.horizontalSum[1];
        double n = a + b;
        int result = (int)((double)(n1 * a) / n - this.rootD(Sobs) / n) + 1;
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public int w(double Sobs) {
        int n1 = this.verticalSum[0];
        int a = this.horizontalSum[0];
        int b = this.horizontalSum[1];
        double n = a + b;
        int result = (int)((double)(n1 * a) / n + this.rootD(Sobs) / n);
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public double rootD(double Sobs) {
        return Math.sqrt(this.discriminant(Sobs));
    }

    public double discriminant(double Sobs) {
        int a = this.horizontalSum[0];
        int b = this.horizontalSum[1];
        int n1 = this.verticalSum[0];
        int n2 = this.verticalSum[1];
        int n = a + b;
        return Sobs * (double)a * (double)b * (double)n1 * (double)n2 / (double)n;
    }

    public boolean twoParts(double Sobs) {
        if (this.discriminant(Sobs) <= 0.0) {
            return false;
        }
        return this.v(Sobs) > this.l() && this.w(Sobs) < this.u();
    }

    public static double Fst(int[][] T) {
        double a1 = T[0][0];
        double a2 = T[0][1];
        double a = a1 + a2;
        double b1 = T[1][0];
        double b2 = T[1][1];
        double b = b1 + b2;
        double n1 = a1 + b1;
        double n2 = a2 + b2;
        double n = n1 + n2;
        double p = a / n;
        double p1 = a1 / n1;
        double p2 = a2 / n2;
        double Hs = 0.5 * (p1 * (1.0 - p1) + p2 * (1.0 - p2));
        double Ht = p * (1.0 - p);
        double Fst = 1.0 - Hs / Ht;
        return Fst;
    }

    public static void showMatrix(int[][] data) {
        int i = 0;
        while (i < data.length) {
            Table.showVector(data[i]);
            ++i;
        }
        System.out.println();
    }

    public static void showVector(int[] data) {
        int h = 0;
        while (h < data.length) {
            System.out.print(data[h]);
            System.out.print("\t");
            ++h;
        }
        System.out.println();
    }

    public double mu(int[][] T) {
        int a1 = T[0][0];
        int a2 = T[0][1];
        int a = a1 + a2;
        int b1 = T[1][0];
        int b2 = T[1][1];
        int b = b1 + b2;
        int n1 = a1 + b1;
        int n2 = a2 + b2;
        int n = n1 + n2;
        return Math.exp(this.fact.logCombination(n1, a1) + this.fact.logCombination(n2, a2));
    }

    public double nu(double Sobs, int[][] T) {
        double S = Table.PearsonScore(T);
        if (S > Sobs) {
            return this.mu(T);
        }
        return 0.0;
    }

    public static boolean inCj(double Sobs, int[][] T) {
        int i = 0;
        while (i < T.length) {
            int j = 0;
            while (j < T[i].length) {
                if (T[i][j] < 0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        double S = Table.PearsonScore(T);
        return S >= Sobs;
    }

    public static int Cj(double Sobs, int[][] T) {
        int i = 0;
        while (i < T.length) {
            int j = 0;
            while (j < T[i].length) {
                if (T[i][j] < 0) {
                    return outOfRange;
                }
                ++j;
            }
            ++i;
        }
        double S = Table.PearsonScore(T);
        if (S >= Sobs) {
            return withinRange;
        }
        return inBetween;
    }

    public double r(int[][] T1, int[][] T2) {
        double logNum = 0.0;
        double logDen = 0.0;
        int i = 0;
        while (i < T1.length) {
            int j = 0;
            while (j < T1[i].length) {
                logNum += this.fact.logFactorial(T1[i][j]);
                logDen += this.fact.logFactorial(T1[i][j]);
                ++j;
            }
            ++i;
        }
        double logResult = logNum - logDen;
        return Math.exp(logResult);
    }
}

